/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.dom;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementsNavigationManager;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.stubs.index.DomElementClassIndex;
import com.intellij.util.xml.stubs.index.DomNamespaceKeyIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringDomUtils {
    public static final Condition<PsiFileSystemItem> SPRING_XML_CONDITION = item -> {
        if (item.isDirectory()) {
            return false;
        }
        PsiFile file = item.getContainingFile();
        return file instanceof XmlFile && SpringDomUtils.isSpringXml((XmlFile)file);
    };

    public static void navigate(@Nullable DomElement domElement) {
        if (domElement == null) {
            return;
        }
        DomElementsNavigationManager navigationManager = DomElementsNavigationManager.getManager((Project)domElement.getManager().getProject());
        navigationManager.getDomElementsNavigateProvider(DomElementsNavigationManager.DEFAULT_PROVIDER_NAME).navigate(domElement, true);
    }

    public static boolean isSpringXml(@NotNull XmlFile configFile) {
        if (configFile == null) {
            SpringDomUtils.$$$reportNull$$$0(0);
        }
        return SpringDomUtils.getSpringDomFileElement(configFile) != null;
    }

    @Nullable
    public static DomFileElement<Beans> getSpringDomFileElement(@NotNull XmlFile configFile) {
        DomFileElement fileElement;
        if (configFile == null) {
            SpringDomUtils.$$$reportNull$$$0(1);
        }
        return (fileElement = DomManager.getDomManager((Project)configFile.getProject()).getFileElement(configFile, Beans.class)) != null && fileElement.isValid() ? fileElement : null;
    }

    public static boolean hasNamespace(DomFileElement domFileElement, String namespaceKey) {
        return DomNamespaceKeyIndex.getInstance().hasStubElementsWithNamespaceKey(domFileElement, namespaceKey);
    }

    public static boolean hasElement(DomFileElement domFileElement, Class<? extends DomElement> domElementClazz) {
        return DomElementClassIndex.getInstance().hasStubElementsOfType(domFileElement, domElementClazz);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "configFile";
        objectArray2[1] = "com/intellij/spring/dom/SpringDomUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSpringXml";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpringDomFileElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

