/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u00020\u0004:\u0001\u001bB/\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0014\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J \u0010\u0013\u001a\u00020\u00102\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0019\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u00122\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u001c\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u000e0\r2\u0006\u0010\u0018\u001a\u00020\u0002H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/spring/mvc/AsyncCache;", "K", "Lcom/intellij/openapi/util/UserDataHolder;", "T", "", "modificationTracker", "Ljava/util/function/Function;", "Lcom/intellij/openapi/util/ModificationTracker;", "eval", "<init>", "(Ljava/util/function/Function;Ljava/util/function/Function;)V", "key", "Lcom/intellij/openapi/util/Key;", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/spring/mvc/AsyncCache$Stored;", "isCancelled", "", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "isActual", "stored", "modCount", "", "computeOrGet", "dataHolder", "(Lcom/intellij/openapi/util/UserDataHolder;)Lorg/jetbrains/concurrency/AsyncPromise;", "createOrGetRef", "Stored", "intellij.spring.mvc.impl"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nAsyncCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncCache.kt\ncom/intellij/spring/mvc/AsyncCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public final class AsyncCache<K extends UserDataHolder, T> {
    @NotNull
    private final Function<K, ModificationTracker> modificationTracker;
    @NotNull
    private final Function<K, T> eval;
    @NotNull
    private final Key<AtomicReference<Stored<T>>> key;

    public AsyncCache(@NotNull Function<K, ModificationTracker> modificationTracker, @NotNull Function<K, T> eval) {
        Intrinsics.checkNotNullParameter(modificationTracker, (String)"modificationTracker");
        Intrinsics.checkNotNullParameter(eval, (String)"eval");
        this.modificationTracker = modificationTracker;
        this.eval = eval;
        Key key = Key.create((String)("AsyncCache" + System.identityHashCode(this)));
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        this.key = key;
    }

    private final boolean isCancelled(AsyncPromise<?> promise) {
        if (promise.isCancelled()) {
            return true;
        }
        if (!Promises.isRejected((Promise)((Promise)promise))) {
            return false;
        }
        try {
            promise.get();
        }
        catch (ProcessCanceledException e) {
            return true;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ProcessCanceledException) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private final boolean isActual(Stored<T> stored, long modCount) {
        return stored != null && stored.getModCount() == modCount && !this.isCancelled(stored.getPromise());
    }

    @NotNull
    public final AsyncPromise<T> computeOrGet(@NotNull K dataHolder) {
        Intrinsics.checkNotNullParameter(dataHolder, (String)"dataHolder");
        long modCount = this.modificationTracker.apply(dataHolder).getModificationCount();
        AtomicReference<Stored<T>> ref = this.createOrGetRef((UserDataHolder)dataHolder);
        Stored<T> stored = ref.get();
        if (this.isActual(stored, modCount)) {
            return stored.getPromise();
        }
        Stored newStored = new Stored(new AsyncPromise(), modCount);
        Stored<T> curStored = stored;
        while (!ref.compareAndSet(curStored, newStored)) {
            ProgressManager.checkCanceled();
            curStored = ref.get();
            if (!this.isActual(curStored, modCount)) continue;
            return curStored.getPromise();
        }
        AsyncPromise promise = newStored.getPromise();
        try {
            promise.setResult(this.eval.apply(dataHolder));
        }
        catch (Exception e) {
            promise.setError((Throwable)e);
            throw e;
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AtomicReference<Stored<T>> createOrGetRef(UserDataHolder dataHolder) {
        AtomicReference atomicReference = (AtomicReference)dataHolder.getUserData(this.key);
        if (atomicReference != null) {
            AtomicReference it = atomicReference;
            boolean bl = false;
            return it;
        }
        Key<AtomicReference<Stored<T>>> key = this.key;
        synchronized (key) {
            block5: {
                boolean bl = false;
                AtomicReference atomicReference2 = (AtomicReference)dataHolder.getUserData(this.key);
                if (atomicReference2 == null) break block5;
                AtomicReference it = atomicReference2;
                boolean bl2 = false;
                AtomicReference atomicReference3 = it;
                return atomicReference3;
            }
            AtomicReference<Stored<T>> atomicReference4 = new AtomicReference<Stored<T>>();
            dataHolder.putUserData(this.key, atomicReference4);
            AtomicReference<Stored<T>> atomicReference5 = atomicReference4;
            return atomicReference5;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\u0004\b\u0002\u0010\u00012\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00020\u0004H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J)\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00020\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/spring/mvc/AsyncCache$Stored;", "T", "", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "modCount", "", "<init>", "(Lorg/jetbrains/concurrency/AsyncPromise;J)V", "getPromise", "()Lorg/jetbrains/concurrency/AsyncPromise;", "getModCount", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.spring.mvc.impl"})
    private static final class Stored<T> {
        @NotNull
        private final AsyncPromise<T> promise;
        private final long modCount;

        public Stored(@NotNull AsyncPromise<T> promise, long modCount) {
            Intrinsics.checkNotNullParameter(promise, (String)"promise");
            this.promise = promise;
            this.modCount = modCount;
        }

        @NotNull
        public final AsyncPromise<T> getPromise() {
            return this.promise;
        }

        public final long getModCount() {
            return this.modCount;
        }

        @NotNull
        public final AsyncPromise<T> component1() {
            return this.promise;
        }

        public final long component2() {
            return this.modCount;
        }

        @NotNull
        public final Stored<T> copy(@NotNull AsyncPromise<T> promise, long modCount) {
            Intrinsics.checkNotNullParameter(promise, (String)"promise");
            return new Stored<T>(promise, modCount);
        }

        public static /* synthetic */ Stored copy$default(Stored stored, AsyncPromise asyncPromise, long l, int n, Object object) {
            if ((n & 1) != 0) {
                asyncPromise = stored.promise;
            }
            if ((n & 2) != 0) {
                l = stored.modCount;
            }
            return stored.copy(asyncPromise, l);
        }

        @NotNull
        public String toString() {
            return "Stored(promise=" + this.promise + ", modCount=" + this.modCount + ")";
        }

        public int hashCode() {
            int result = this.promise.hashCode();
            result = result * 31 + Long.hashCode(this.modCount);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Stored)) {
                return false;
            }
            Stored stored = (Stored)other;
            if (!Intrinsics.areEqual(this.promise, stored.promise)) {
                return false;
            }
            return this.modCount == stored.modCount;
        }
    }
}

