/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.functional.webClient.test;

import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.jvm.cache.SourceTestLibSearcher;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.mvc.SpringMvcBundle;
import com.intellij.spring.mvc.functional.webClient.WebClientFramework;
import com.intellij.spring.mvc.functional.webClient.WebClientHolder;
import com.intellij.spring.mvc.functional.webClient.WebClientUrl;
import com.intellij.spring.mvc.functional.webClient.WebClientUtilsKt;
import com.intellij.spring.mvc.functional.webClient.test.WebTestClientModel;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00102\u0006\u0010\u0015\u001a\u00020\u0006H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/intellij/spring/mvc/functional/webClient/test/WebTestClientFramework;", "Lcom/intellij/spring/mvc/functional/webClient/WebClientFramework;", "<init>", "()V", "myHoldersSearcher", "Lcom/intellij/microservices/jvm/cache/SourceTestLibSearcher;", "Lcom/intellij/spring/mvc/functional/webClient/WebClientHolder;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "project", "Lcom/intellij/openapi/project/Project;", "getEndpointGroups", "", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getEndpoints", "Lcom/intellij/spring/mvc/functional/webClient/WebClientUrl;", "group", "intellij.spring.mvc.impl"})
public final class WebTestClientFramework
extends WebClientFramework {
    @NotNull
    private final SourceTestLibSearcher<WebClientHolder> myHoldersSearcher = new SourceTestLibSearcher("SPRING_WEB_TEST_CLIENT_FILES", (Function2)new Function2<Module, GlobalSearchScope, Set<? extends WebClientHolder>>((Object)WebTestClientModel.INSTANCE){

        public final Set<WebClientHolder> invoke(Module p0, GlobalSearchScope p1) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            return ((WebTestClientModel)this.receiver).findHolders(p0, p1);
        }
    });
    @NotNull
    private final FrameworkPresentation presentation;

    public WebTestClientFramework() {
        String string = SpringMvcBundle.message("spring.reactive.web.test.client.endpoints.view.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.presentation = new FrameworkPresentation("Spring-WebTestClient", string, SpringApiIcons.SpringWeb);
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!WebClientUtilsKt.isWebTestClientAvailable(project)) {
            return EndpointsProvider.Status.UNAVAILABLE;
        }
        return EndpointsProvider.Status.AVAILABLE;
    }

    @NotNull
    public Iterable<WebClientHolder> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (!(filter instanceof ModuleEndpointsFilter)) {
            return CollectionsKt.emptyList();
        }
        if (!WebClientUtilsKt.isWebTestClientAvailable(((ModuleEndpointsFilter)filter).getModule())) {
            return CollectionsKt.emptyList();
        }
        return this.myHoldersSearcher.iterable(((ModuleEndpointsFilter)filter).getModule(), ((ModuleEndpointsFilter)filter).getFromTests(), ((ModuleEndpointsFilter)filter).getFromLibraries());
    }

    @NotNull
    public Iterable<WebClientUrl> getEndpoints(@NotNull WebClientHolder group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        return WebTestClientModel.INSTANCE.getEndpoints(group);
    }
}

