/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.views;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.paths.GlobalPathReferenceProvider;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.spring.mvc.SpringMVCReference;
import com.intellij.spring.mvc.views.ViewReference;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringMVCViewReferenceProvider
extends PsiReferenceProvider {
    private final boolean mySoft;
    private static final List<String> OUR_PREFIXES = Arrays.asList("redirect:", "forward:");

    public SpringMVCViewReferenceProvider() {
        this(true);
    }

    public SpringMVCViewReferenceProvider(boolean soft) {
        this.mySoft = soft;
    }

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Module module;
        if (element == null) {
            SpringMVCViewReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SpringMVCViewReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringMVCViewReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        TextRange range = ElementManipulators.getValueTextRange((PsiElement)element);
        String text = range.substring(element.getText());
        SmartList references = new SmartList();
        boolean prefixed = SpringMVCViewReferenceProvider.isPrefixed(text);
        if (prefixed && GlobalPathReferenceProvider.isWebReferenceUrl((String)(range = SpringMVCViewReferenceProvider.adjustRange(range, text, OUR_PREFIXES)).substring(element.getText()))) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new WebReference(element, range)};
            if (psiReferenceArray == null) {
                SpringMVCViewReferenceProvider.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        if (prefixed) {
            references.add(new SpringMVCReference(element, range, range.substring(element.getText()), this.mySoft));
        }
        if (!prefixed) {
            references.add(new ViewReference(element, range, this.mySoft));
        }
        PsiReference[] psiReferenceArray = references.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            SpringMVCViewReferenceProvider.$$$reportNull$$$0(4);
        }
        return psiReferenceArray;
    }

    private static boolean isPrefixed(String text) {
        return OUR_PREFIXES.stream().anyMatch(prefix -> text.startsWith((String)prefix));
    }

    private static TextRange adjustRange(TextRange range, String text, List<String> prefixes) {
        return prefixes.stream().filter(prefix -> text.startsWith((String)prefix)).findAny().map(prefix -> new TextRange(range.getStartOffset() + prefix.length(), range.getEndOffset())).orElse(range);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/views/SpringMVCViewReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/views/SpringMVCViewReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

