/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.views;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.mvc.SpringControllerUtils;
import com.intellij.spring.mvc.views.UrlBasedViewResolver;
import com.intellij.spring.mvc.views.ViewResolver;
import com.intellij.spring.mvc.views.ViewResolverFactory;
import com.intellij.spring.mvc.views.WithPrefixSuffix;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;

public class TemplateViewResolverFactory
extends ViewResolverFactory {
    private final String myBeanClass;
    private final String myConfigurerClass;
    private final String myLoaderProperty;
    private final String myDefaultSuffix;

    protected TemplateViewResolverFactory(String beanClass, String configurerClass, String loaderProperty, String defaultSuffix) {
        this.myBeanClass = beanClass;
        this.myConfigurerClass = configurerClass;
        this.myLoaderProperty = loaderProperty;
        this.myDefaultSuffix = defaultSuffix;
    }

    @Override
    public String getBeanClass() {
        return this.myBeanClass;
    }

    @Override
    @NotNull
    protected Set<ViewResolver> createViewResolvers(@Nullable CommonSpringBean bean, CommonSpringModel model) {
        Module module;
        Object object = model.getModule() != null ? model.getModule() : (module = bean != null ? bean.getModule() : null);
        if (module == null) {
            Set<ViewResolver> set = Collections.emptySet();
            if (set == null) {
                TemplateViewResolverFactory.$$$reportNull$$$0(0);
            }
            return set;
        }
        String prefix = SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)bean, (String)"prefix");
        String suffix = SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)bean, (String)"suffix");
        UrlBasedViewResolver resolver = SpringControllerUtils.createURLBasedViewResolver(module, this.getClass().getName(), "", prefix, suffix);
        PsiClass configurerClass = SpringCommonUtils.findLibraryClass((Module)module, (String)this.myConfigurerClass);
        if (configurerClass == null) {
            Set<ViewResolver> set = Collections.singleton(resolver);
            if (set == null) {
                TemplateViewResolverFactory.$$$reportNull$$$0(1);
            }
            return set;
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)configurerClass).withInheritors().effectiveBeanTypes();
        List configurers = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters);
        if (configurers.isEmpty()) {
            Set<ViewResolver> set = Collections.singleton(resolver);
            if (set == null) {
                TemplateViewResolverFactory.$$$reportNull$$$0(2);
            }
            return set;
        }
        HashSet<ViewResolver> resolvers = new HashSet<ViewResolver>();
        for (SpringBeanPointer configurerPointer : configurers) {
            CommonSpringBean configurer = configurerPointer.getSpringBean();
            if (configurer instanceof SpringBean || configurer instanceof ContextJavaBean) {
                String loaderPath = this.getLoaderPath(configurer, this.myLoaderProperty);
                if (loaderPath == null) continue;
                resolvers.add(SpringControllerUtils.createURLBasedViewResolver(module, this.getClass().getName(), loaderPath, ((WithPrefixSuffix)resolver).getPrefix(), ((WithPrefixSuffix)resolver).getSuffix()));
                continue;
            }
            resolvers.add(this.handleCustomConfigurer(configurer, resolver));
        }
        Set<ViewResolver> set = resolvers.isEmpty() ? Collections.singleton(resolver) : resolvers;
        if (set == null) {
            TemplateViewResolverFactory.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Nullable
    protected String getLoaderPath(@NotNull CommonSpringBean configurer, @NotNull String loaderProperty) {
        if (configurer == null) {
            TemplateViewResolverFactory.$$$reportNull$$$0(4);
        }
        if (loaderProperty == null) {
            TemplateViewResolverFactory.$$$reportNull$$$0(5);
        }
        return SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)configurer, (String)loaderProperty);
    }

    @NotNull
    protected ViewResolver handleCustomConfigurer(CommonSpringBean configurer, WithPrefixSuffix resolver) {
        WithPrefixSuffix withPrefixSuffix = resolver;
        if (withPrefixSuffix == null) {
            TemplateViewResolverFactory.$$$reportNull$$$0(6);
        }
        return withPrefixSuffix;
    }

    @Override
    @NotNull
    public Set<ViewResolver> handleResolversRegistry(String methodName, UCallExpression methodCallExpression, CommonSpringModel servletModel) {
        if (this.getViewResolverRegistryMethodName().equals(methodName)) {
            return this.getViewResolverRegistryViewResolvers(methodCallExpression, servletModel);
        }
        Set<ViewResolver> set = super.handleResolversRegistry(methodName, methodCallExpression, servletModel);
        if (set == null) {
            TemplateViewResolverFactory.$$$reportNull$$$0(7);
        }
        return set;
    }

    protected String getViewResolverRegistryMethodName() {
        return "";
    }

    @NotNull
    private Set<ViewResolver> getViewResolverRegistryViewResolvers(UCallExpression expression, CommonSpringModel springModel) {
        Module module = springModel.getModule();
        if (module == null) {
            Set<ViewResolver> set = Collections.emptySet();
            if (set == null) {
                TemplateViewResolverFactory.$$$reportNull$$$0(8);
            }
            return set;
        }
        PsiClass configurerClass = SpringCommonUtils.findLibraryClass((Module)module, (String)this.myConfigurerClass);
        if (configurerClass == null) {
            Set<ViewResolver> set = Collections.emptySet();
            if (set == null) {
                TemplateViewResolverFactory.$$$reportNull$$$0(9);
            }
            return set;
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)configurerClass).withInheritors().effectiveBeanTypes();
        List configurers = SpringModelSearchers.findBeans((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)searchParameters);
        if (configurers.size() != 1) {
            Set<ViewResolver> set = Collections.emptySet();
            if (set == null) {
                TemplateViewResolverFactory.$$$reportNull$$$0(10);
            }
            return set;
        }
        CommonSpringBean configurer = ((SpringBeanPointer)configurers.get(0)).getSpringBean();
        String prefix = SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)configurer, (String)this.myLoaderProperty);
        UrlBasedViewResolver viewResolver = new UrlBasedViewResolver(module, configurer.getBeanName() + ".handleViewResolverRegistry()", "", prefix, this.myDefaultSuffix);
        Set<ViewResolver> set = Collections.singleton(viewResolver);
        if (set == null) {
            TemplateViewResolverFactory.$$$reportNull$$$0(11);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/views/TemplateViewResolverFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loaderProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createViewResolvers";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/views/TemplateViewResolverFactory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "handleCustomConfigurer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "handleResolversRegistry";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewResolverRegistryViewResolvers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLoaderPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

