/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.image;

import com.intellij.jupyter.core.editor.settings.JupyterSettings;
import com.intellij.jupyter.core.jupyter.editor.outputs.image.ImageInvertType;
import com.intellij.jupyter.core.jupyter.editor.outputs.image.JupyterImageErrorLogger;
import com.intellij.notebooks.visualization.r.inlays.components.ImageInverter;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.Base64;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\"\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/image/ImageColorThemeInverter;", "", "<init>", "()V", "isDarkEditor", "", "isDarkEditor$intellij_jupyter_core", "()Z", "readImageFromBase64", "Ljava/awt/image/BufferedImage;", "data", "", "invertImageIfNeeded", "isJupyterSilent", "invertType", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/image/ImageInvertType;", "image", "intellij.jupyter.core"})
@ApiStatus.Internal
public final class ImageColorThemeInverter {
    @NotNull
    public static final ImageColorThemeInverter INSTANCE = new ImageColorThemeInverter();

    private ImageColorThemeInverter() {
    }

    public final boolean isDarkEditor$intellij_jupyter_core() {
        return !JBColor.isBright() && EditorColorsManager.getInstance().isDarkEditor() && JupyterSettings.Companion.getInstance().getInvertImageOutputsUnderDarkTheme();
    }

    @NotNull
    public final BufferedImage readImageFromBase64(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        byte[] bytes = Base64.getMimeDecoder().decode(data);
        BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(bytes));
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(...)");
        return bufferedImage;
    }

    @NotNull
    public final BufferedImage invertImageIfNeeded(@NotNull String data, boolean isJupyterSilent, @NotNull ImageInvertType invertType) {
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)invertType), (String)"invertType");
        try {
            BufferedImage image = this.readImageFromBase64(data);
            bufferedImage = this.invertImageIfNeeded(image, invertType);
        }
        catch (IllegalArgumentException e) {
            if (isJupyterSilent) {
                JupyterImageErrorLogger.INSTANCE.logWarn$intellij_jupyter_core("Attempt to decode image that is not valid base64 from jupyter silent mode");
            } else {
                Throwable throwable = e;
                String string = StringUtil.shortenTextWithEllipsis((String)data, (int)20, (int)0);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
                JupyterImageErrorLogger.INSTANCE.logError$intellij_jupyter_core(throwable, "Attempt to decode image that is not valid base64", string);
            }
            throw e;
        }
        return bufferedImage;
    }

    public static /* synthetic */ BufferedImage invertImageIfNeeded$default(ImageColorThemeInverter imageColorThemeInverter, String string, boolean bl, ImageInvertType imageInvertType, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            imageInvertType = ImageInvertType.AUTO;
        }
        return imageColorThemeInverter.invertImageIfNeeded(string, bl, imageInvertType);
    }

    private final BufferedImage invertImageIfNeeded(BufferedImage image, ImageInvertType invertType) {
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme colorScheme = editorColorsScheme;
        Color color = colorScheme.getDefaultForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultForeground(...)");
        Color color2 = colorScheme.getDefaultBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getDefaultBackground(...)");
        ImageInverter imageInverter = new ImageInverter(color, color2);
        boolean shouldInvert = switch (WhenMappings.$EnumSwitchMapping$0[invertType.ordinal()]) {
            case 1 -> false;
            case 2 -> true;
            case 3 -> {
                if (this.isDarkEditor$intellij_jupyter_core() && ImageInverter.shouldInvert$default((ImageInverter)imageInverter, (BufferedImage)image, (double)0.0, (int)2, null)) {
                    yield true;
                }
                yield false;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        return shouldInvert ? imageInverter.invert(image) : image;
    }

    static /* synthetic */ BufferedImage invertImageIfNeeded$default(ImageColorThemeInverter imageColorThemeInverter, BufferedImage bufferedImage, ImageInvertType imageInvertType, int n, Object object) {
        if ((n & 2) != 0) {
            imageInvertType = ImageInvertType.AUTO;
        }
        return imageColorThemeInverter.invertImageIfNeeded(bufferedImage, imageInvertType);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ImageInvertType.values().length];
            try {
                nArray[ImageInvertType.FORCE_LIGHT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageInvertType.FORCE_DARK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageInvertType.AUTO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

