/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oraplus;

import com.intellij.lang.ITokenTypeRemapper;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.oracle.OraParser;
import com.intellij.sql.dialects.oraplus.OraPlusDialect;
import com.intellij.sql.dialects.oraplus.OraPlusGeneratedParser;
import com.intellij.sql.dialects.oraplus.OraPlusTokens;
import com.intellij.sql.psi.SqlTokens;
import java.util.regex.Pattern;

public class OraPlusParser
extends OraParser {
    private static final Pattern PARAM_PATTERN = Pattern.compile("&\\d+");
    private static final ITokenTypeRemapper TO_PLUS_MAPPER = (source, start, end, text) -> {
        if (source == OraPlusTokens.ORAP_WS_DELIMITER_TOKEN) {
            return ORAP_DELIMITER_TOKEN;
        }
        if (source == OraPlusTokens.ORAP_WS_BIG_DELIMITER_TOKEN) {
            return ORAP_BIG_DELIMITER_TOKEN;
        }
        if (OraPlusParser.isContinuation(source, end, text)) {
            return OraPlusTokens.ORAP_WS_CONTINUATION_TOKEN;
        }
        return source;
    };
    private static final ITokenTypeRemapper TO_ORA_MAPPER = (source, start, end, text) -> {
        if (source == ORAP_DELIMITER_TOKEN) {
            return OraPlusTokens.ORAP_WS_DELIMITER_TOKEN;
        }
        if (source == OraPlusTokens.ORAP_WS_BIG_DELIMITER_TOKEN) {
            return ORAP_BIG_DELIMITER_TOKEN;
        }
        if (OraPlusParser.isContinuation(source, end, text)) {
            return OraPlusTokens.ORAP_WS_CONTINUATION_TOKEN;
        }
        return source;
    };
    private static final ITokenTypeRemapper TO_ORA_PL_MAPPER = (source, start, end, text) -> {
        if (source == ORAP_DELIMITER_TOKEN) {
            return OraPlusTokens.ORAP_WS_DELIMITER_TOKEN;
        }
        if (source == ORAP_BIG_DELIMITER_TOKEN) {
            return OraPlusTokens.ORAP_WS_BIG_DELIMITER_TOKEN;
        }
        if (source == OraPlusTokens.ORAP_WS_CONTINUATION_TOKEN) {
            return SQL_OP_MINUS;
        }
        return source;
    };
    private boolean myPlusContext = true;

    private static boolean isContinuation(IElementType source, int end, CharSequence text) {
        if (source == SQL_OP_MINUS) {
            int e = text.length();
            for (int i2 = end; i2 < e; ++i2) {
                char c = text.charAt(i2);
                if (c == '\n' || c == '\r') {
                    return true;
                }
                if (!Character.isWhitespace(c)) break;
            }
        }
        return false;
    }

    public OraPlusParser() {
        super((SqlLanguageDialectEx)OraPlusDialect.INSTANCE);
    }

    @Override
    public boolean parseForeignKeyRefList(PsiBuilder builder, int level) {
        boolean prev = this.setPlusContext(builder, false);
        boolean res = super.parseForeignKeyRefList(builder, level);
        this.setPlusContext(builder, prev);
        return res;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        boolean prev = this.setPlusContext(builder, false);
        boolean res = super.parseQueryExpression(builder, level);
        this.setPlusContext(builder, prev);
        return res;
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        boolean prev = this.setPlusContext(builder, true);
        boolean res = OraPlusGeneratedParser.root_statement(builder, level);
        if (!res) {
            this.setPlusContext(builder, false);
            res = super.parseSqlStatement(builder, level);
        }
        this.setPlusContext(builder, prev);
        return res;
    }

    @Override
    protected boolean parseArgumentListInner(PsiBuilder builder) {
        boolean prev = this.setPlusContext(builder, false);
        boolean res = super.parseArgumentListInner(builder);
        this.setPlusContext(builder, prev);
        return res;
    }

    public boolean parseJdbcProcedureCall(PsiBuilder builder, int level) {
        boolean prev = this.setPlusContext(builder, false);
        boolean res = super.parseJdbcProcedureCall(builder, level);
        this.setPlusContext(builder, prev);
        return res;
    }

    public IElementType consumeCustomParameterReference(PsiBuilder builder) {
        IElementType result;
        String tokenText = builder.getTokenText();
        if (tokenText != null && SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)SQL_IDENT) && PARAM_PATTERN.matcher(tokenText).matches()) {
            this.consumeIdentifier(builder);
            result = SQL_PARAMETER_REFERENCE;
        } else {
            result = super.consumeCustomParameterReference(builder);
        }
        return result;
    }

    @Override
    protected boolean parseExtraRoots(IElementType root, PsiBuilder builder, int level) {
        boolean prev = this.myPlusContext;
        this.setPlusContext(builder, false);
        boolean res = super.parseExtraRoots(root, builder, level);
        this.setPlusContext(builder, prev);
        return res;
    }

    protected boolean parseExternalParameterImpl(PsiBuilder builder, boolean checkStart, boolean checkEnd) {
        if ((builder.getTokenType() == SQL_OP_BITWISE_AND || builder.getTokenType() == SQL_OP_LOGICAL_AND) && this.isIdentifierToken(builder, builder.rawLookup(1), true, false)) {
            PsiBuilder.Marker mark = builder.mark();
            IElementType lookup = builder.rawLookup(2);
            IElementType lookupup = builder.rawLookup(3);
            if (lookup == SQL_PERIOD && lookupup == SQL_PERIOD) {
                builder.advanceLexer();
            }
            builder.advanceLexer();
            builder.advanceLexer();
            mark.done((IElementType)SQL_PARAMETER_REFERENCE);
            this.myExternalReferenceJustParsed = true;
            return true;
        }
        return super.parseExternalParameterImpl(builder, checkStart, checkEnd);
    }

    protected boolean isWhitespace(IElementType type) {
        return type == SqlTokens.ORAP_DELIMITER_TOKEN || type == SqlTokens.ORAP_BIG_DELIMITER_TOKEN || OraPlusTokens.WHITE_SPACE_TOKENS.contains(type);
    }

    @Override
    public boolean statementRecoverPrefixParser(PsiBuilder builder, int level) {
        return super.statementRecoverPrefixParser(builder, level) || OraPlusGeneratedParser.statement_recover_prefix(builder, level);
    }

    @Override
    public void updatePlContext(PsiBuilder b) {
        OraPlusParser.updateRemapper(b, this.myPlusContext, SqlGeneratedParserUtil.wasOn((PsiBuilder)b, (int)0, (String)"PL_DIALECT"));
    }

    public boolean statementRecover(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser prefixParser) {
        boolean prev = this.myPlusContext;
        this.setPlusContext(builder, true);
        boolean res = super.statementRecover(builder, level, prefixParser);
        this.setPlusContext(builder, prev);
        return res;
    }

    private boolean setPlusContext(PsiBuilder builder, boolean plus) {
        if (this.myPlusContext != plus) {
            this.myPlusContext = plus;
            OraPlusParser.updateRemapper(builder, plus, SqlGeneratedParserUtil.wasOn((PsiBuilder)builder, (int)0, (String)"PL_DIALECT"));
        }
        return this.myPlusContext;
    }

    private static void updateRemapper(PsiBuilder builder, boolean plus, boolean pl) {
        builder.setTokenTypeRemapper(plus ? TO_PLUS_MAPPER : (pl ? TO_ORA_PL_MAPPER : TO_ORA_MAPPER));
    }
}

