/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.spatial;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.spatial.GeoBoundingBoxCalculator;
import org.jetbrains.letsPlot.commons.intern.spatial.GeoRectangle;
import org.jetbrains.letsPlot.commons.intern.spatial.GeographicKt;
import org.jetbrains.letsPlot.commons.intern.spatial.LonLat;
import org.jetbrains.letsPlot.commons.intern.spatial.QuadKey;
import org.jetbrains.letsPlot.commons.intern.spatial.QuadsKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Rect;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.RectKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0014\u0010\u0017\u001a\u00020\u00182\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u001a\u000e\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006\u001a\u000e\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006\u001a\u000e\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\"\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000*\u0016\u0010\u001e\"\b\u0012\u0004\u0012\u00020\u00020\u001f2\b\u0012\u0004\u0012\u00020\u00020\u001f\u00a8\u0006 "}, d2={"BBOX_CALCULATOR", "Lorg/jetbrains/letsPlot/commons/intern/spatial/GeoBoundingBoxCalculator;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "getBBOX_CALCULATOR", "()Lorg/jetbrains/letsPlot/commons/intern/spatial/GeoBoundingBoxCalculator;", "EARTH_RADIUS", "", "EARTH_RECT", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Rect;", "getEARTH_RECT", "()Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Rect;", "FULL_LATITUDE", "FULL_LONGITUDE", "MAX_LATITUDE", "MAX_LONGITUDE", "MIN_LATITUDE", "MIN_LONGITUDE", "calculateQuadKeys", "", "Lorg/jetbrains/letsPlot/commons/intern/spatial/QuadKey;", "rect", "zoom", "", "convertToGeoRectangle", "Lorg/jetbrains/letsPlot/commons/intern/spatial/GeoRectangle;", "limitLat", "lat", "limitLon", "lon", "normalizeLon", "LonLatPoint", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "commons"})
public final class GeographicKt {
    public static final double EARTH_RADIUS = 6378137.0;
    public static final double MIN_LONGITUDE = -180.0;
    public static final double MAX_LONGITUDE = 180.0;
    public static final double FULL_LONGITUDE = 360.0;
    public static final double MIN_LATITUDE = -90.0;
    public static final double MAX_LATITUDE = 90.0;
    public static final double FULL_LATITUDE = 180.0;
    @NotNull
    private static final Rect<LonLat> EARTH_RECT = Rect.Companion.XYWH(-180.0, -90.0, 360.0, 180.0);
    @NotNull
    private static final GeoBoundingBoxCalculator<LonLat> BBOX_CALCULATOR = new GeoBoundingBoxCalculator<LonLat>(EARTH_RECT, true, false);

    @NotNull
    public static final Rect<LonLat> getEARTH_RECT() {
        return EARTH_RECT;
    }

    @NotNull
    public static final GeoBoundingBoxCalculator<LonLat> getBBOX_CALCULATOR() {
        return BBOX_CALCULATOR;
    }

    public static final double limitLon(double lon) {
        return Math.max(-180.0, Math.min(lon, 180.0));
    }

    public static final double limitLat(double lat) {
        return Math.max(-90.0, Math.min(lat, 90.0));
    }

    public static final double normalizeLon(double lon) {
        double result2 = lon - (double)((int)(lon / 360.0)) * 360.0;
        if (result2 > 180.0) {
            result2 -= 360.0;
        }
        if (result2 < -180.0) {
            result2 += 360.0;
        }
        return result2;
    }

    @NotNull
    public static final GeoRectangle convertToGeoRectangle(@NotNull Rect<LonLat> rect2) {
        Intrinsics.checkNotNullParameter(rect2, (String)"rect");
        double left = 0.0;
        double right = 0.0;
        if (RectKt.getWidth(rect2) < RectKt.getWidth(EARTH_RECT)) {
            left = GeographicKt.normalizeLon(RectKt.getLeft(rect2));
            right = GeographicKt.normalizeLon(RectKt.getRight(rect2));
        } else {
            left = RectKt.getLeft(EARTH_RECT);
            right = RectKt.getRight(EARTH_RECT);
        }
        return new GeoRectangle(left, GeographicKt.limitLat(RectKt.getTop(rect2)), right, GeographicKt.limitLat(RectKt.getBottom(rect2)));
    }

    @NotNull
    public static final Set<QuadKey<LonLat>> calculateQuadKeys(@NotNull Rect<LonLat> rect2, int zoom) {
        Intrinsics.checkNotNullParameter(rect2, (String)"rect");
        Rect flippedRect = Rect.Companion.XYWH(RectKt.getLeft(rect2), -RectKt.getBottom(rect2), RectKt.getWidth(rect2), RectKt.getHeight(rect2));
        return QuadsKt.calculateQuadKeys(EARTH_RECT, flippedRect, zoom, calculateQuadKeys.1.INSTANCE);
    }
}

