/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.WithHeight;
import org.jetbrains.letsPlot.core.plot.base.geom.WithWidth;
import org.jetbrains.letsPlot.core.plot.base.geom.legend.HLineLegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.geom.util.ArrowSpec;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.TargetCollectorHelper;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 .2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002./B\u0005\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J.\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020'0&H\u0002J0\u0010)\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020,H\u0016J0\u0010-\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020,H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u00060"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/SpokeGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/WithWidth;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/WithHeight;", "()V", "arrowSpec", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec;", "getArrowSpec", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec;", "setArrowSpec", "(Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec;)V", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "pivot", "Lorg/jetbrains/letsPlot/core/plot/base/geom/SpokeGeom$Pivot;", "getPivot", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/SpokeGeom$Pivot;", "setPivot", "(Lorg/jetbrains/letsPlot/core/plot/base/geom/SpokeGeom$Pivot;)V", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "calculateSpan", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "coordAes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "", "spanAxisAes", "heightSpan", "resolution", "isDiscrete", "", "widthSpan", "Companion", "Pivot", "plot-base"})
public final class SpokeGeom
extends GeomBase
implements WithWidth,
WithHeight {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ArrowSpec arrowSpec;
    @NotNull
    private Pivot pivot = DEF_PIVOT;
    @NotNull
    private static final Pivot DEF_PIVOT = Pivot.TAIL;
    public static final boolean HANDLES_GROUPS = false;

    @Nullable
    public final ArrowSpec getArrowSpec() {
        return this.arrowSpec;
    }

    public final void setArrowSpec(@Nullable ArrowSpec arrowSpec) {
        this.arrowSpec = arrowSpec;
    }

    @NotNull
    public final Pivot getPivot() {
        return this.pivot;
    }

    public final void setPivot(@NotNull Pivot pivot) {
        Intrinsics.checkNotNullParameter((Object)((Object)pivot), (String)"<set-?>");
        this.pivot = pivot;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return new HLineLegendKeyElementFactory();
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        TargetCollectorHelper tooltipHelper2 = new TargetCollectorHelper(GeomKind.SPOKE, ctx2);
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx2);
        GeomHelper.SvgElementHelper svgElementHelper = geomHelper.createSvgElementHelper().setStrokeAlphaEnabled(true).setArrowSpec(this.arrowSpec);
        for (DataPointAesthetics p : aesthetics2.dataPoints()) {
            Pair pair2;
            DoubleVector start2;
            if (GeomUtil.INSTANCE.toLocation(p, Aes.Companion.getX(), Aes.Companion.getY()) == null) continue;
            Double d = p.finiteOrNull(Aes.Companion.getANGLE());
            if (d == null) {
                continue;
            }
            double angle = d;
            Double d2 = p.finiteOrNull(Aes.Companion.getRADIUS());
            if (d2 == null) {
                continue;
            }
            double radius = d2;
            if (GeomHelper.SvgElementHelper.createSpoke$default(svgElementHelper, start2, angle, radius, this.pivot.getFactor(), p, null, 32, null) == null) continue;
            SvgNode svg = (SvgNode)pair2.component1();
            List geometry = (List)pair2.component2();
            tooltipHelper2.addLine(geometry, p);
            root.add(svg);
        }
    }

    @Override
    @Nullable
    public DoubleSpan widthSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, double resolution, boolean isDiscrete) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        return this.calculateSpan(p, coordAes, Aes.Companion.getX());
    }

    @Override
    @Nullable
    public DoubleSpan heightSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, double resolution, boolean isDiscrete) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        return this.calculateSpan(p, coordAes, Aes.Companion.getY());
    }

    private final DoubleSpan calculateSpan(DataPointAesthetics p, Aes<Double> coordAes, Aes<Double> spanAxisAes) {
        DoubleVector doubleVector = GeomUtil.INSTANCE.toLocation(p, Aes.Companion.getX(), Aes.Companion.getY());
        if (doubleVector == null || (doubleVector = doubleVector.flipIf(!Intrinsics.areEqual(coordAes, spanAxisAes))) == null) {
            return null;
        }
        DoubleVector base = doubleVector;
        Double d = p.finiteOrNull(Aes.Companion.getANGLE());
        if (d == null) {
            return null;
        }
        double angle = d;
        Double d2 = p.finiteOrNull(Aes.Companion.getRADIUS());
        if (d2 == null) {
            return null;
        }
        double radius = d2;
        GeomHelper.SvgElementHelper elementHelper = new GeomHelper.SvgElementHelper(null, 1, null);
        Pair pair2 = GeomHelper.SvgElementHelper.createSpoke$default(elementHelper, base, angle, radius, this.pivot.getFactor(), p, null, 32, null);
        if (pair2 == null) {
            return null;
        }
        List geometry = (List)pair2.component2();
        if (!(geometry.size() == 2)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        DoubleVector start2 = (DoubleVector)geometry.get(0);
        DoubleVector end = (DoubleVector)geometry.get(1);
        return Intrinsics.areEqual(spanAxisAes, Aes.Companion.getX()) ? new DoubleSpan(start2.getX(), end.getX()) : new DoubleSpan(start2.getY(), end.getY());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/SpokeGeom$Companion;", "", "()V", "DEF_PIVOT", "Lorg/jetbrains/letsPlot/core/plot/base/geom/SpokeGeom$Pivot;", "getDEF_PIVOT", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/SpokeGeom$Pivot;", "HANDLES_GROUPS", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pivot getDEF_PIVOT() {
            return DEF_PIVOT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/SpokeGeom$Pivot;", "", "factor", "", "(Ljava/lang/String;ID)V", "getFactor", "()D", "TAIL", "MIDDLE", "TIP", "plot-base"})
    public static final class Pivot
    extends Enum<Pivot> {
        private final double factor;
        public static final /* enum */ Pivot TAIL = new Pivot(0.0);
        public static final /* enum */ Pivot MIDDLE = new Pivot(0.5);
        public static final /* enum */ Pivot TIP = new Pivot(1.0);
        private static final /* synthetic */ Pivot[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Pivot(double factor) {
            this.factor = factor;
        }

        public final double getFactor() {
            return this.factor;
        }

        public static Pivot[] values() {
            return (Pivot[])$VALUES.clone();
        }

        public static Pivot valueOf(String value) {
            return Enum.valueOf(Pivot.class, value);
        }

        @NotNull
        public static EnumEntries<Pivot> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = pivotArray = new Pivot[]{Pivot.TAIL, Pivot.MIDDLE, Pivot.TIP};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

