/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastVisibility;

public final class CdiNormalScopeInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(@NotNull PsiClass psiClass, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (psiClass == null) {
            CdiNormalScopeInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            CdiNormalScopeInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            CdiNormalScopeInspection.$$$reportNull$$$0(2);
        }
        CdiNormalScopeInspection.checkPublicFields(psiClass, holder, module);
    }

    private static void checkPublicFields(PsiClass psiClass, ProblemsHolder holder, Module module) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, CdiCommonUtils.getNormalScopeQualifiedNames(module));
        if (annotation != null) {
            for (PsiField field : psiClass.getFields()) {
                UField uField = (UField)UastContextKt.toUElement((PsiElement)field, UField.class);
                if (uField == null || uField.getVisibility() != UastVisibility.PUBLIC || uField.isStatic()) continue;
                CdiNormalScopeInspection.registerProblem(holder, CdiNormalScopeInspection.getIdentifyingElement((PsiModifierListOwner)field), CdiInspectionBundle.message("CdiNormalScopeInspection.public.field.in.normal.scoped.beans", new Object[0]));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
        }
        objectArray[1] = "com/intellij/cdi/highlighting/CdiNormalScopeInspection";
        objectArray[2] = "checkClass";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

