/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.events.listeners;

import com.intellij.code.provenance.DocumentChangesKind;
import com.intellij.code.provenance.core.ProvenanceEntry;
import com.intellij.code.provenance.core.ProvenanceRegistry;
import com.intellij.code.provenance.core.events.ProvenanceEvents;
import com.intellij.code.provenance.core.events.detection.ActionsKt;
import com.intellij.code.provenance.core.events.mergeableEvents.DocumentChanges;
import com.intellij.code.provenance.core.events.utils.Path_utilsKt;
import com.intellij.code.provenance.core.events.utils.UtilsKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.impl.PsiManagerImpl;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/intellij/code/provenance/core/events/listeners/ProvenanceCommandFileListener;", "", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "trackedActions", "", "", "getTrackedActions", "()Ljava/util/Set;", "trackedActions$delegate", "Lkotlin/Lazy;", "dynamicAddedActions", "", "bulkFileListener", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "getBulkFileListener", "()Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "registerContentChange", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "seq", "", "ts", "", "intellij.code.provenance.core"})
public final class ProvenanceCommandFileListener {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Lazy trackedActions$delegate;
    @NotNull
    private final Set<String> dynamicAddedActions;
    @NotNull
    private final BulkFileListener bulkFileListener;

    public ProvenanceCommandFileListener(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.scope = scope;
        this.trackedActions$delegate = LazyKt.lazy(ProvenanceCommandFileListener::trackedActions_delegate$lambda$0);
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        this.dynamicAddedActions = keySetView;
        this.bulkFileListener = new BulkFileListener(this){
            final /* synthetic */ ProvenanceCommandFileListener this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * Enabled aggressive block sorting
             */
            public void after(List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                if (!ProvenanceRegistry.INSTANCE.isProvenanceEnabled()) {
                    return;
                }
                String command = CommandProcessor.getInstance().getCurrentCommandName();
                CharSequence charSequence = command;
                if (charSequence == null) return;
                if (StringsKt.isBlank((CharSequence)charSequence)) {
                    return;
                }
                boolean bl = false;
                if (bl) {
                    return;
                }
                if (!ProvenanceCommandFileListener.access$getTrackedActions(this.this$0).contains(command) && !ProvenanceCommandFileListener.access$getDynamicAddedActions$p(this.this$0).contains(command)) {
                    Object object = CollectionsKt.singleOrNull(events);
                    if (!(object instanceof VFileCreateEvent)) return;
                    VFileCreateEvent vFileCreateEvent = (VFileCreateEvent)object;
                    VFileCreateEvent firstCreationEvent = vFileCreateEvent;
                    if (firstCreationEvent == null) return;
                    if (firstCreationEvent.isFromRefresh()) return;
                    VirtualFile virtualFile = firstCreationEvent.getFile();
                    if (virtualFile == null) return;
                    if (!Path_utilsKt.isSourceFile(virtualFile)) return;
                    boolean bl2 = true;
                    if (!bl2) return;
                    if (!(firstCreationEvent.getRequestor() instanceof PsiManagerImpl)) return;
                    ProvenanceCommandFileListener.access$getDynamicAddedActions$p(this.this$0).add(command);
                }
                long ts = System.currentTimeMillis();
                FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
                FileDocumentManager fdm = fileDocumentManager;
                Iterator<? extends VFileEvent> iterator = events.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    VirtualFile file;
                    Object object2;
                    VirtualFile virtualFile;
                    Object object3;
                    VFileEvent vFileEvent = iterator.next();
                    if (!(vFileEvent instanceof VFileContentChangeEvent) && !(vFileEvent instanceof VFileCreateEvent) || !(vFileEvent.getRequestor() instanceof FileDocumentManager) || (object3 = vFileEvent.getFile()) == null) continue;
                    VirtualFile it = virtualFile = object3;
                    boolean bl3 = false;
                    object3 = Path_utilsKt.isSourceFile(it) ? virtualFile : null;
                    if (object3 == null || (object2 = fdm.getCachedDocument(file = object3)) == null || (object2 = object2.getCharsSequence()) == null || UtilsKt.isTooBigContent((CharSequence)(object = object2))) continue;
                    BuildersKt.launch$default((CoroutineScope)ProvenanceCommandFileListener.access$getScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, file, (CharSequence)object, ts, null){
                        int label;
                        final /* synthetic */ ProvenanceCommandFileListener this$0;
                        final /* synthetic */ VirtualFile $file;
                        final /* synthetic */ CharSequence $seq;
                        final /* synthetic */ long $ts;
                        {
                            this.this$0 = $receiver;
                            this.$file = $file;
                            this.$seq = $seq;
                            this.$ts = $ts;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    ProvenanceCommandFileListener.access$registerContentChange(this.this$0, this.$file, this.$seq, this.$ts);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
                return;
            }
        };
    }

    private final Set<String> getTrackedActions() {
        Lazy lazy = this.trackedActions$delegate;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final BulkFileListener getBulkFileListener() {
        return this.bulkFileListener;
    }

    private final void registerContentChange(VirtualFile file, CharSequence seq2, long ts) {
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String filePath = string;
        String text = ((Object)seq2).toString();
        long afterHash = UtilsKt.contentHash(text);
        List changes = CollectionsKt.listOf((Object)new ProvenanceEntry.SingleDocumentChange(0, 0, text));
        ProvenanceEvents.Companion.getInstance(this.project).add(new DocumentChanges(changes, UtilsKt.getEmptyHash(), afterHash, filePath, ts, DocumentChangesKind.NEW_FILE, false));
    }

    private static final Set trackedActions_delegate$lambda$0() {
        return CollectionsKt.toSet((Iterable)ActionsKt.getNewFileActions());
    }

    public static final /* synthetic */ Set access$getTrackedActions(ProvenanceCommandFileListener $this) {
        return $this.getTrackedActions();
    }

    public static final /* synthetic */ Set access$getDynamicAddedActions$p(ProvenanceCommandFileListener $this) {
        return $this.dynamicAddedActions;
    }

    public static final /* synthetic */ CoroutineScope access$getScope$p(ProvenanceCommandFileListener $this) {
        return $this.scope;
    }

    public static final /* synthetic */ void access$registerContentChange(ProvenanceCommandFileListener $this, VirtualFile file, CharSequence seq2, long ts) {
        $this.registerContentChange(file, seq2, ts);
    }
}

