/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactoryBase;
import com.intellij.database.types.DasType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.Consumer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J(\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/SqlHighlightAsteriskFactory;", "Lcom/intellij/codeInsight/highlighting/HighlightUsagesHandlerFactoryBase;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "createHighlightUsagesHandler", "Lcom/intellij/codeInsight/highlighting/HighlightUsagesHandlerBase;", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "target", "HandlerImpl", "intellij.database.sql.impl"})
public final class SqlHighlightAsteriskFactory
extends HighlightUsagesHandlerFactoryBase
implements DumbAware {
    @Nullable
    public HighlightUsagesHandlerBase<PsiElement> createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile psiFile, @NotNull PsiElement target) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!(psiFile instanceof SqlFile)) {
            return null;
        }
        PsiReference psiReference = TargetElementUtilBase.findReference((Editor)editor, (int)editor.getCaretModel().getOffset());
        if (psiReference == null) {
            return null;
        }
        PsiReference ref = psiReference;
        PsiElement psiElement = ref.getElement();
        SqlReferenceExpression sqlReferenceExpression = psiElement instanceof SqlReferenceExpression ? (SqlReferenceExpression)psiElement : null;
        if (sqlReferenceExpression == null) {
            return null;
        }
        SqlReferenceExpression refExpression = sqlReferenceExpression;
        if (!SqlImplUtil.isAsteriskRef((PsiElement)((PsiElement)refExpression))) {
            return null;
        }
        return new HandlerImpl(editor, psiFile, refExpression);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0016J,\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0014\u0010\u0011\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00020\r0\u0012H\u0014J\u0016\u0010\u0013\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\rH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/SqlHighlightAsteriskFactory$HandlerImpl;", "Lcom/intellij/codeInsight/highlighting/HighlightUsagesHandlerBase;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/openapi/project/DumbAware;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "refExpression", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiFile;Lcom/intellij/sql/psi/SqlReferenceExpression;)V", "getTargets", "", "selectTargets", "", "targets", "selectionConsumer", "Lcom/intellij/util/Consumer;", "computeUsages", "intellij.database.sql.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlHighlightAsteriskFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlHighlightAsteriskFactory.kt\ncom/intellij/sql/SqlHighlightAsteriskFactory$HandlerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
    public static final class HandlerImpl
    extends HighlightUsagesHandlerBase<PsiElement>
    implements DumbAware {
        @NotNull
        private final SqlReferenceExpression refExpression;

        public HandlerImpl(@NotNull Editor editor, @NotNull PsiFile file, @NotNull SqlReferenceExpression refExpression) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)refExpression, (String)"refExpression");
            super(editor, file);
            this.refExpression = refExpression;
        }

        @NotNull
        public List<SqlReferenceExpression> getTargets() {
            return CollectionsKt.listOf((Object)this.refExpression);
        }

        protected void selectTargets(@NotNull List<? extends PsiElement> targets, @NotNull Consumer<? super List<? extends PsiElement>> selectionConsumer) {
            Intrinsics.checkNotNullParameter(targets, (String)"targets");
            Intrinsics.checkNotNullParameter(selectionConsumer, (String)"selectionConsumer");
            selectionConsumer.consume(targets);
        }

        public void computeUsages(@NotNull List<? extends PsiElement> targets) {
            Intrinsics.checkNotNullParameter(targets, (String)"targets");
            DasType dasType = this.refExpression.getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
            DasType asteriskType = dasType;
            if (!(asteriskType instanceof SqlTableType)) {
                return;
            }
            int n = ((SqlTableType)asteriskType).getColumnCount();
            for (int i = 0; i < n; ++i) {
                PsiElement it;
                if (((SqlTableType)asteriskType).getSourceColumnElement(i) == null) continue;
                boolean bl = false;
                this.addOccurrence(it);
            }
        }
    }
}

