/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.util;

import com.intellij.jsp.util.JspUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JstlUtil {
    private static final Key<CachedValue<XmlTag[]>> IMPORT_TAGS_KEY = Key.create((String)"IMPORT_TAGS_KEY");
    private static final Set<String> JSTL_CORE_URI_SET = Set.of(XmlUtil.JSTL_CORE_URIS);
    @NonNls
    private static final String IMPORT_TAG_NAME = "import";
    @NonNls
    private static final String URL_ATTRIBUTE = "url";

    public static XmlTag[] getImportTags(@NotNull BaseJspFile file) {
        CachedValue value;
        if (file == null) {
            JstlUtil.$$$reportNull$$$0(0);
        }
        if ((value = (CachedValue)file.getUserData(IMPORT_TAGS_KEY)) == null) {
            value = CachedValuesManager.getManager((Project)file.getProject()).createCachedValue(() -> CachedValueProvider.Result.createSingleDependency((Object)JstlUtil.findImportTags(file), (Object)file), false);
            file.putUserData(IMPORT_TAGS_KEY, (Object)value);
        }
        return (XmlTag[])value.getValue();
    }

    private static XmlTag[] findImportTags(@NotNull BaseJspFile file) {
        if (file == null) {
            JstlUtil.$$$reportNull$$$0(1);
        }
        final ArrayList tags = new ArrayList();
        XmlUtil.processXmlElements((XmlElement)file, (PsiElementProcessor)new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                XmlTag tag;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof XmlTag && JstlUtil.IMPORT_TAG_NAME.equals((tag = (XmlTag)element).getLocalName()) && JSTL_CORE_URI_SET.contains(tag.getNamespace())) {
                    tags.add(tag);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsp/util/JstlUtil$1", "execute"));
            }
        }, (boolean)true);
        return tags.toArray(XmlTag.EMPTY);
    }

    @Nullable
    public static PsiFile resolveImportTag(@NotNull XmlTag tag) {
        if (tag == null) {
            JstlUtil.$$$reportNull$$$0(2);
        }
        return JspUtil.resolvePsiFileReferenceInAttribute(tag, URL_ATTRIBUTE);
    }

    @Nullable
    public static String getImportFilePath(@NotNull XmlTag tag) {
        if (tag == null) {
            JstlUtil.$$$reportNull$$$0(3);
        }
        return tag.getAttributeValue(URL_ATTRIBUTE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jsp/util/JstlUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getImportTags";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findImportTags";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveImportTag";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getImportFilePath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

