/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.npm.NpmScript;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsStructure;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonCommonUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NpmScriptsUtil {
    private static final String SCRIPTS_NAME = "scripts";
    private static final Logger LOG = Logger.getInstance(NpmScriptsUtil.class);

    private NpmScriptsUtil() {
    }

    @NotNull
    public static NpmScriptsStructure listTasks(@NotNull Project project, @NotNull VirtualFile packageJson) throws JsbtTaskFetchException {
        if (project == null) {
            NpmScriptsUtil.$$$reportNull$$$0(0);
        }
        if (packageJson == null) {
            NpmScriptsUtil.$$$reportNull$$$0(1);
        }
        Ref exRef = Ref.create();
        Ref structureRef = Ref.create();
        ApplicationManager.getApplication().runReadAction(() -> {
            try {
                structureRef.set((Object)NpmScriptsUtil.doBuildStructure(project, packageJson));
            }
            catch (JsbtTaskFetchException e) {
                exRef.set((Object)e);
            }
        });
        NpmScriptsStructure structure = (NpmScriptsStructure)structureRef.get();
        if (structure != null) {
            NpmScriptsStructure npmScriptsStructure = structure;
            if (npmScriptsStructure == null) {
                NpmScriptsUtil.$$$reportNull$$$0(2);
            }
            return npmScriptsStructure;
        }
        throw (JsbtTaskFetchException)exRef.get();
    }

    @NotNull
    private static NpmScriptsStructure doBuildStructure(@NotNull Project project, @NotNull VirtualFile packageJson) throws JsbtTaskFetchException {
        if (project == null) {
            NpmScriptsUtil.$$$reportNull$$$0(3);
        }
        if (packageJson == null) {
            NpmScriptsUtil.$$$reportNull$$$0(4);
        }
        if (!packageJson.isValid()) {
            throw NpmScriptsUtil.invalidFile(packageJson);
        }
        NpmScriptsStructure structure = new NpmScriptsStructure(packageJson);
        JsonProperty scriptsProperty = NpmScriptsUtil.findScriptsProperty(project, packageJson);
        if (scriptsProperty == null) {
            NpmScriptsStructure npmScriptsStructure = structure;
            if (npmScriptsStructure == null) {
                NpmScriptsUtil.$$$reportNull$$$0(5);
            }
            return npmScriptsStructure;
        }
        JsonObject map = (JsonObject)ObjectUtils.tryCast((Object)scriptsProperty.getValue(), JsonObject.class);
        if (map != null) {
            ArrayList<NpmScript> scripts = new ArrayList<NpmScript>();
            for (JsonProperty property : map.getPropertyList()) {
                scripts.add(new NpmScript(structure, property.getName()));
            }
            structure.setScripts(scripts);
        }
        NpmScriptsStructure npmScriptsStructure = structure;
        if (npmScriptsStructure == null) {
            NpmScriptsUtil.$$$reportNull$$$0(6);
        }
        return npmScriptsStructure;
    }

    @NotNull
    private static JsbtTaskFetchException invalidFile(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            NpmScriptsUtil.$$$reportNull$$$0(7);
        }
        JsbtTaskFetchException jsbtTaskFetchException = JsbtTaskFetchException.newBuildfileSyntaxError(packageJson);
        if (jsbtTaskFetchException == null) {
            NpmScriptsUtil.$$$reportNull$$$0(8);
        }
        return jsbtTaskFetchException;
    }

    @Nullable
    private static JsonProperty findScriptsProperty(@NotNull Project project, @NotNull VirtualFile packageJson) throws JsbtTaskFetchException {
        PsiManagerEx psiManager;
        PsiFile psiFile;
        if (project == null) {
            NpmScriptsUtil.$$$reportNull$$$0(9);
        }
        if (packageJson == null) {
            NpmScriptsUtil.$$$reportNull$$$0(10);
        }
        if ((psiFile = (psiManager = PsiManagerEx.getInstanceEx((Project)project)).getFileManager().findFile(packageJson)) == null) {
            throw NpmScriptsUtil.invalidFile(packageJson);
        }
        return NpmScriptsUtil.findScriptsProperty((JsonFile)ObjectUtils.tryCast((Object)psiFile, JsonFile.class));
    }

    @Nullable
    public static JsonProperty findScriptsProperty(@Nullable JsonFile jsonFile) {
        JsonObject topObject = (JsonObject)ObjectUtils.tryCast((Object)(jsonFile != null ? jsonFile.getTopLevelValue() : null), JsonObject.class);
        if (topObject != null) {
            return topObject.findProperty(SCRIPTS_NAME);
        }
        return null;
    }

    @Nullable
    public static JsonProperty findScriptProperty(@NotNull Project project, @NotNull VirtualFile packageJson, @NotNull String scriptName) {
        JsonProperty scriptsProperty;
        if (project == null) {
            NpmScriptsUtil.$$$reportNull$$$0(11);
        }
        if (packageJson == null) {
            NpmScriptsUtil.$$$reportNull$$$0(12);
        }
        if (scriptName == null) {
            NpmScriptsUtil.$$$reportNull$$$0(13);
        }
        if (project.isDisposed() || !packageJson.isValid()) {
            return null;
        }
        try {
            scriptsProperty = NpmScriptsUtil.findScriptsProperty(project, packageJson);
        }
        catch (JsbtTaskFetchException e) {
            LOG.info("Cannot fetch 'scripts' from " + packageJson.getPath());
            return null;
        }
        if (scriptsProperty == null) {
            return null;
        }
        JsonObject scriptsObj = (JsonObject)ObjectUtils.tryCast((Object)scriptsProperty.getValue(), JsonObject.class);
        if (scriptsObj == null) {
            return null;
        }
        return scriptsObj.findProperty(scriptName);
    }

    public static boolean isScriptProperty(@Nullable JsonProperty property) {
        JsonProperty scriptsProperty = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)property, JsonProperty.class, (boolean)true);
        return scriptsProperty != null && SCRIPTS_NAME.equals(scriptsProperty.getName()) && PackageJsonCommonUtil.isTopLevelProperty((JsonProperty)scriptsProperty);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/NpmScriptsUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/NpmScriptsUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "listTasks";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doBuildStructure";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "invalidFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "listTasks";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doBuildStructure";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invalidFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findScriptsProperty";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findScriptProperty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 8 -> new IllegalStateException(string);
        };
    }
}

