/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.functionmetrics;

import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;

class LoopCountVisitor
extends JSRecursiveWalkingElementVisitor {
    private int loopCount = 0;

    private LoopCountVisitor() {
    }

    public static int countLoops(@NotNull JSFunction function) {
        PsiElement lastChild;
        if (function == null) {
            LoopCountVisitor.$$$reportNull$$$0(0);
        }
        if (!((lastChild = function.getLastChild()) instanceof JSBlockStatement)) {
            return 0;
        }
        LoopCountVisitor visitor = new LoopCountVisitor();
        lastChild.accept((PsiElementVisitor)visitor);
        return visitor.getCount();
    }

    public boolean visitAsFunction(@NotNull JSFunction function) {
        if (function == null) {
            LoopCountVisitor.$$$reportNull$$$0(1);
        }
        return true;
    }

    public void visitJSForStatement(@NotNull JSForStatement jsForStatement) {
        if (jsForStatement == null) {
            LoopCountVisitor.$$$reportNull$$$0(2);
        }
        super.visitJSForStatement(jsForStatement);
        ++this.loopCount;
    }

    public void visitJSForInStatement(@NotNull JSForInStatement jsForStatement) {
        if (jsForStatement == null) {
            LoopCountVisitor.$$$reportNull$$$0(3);
        }
        super.visitJSForInStatement(jsForStatement);
        ++this.loopCount;
    }

    public void visitJSWhileStatement(@NotNull JSWhileStatement jsWhileStatement) {
        if (jsWhileStatement == null) {
            LoopCountVisitor.$$$reportNull$$$0(4);
        }
        super.visitJSWhileStatement(jsWhileStatement);
        ++this.loopCount;
    }

    public void visitJSDoWhileStatement(@NotNull JSDoWhileStatement jsDoWhileStatement) {
        if (jsDoWhileStatement == null) {
            LoopCountVisitor.$$$reportNull$$$0(5);
        }
        super.visitJSDoWhileStatement(jsDoWhileStatement);
        ++this.loopCount;
    }

    public void visitJSCallExpression(@NotNull JSCallExpression node) {
        if (node == null) {
            LoopCountVisitor.$$$reportNull$$$0(6);
        }
        super.visitJSCallExpression(node);
        JSExpression methodExpression = node.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression && "forEach".equals(((JSReferenceExpression)methodExpression).getReferenceName())) {
            JSExpression callback;
            ++this.loopCount;
            JSExpression[] arguments = node.getArguments();
            if (arguments.length > 0 && (callback = JSUtils.unparenthesize((JSExpression)arguments[0])) instanceof JSFunction) {
                this.loopCount += LoopCountVisitor.countLoops((JSFunction)callback);
            }
        }
    }

    public int getCount() {
        return this.loopCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsForStatement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsWhileStatement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsDoWhileStatement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/sixrr/inspectjs/functionmetrics/LoopCountVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "countLoops";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAsFunction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSForStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSForInStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSWhileStatement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSDoWhileStatement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSCallExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

