/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.profiler.api.ProfilerData;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.hprof.impl.HprofDump;
import com.intellij.profiler.ultimate.hprof.ui.ClassHistogramPanel;
import com.intellij.profiler.ultimate.hprof.ui.MemoryViewTopLevelComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.util.ui.StatusText;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/profiler/ultimate/hprof/HprofProfilerData;", "Lcom/intellij/profiler/api/ProfilerData;", "hprof", "Lcom/intellij/profiler/ultimate/hprof/impl/HprofDump;", "corruptedException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "<init>", "(Lcom/intellij/profiler/ultimate/hprof/impl/HprofDump;Ljava/lang/Exception;)V", "isEmpty", "", "()Z", "doCreateTopLevelComponent", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "parent", "Lcom/intellij/openapi/Disposable;", "doCreateEmptyDataComponent", "clarifyExceptionMessage", "", "message", "throwable", "", "intellij.profiler.ultimate"})
final class HprofProfilerData
implements ProfilerData {
    @NotNull
    private final HprofDump hprof;
    @Nullable
    private final Exception corruptedException;
    private final boolean isEmpty;

    public HprofProfilerData(@NotNull HprofDump hprof, @Nullable Exception corruptedException) {
        Intrinsics.checkNotNullParameter((Object)hprof, (String)"hprof");
        this.hprof = hprof;
        this.corruptedException = corruptedException;
        this.isEmpty = this.corruptedException != null;
    }

    public /* synthetic */ HprofProfilerData(HprofDump hprofDump, Exception exception, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            exception = null;
        }
        this(hprofDump, exception);
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    @NotNull
    public JComponent doCreateTopLevelComponent(@NotNull Project project, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Disposer.register((Disposable)parent, (Disposable)this.hprof);
        MemoryViewTopLevelComponent component = new MemoryViewTopLevelComponent(project);
        HprofProfilerData it = this;
        boolean bl = false;
        ClassHistogramPanel classHistogramPanel = new ClassHistogramPanel(this.hprof, project, component);
        Disposer.register((Disposable)this.hprof, (Disposable)component);
        component.addTab(classHistogramPanel, (JComponent)classHistogramPanel.getTable());
        return (JComponent)((Object)component);
    }

    @NotNull
    public JComponent doCreateEmptyDataComponent(@NotNull Project project, @NotNull Disposable parent) {
        JBPanelWithEmptyText jBPanelWithEmptyText;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        JBPanelWithEmptyText $this$doCreateEmptyDataComponent_u24lambda_u240 = jBPanelWithEmptyText = new JBPanelWithEmptyText();
        boolean bl = false;
        if (this.corruptedException != null && this.corruptedException.getLocalizedMessage() != null) {
            $this$doCreateEmptyDataComponent_u24lambda_u240.getEmptyText().appendLine(UltimateProfilerBundleKt.profilerMessage("hprof.load.error.failed.with.message", new Object[0]));
            StatusText statusText = $this$doCreateEmptyDataComponent_u24lambda_u240.getEmptyText();
            String string = this.clarifyExceptionMessage(this.corruptedException.getMessage(), this.corruptedException);
            if (string == null) {
                string = this.corruptedException.getLocalizedMessage();
            }
            v2 = statusText.appendLine(string, SimpleTextAttributes.ERROR_ATTRIBUTES, null);
        } else {
            v2 = $this$doCreateEmptyDataComponent_u24lambda_u240.getEmptyText().appendLine(UltimateProfilerBundleKt.profilerMessage("hprof.load.error.failed.without.message", new Object[0]));
        }
        return (JComponent)jBPanelWithEmptyText;
    }

    @Nls
    private final String clarifyExceptionMessage(String message, Throwable throwable) {
        return message == null ? null : (throwable instanceof IllegalArgumentException && StringsKt.startsWith$default((String)message, (String)"newLimit > capacity: ", (boolean)false, (int)2, null) ? UltimateProfilerBundleKt.profilerMessage("hprof.load.error.fileIsCorrupted", new Object[0]) : (throwable instanceof RuntimeException && StringsKt.startsWith$default((String)message, (String)"Invalid format. Got: YOURKIT_FILE_60000", (boolean)false, (int)2, null) ? UltimateProfilerBundleKt.profilerMessage("hprof.load.error.yourkitSnapshots", new Object[0]) : null));
    }
}

