/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.stacktrace;

import java.util.Objects;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.flightrecorder.stacktrace.messages.internal.Messages;

public class FrameSeparator {
    private final boolean distinguishFramesByOptimization;
    private final FrameCategorization categorization;

    public FrameSeparator(FrameCategorization categorization, boolean distinguishFramesByOptimization) {
        this.categorization = categorization;
        this.distinguishFramesByOptimization = distinguishFramesByOptimization;
    }

    public FrameCategorization getCategorization() {
        return this.categorization;
    }

    public boolean isDistinguishFramesByOptimization() {
        return this.distinguishFramesByOptimization;
    }

    public boolean isSeparate(IMCFrame frameA, IMCFrame frameB) {
        return !this.getCategory(frameA).equals(this.getCategory(frameB)) || !this.compareDetails(frameA, frameB);
    }

    Object getCategory(IMCFrame frame) {
        switch (this.categorization) {
            case PACKAGE: {
                return frame.getMethod().getType().getPackage();
            }
            case CLASS: {
                return frame.getMethod().getType();
            }
        }
        return frame.getMethod();
    }

    boolean compareDetails(IMCFrame frameA, IMCFrame frameB) {
        if (this.distinguishFramesByOptimization && !Objects.equals((Object)frameA.getType(), (Object)frameB.getType())) {
            return false;
        }
        if (this.categorization == FrameCategorization.BCI) {
            return Objects.equals(frameA.getBCI(), frameB.getBCI());
        }
        if (this.categorization == FrameCategorization.LINE) {
            return Objects.equals(frameA.getFrameLineNumber(), frameB.getFrameLineNumber());
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.categorization, this.distinguishFramesByOptimization});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FrameSeparator) {
            FrameSeparator other = (FrameSeparator)obj;
            return this.categorization == other.categorization && this.distinguishFramesByOptimization == other.distinguishFramesByOptimization;
        }
        return false;
    }

    public static enum FrameCategorization {
        BCI(Messages.getString("STACKTRACE_BYTE_CODE_INDEX")),
        LINE(Messages.getString("STACKTRACE_LINE_NUMBER")),
        METHOD(Messages.getString("STACKTRACE_METHOD")),
        CLASS(Messages.getString("STACKTRACE_CLASS")),
        PACKAGE(Messages.getString("STACKTRACE_PACKAGE"));

        private final String localizedName;

        private FrameCategorization(String localizedName) {
            this.localizedName = localizedName;
        }

        public String getLocalizedName() {
            return this.localizedName;
        }
    }
}

