/*
 * Decompiled with CFR 0.152.
 */
package git4idea.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsVFSListener;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.index.GitStageManagerKt;
import git4idea.util.GitFileUtils;
import git4idea.util.GitVcsConsoleWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

public final class GitVFSListener
extends VcsVFSListener {
    private GitVFSListener(@NotNull GitVcs vcs, @NotNull CoroutineScope coroutineScope) {
        if (vcs == null) {
            GitVFSListener.$$$reportNull$$$0(0);
        }
        if (coroutineScope == null) {
            GitVFSListener.$$$reportNull$$$0(1);
        }
        super((AbstractVcs)vcs, coroutineScope);
    }

    @NotNull
    public static GitVFSListener createInstance(@NotNull GitVcs vcs, @NotNull CoroutineScope coroutineScope) {
        if (vcs == null) {
            GitVFSListener.$$$reportNull$$$0(2);
        }
        if (coroutineScope == null) {
            GitVFSListener.$$$reportNull$$$0(3);
        }
        GitVFSListener listener2 = new GitVFSListener(vcs, coroutineScope);
        listener2.installListeners();
        GitVFSListener gitVFSListener = listener2;
        if (gitVFSListener == null) {
            GitVFSListener.$$$reportNull$$$0(4);
        }
        return gitVFSListener;
    }

    @NotNull
    protected String getAddTitle() {
        String string = GitBundle.message((String)"vfs.listener.add.title", (Object[])new Object[0]);
        if (string == null) {
            GitVFSListener.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    protected String getSingleFileAddTitle() {
        String string = GitBundle.message((String)"vfs.listener.add.single.title", (Object[])new Object[0]);
        if (string == null) {
            GitVFSListener.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    protected String getSingleFileAddPromptTemplate() {
        String string = GitBundle.message((String)"vfs.listener.add.single.prompt", (Object[])new Object[0]);
        if (string == null) {
            GitVFSListener.$$$reportNull$$$0(7);
        }
        return string;
    }

    protected void executeAdd(final @NotNull List<VirtualFile> addedFiles, final @NotNull Map<VirtualFile, VirtualFile> copyFromMap) {
        if (addedFiles == null) {
            GitVFSListener.$$$reportNull$$$0(8);
        }
        if (copyFromMap == null) {
            GitVFSListener.$$$reportNull$$$0(9);
        }
        this.saveUnsavedVcsIgnoreFiles();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, GitBundle.message((String)"vfs.listener.checking.ignored", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator pi) {
                if (pi == null) {
                    1.$$$reportNull$$$0(0);
                }
                Map<VirtualFile, List<VirtualFile>> sortedFiles = GitUtil.sortFilesByGitRootIgnoringMissing(this.myProject, addedFiles);
                HashSet<VirtualFile> retainedFiles = new HashSet<VirtualFile>();
                for (Map.Entry<VirtualFile, List<VirtualFile>> e : sortedFiles.entrySet()) {
                    VirtualFile root = e.getKey();
                    List<VirtualFile> files = e.getValue();
                    pi.setText(root.getPresentableUrl());
                    try {
                        retainedFiles.addAll(Git.getInstance().untrackedFiles(this.myProject, root, files));
                    }
                    catch (VcsException ex) {
                        GitVcsConsoleWriter.getInstance(this.myProject).showMessage(ex.getMessage());
                    }
                }
                addedFiles.retainAll(retainedFiles);
                GitVFSListener.this.performAddingWithConfirmation(addedFiles, copyFromMap);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "git4idea/vfs/GitVFSListener$1", "run"));
            }
        });
    }

    protected void performAdding(@NotNull Collection<VirtualFile> addedFiles, @NotNull Map<VirtualFile, VirtualFile> copyFromMap) {
        if (addedFiles == null) {
            GitVFSListener.$$$reportNull$$$0(10);
        }
        if (copyFromMap == null) {
            GitVFSListener.$$$reportNull$$$0(11);
        }
        this.performAdding(ContainerUtil.map(addedFiles, VcsUtil::getFilePath));
    }

    private void performAdding(Collection<? extends FilePath> filesToAdd) {
        this.performBackgroundOperation(filesToAdd, GitBundle.message((String)"add.adding", (Object[])new Object[0]), new LongOperationPerRootExecutor(){

            @Override
            public void execute(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files) throws VcsException {
                if (root == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (files == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (GitVFSListener.this.isStageEnabled()) {
                    GitVFSListener.this.executeAddingToIndex(root, files);
                } else {
                    GitVFSListener.this.executeAdding(root, files);
                }
                if (!GitVFSListener.this.myProject.isDisposed()) {
                    VcsFileUtil.markFilesDirty((Project)GitVFSListener.this.myProject, files);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "root";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "files";
                        break;
                    }
                }
                objectArray[1] = "git4idea/vfs/GitVFSListener$2";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    protected String getDeleteTitle() {
        String string = GitBundle.message((String)"vfs.listener.delete.title", (Object[])new Object[0]);
        if (string == null) {
            GitVFSListener.$$$reportNull$$$0(12);
        }
        return string;
    }

    protected String getSingleFileDeleteTitle() {
        return GitBundle.message((String)"vfs.listener.delete.single.title", (Object[])new Object[0]);
    }

    protected String getSingleFileDeletePromptTemplate() {
        return GitBundle.message((String)"vfs.listener.delete.single.prompt", (Object[])new Object[0]);
    }

    protected void performDeletion(@NotNull List<FilePath> filesToDelete) {
        if (filesToDelete == null) {
            GitVFSListener.$$$reportNull$$$0(13);
        }
        this.performBackgroundOperation(filesToDelete, GitBundle.message((String)"remove.removing", (Object[])new Object[0]), new LongOperationPerRootExecutor(){

            @Override
            public void execute(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files) throws VcsException {
                if (root == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (files == null) {
                    3.$$$reportNull$$$0(1);
                }
                GitVFSListener.this.executeDeletion(root, files);
                if (!GitVFSListener.this.myProject.isDisposed()) {
                    VcsFileUtil.markFilesDirty((Project)GitVFSListener.this.myProject, files);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "root";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "files";
                        break;
                    }
                }
                objectArray[1] = "git4idea/vfs/GitVFSListener$3";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    protected void performMoveRename(@NotNull List<VcsVFSListener.MovedFileInfo> movedFiles) {
        List<Object> selectedToRemove;
        List<Object> selectedToAdd;
        if (movedFiles == null) {
            GitVFSListener.$$$reportNull$$$0(14);
        }
        ArrayList<FilePath> toAdd = new ArrayList<FilePath>();
        ArrayList<FilePath> toRemove = new ArrayList<FilePath>();
        final ArrayList<VcsVFSListener.MovedFileInfo> toForceMove = new ArrayList<VcsVFSListener.MovedFileInfo>();
        for (VcsVFSListener.MovedFileInfo movedInfo : movedFiles) {
            String oldPath = movedInfo.myOldPath;
            String newPath = movedInfo.myNewPath;
            if (!movedInfo.isCaseSensitive() && GitUtil.isCaseOnlyChange(oldPath, newPath)) {
                toForceMove.add(movedInfo);
                continue;
            }
            toRemove.add(movedInfo.getOldPath());
            toAdd.add(movedInfo.getNewPath());
        }
        if (this.isStageEnabled()) {
            selectedToAdd = this.selectFilePathsToAdd(toAdd);
            selectedToRemove = this.selectFilePathsToDelete(toRemove);
        } else if (VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY.equals((Object)this.myRemoveOption.getValue()) && VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY.equals((Object)this.myAddOption.getValue())) {
            selectedToAdd = Collections.emptyList();
            selectedToRemove = Collections.emptyList();
        } else {
            selectedToAdd = toAdd;
            selectedToRemove = toRemove;
        }
        if (toAdd.isEmpty() && toRemove.isEmpty() && toForceMove.isEmpty()) {
            return;
        }
        LOG.debug("performMoveRename. \ntoAdd: " + String.valueOf(toAdd) + "\ntoRemove: " + String.valueOf(toRemove) + "\ntoForceMove: " + String.valueOf(toForceMove));
        GitVcs.runInBackground(new Task.Backgroundable(this.myProject, GitBundle.message((String)"progress.title.moving.files", (Object[])new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                try {
                    ArrayList<FilePath> dirtyPaths = new ArrayList<FilePath>();
                    ArrayList<Path> toRefresh = new ArrayList<Path>();
                    for (Map.Entry<VirtualFile, List<FilePath>> toAddEntry : GitUtil.sortFilePathsByGitRootIgnoringMissing(this.myProject, selectedToAdd).entrySet()) {
                        List<FilePath> files = toAddEntry.getValue();
                        GitVFSListener.this.executeAdding(toAddEntry.getKey(), files);
                        dirtyPaths.addAll(files);
                    }
                    for (Map.Entry<VirtualFile, List<FilePath>> toRemoveEntry : GitUtil.sortFilePathsByGitRootIgnoringMissing(this.myProject, selectedToRemove).entrySet()) {
                        List<FilePath> paths = toRemoveEntry.getValue();
                        GitVFSListener.this.executeDeletion(toRemoveEntry.getKey(), paths);
                        dirtyPaths.addAll(paths);
                    }
                    Map filesToForceMove = ContainerUtil.map2Map((Collection)toForceMove, info -> Pair.create((Object)info.getNewPath(), (Object)info));
                    dirtyPaths.addAll(ContainerUtil.map((Collection)toForceMove, fileInfo -> fileInfo.getOldPath()));
                    for (Map.Entry<VirtualFile, List<FilePath>> toForceMoveEntry : GitUtil.sortFilePathsByGitRootIgnoringMissing(this.myProject, filesToForceMove.keySet()).entrySet()) {
                        List<FilePath> paths = toForceMoveEntry.getValue();
                        toRefresh.addAll(GitVFSListener.this.executeForceMove(toForceMoveEntry.getKey(), paths, filesToForceMove));
                        dirtyPaths.addAll(paths);
                    }
                    VcsFileUtil.markFilesDirty((Project)this.myProject, dirtyPaths);
                    RefreshVFsSynchronously.INSTANCE.refreshFiles(toRefresh);
                }
                catch (VcsException ex) {
                    GitVcsConsoleWriter.getInstance(this.myProject).showMessage(ex.getMessage());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/vfs/GitVFSListener$4", "run"));
            }
        });
    }

    private void executeAdding(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files) throws VcsException {
        if (root == null) {
            GitVFSListener.$$$reportNull$$$0(15);
        }
        if (files == null) {
            GitVFSListener.$$$reportNull$$$0(16);
        }
        LOG.debug("Git: adding files: " + String.valueOf(files));
        GitFileUtils.addPaths(this.myProject, root, files, false, false);
    }

    private void executeAddingToIndex(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files) throws VcsException {
        if (root == null) {
            GitVFSListener.$$$reportNull$$$0(17);
        }
        if (files == null) {
            GitVFSListener.$$$reportNull$$$0(18);
        }
        LOG.debug("Git: adding files to index: " + String.valueOf(files));
        GitFileUtils.addPathsToIndex(this.myProject, root, files);
    }

    private void executeDeletion(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files) throws VcsException {
        if (root == null) {
            GitVFSListener.$$$reportNull$$$0(19);
        }
        if (files == null) {
            GitVFSListener.$$$reportNull$$$0(20);
        }
        GitFileUtils.deletePaths(this.myProject, root, files, "--ignore-unmatch", "--cached", "-r");
    }

    private Set<Path> executeForceMove(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files, @Unmodifiable @NotNull Map<FilePath, // Could not load outer class - annotation placement on inner may be incorrect
    VcsVFSListener.MovedFileInfo> filesToMove) {
        if (root == null) {
            GitVFSListener.$$$reportNull$$$0(21);
        }
        if (files == null) {
            GitVFSListener.$$$reportNull$$$0(22);
        }
        if (filesToMove == null) {
            GitVFSListener.$$$reportNull$$$0(23);
        }
        HashSet<Path> toRefresh = new HashSet<Path>();
        for (FilePath filePath : files) {
            VcsVFSListener.MovedFileInfo info = filesToMove.get(filePath);
            GitLineHandler h = new GitLineHandler(this.myProject, root, GitCommand.MV);
            h.addParameters("-f");
            h.addRelativePaths(info.getOldPath(), info.getNewPath());
            Git.getInstance().runCommand(h);
            toRefresh.add(Path.of(info.myOldPath, new String[0]));
            toRefresh.add(Path.of(info.myNewPath, new String[0]));
        }
        return toRefresh;
    }

    private boolean isStageEnabled() {
        return GitStageManagerKt.isStagingAreaAvailable(this.myProject);
    }

    protected boolean isRecursiveDeleteSupported() {
        return true;
    }

    protected boolean isFileCopyingFromTrackingSupported() {
        return false;
    }

    @NotNull
    protected List<FilePath> selectFilePathsToDelete(@NotNull List<FilePath> deletedFiles) {
        if (deletedFiles == null) {
            GitVFSListener.$$$reportNull$$$0(24);
        }
        if (this.isStageEnabled()) {
            List list = super.selectFilePathsToDelete(deletedFiles);
            if (list == null) {
                GitVFSListener.$$$reportNull$$$0(25);
            }
            return list;
        }
        if (VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY.equals((Object)this.myRemoveOption.getValue())) {
            List<FilePath> list = Collections.emptyList();
            if (list == null) {
                GitVFSListener.$$$reportNull$$$0(26);
            }
            return list;
        }
        List<FilePath> list = deletedFiles;
        if (list == null) {
            GitVFSListener.$$$reportNull$$$0(27);
        }
        return list;
    }

    private void performBackgroundOperation(final @NotNull Collection<? extends FilePath> files, @NlsContexts.ProgressTitle @NotNull String operationTitle, final @NotNull LongOperationPerRootExecutor executor) {
        if (files == null) {
            GitVFSListener.$$$reportNull$$$0(28);
        }
        if (operationTitle == null) {
            GitVFSListener.$$$reportNull$$$0(29);
        }
        if (executor == null) {
            GitVFSListener.$$$reportNull$$$0(30);
        }
        GitVcs.runInBackground(new Task.Backgroundable(this, this.myProject, operationTitle){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                GitUtil.sortFilePathsByGitRootIgnoringMissing(this.myProject, files).forEach((root, filePaths) -> {
                    try {
                        executor.execute((VirtualFile)root, (List<? extends FilePath>)filePaths);
                    }
                    catch (VcsException ex) {
                        GitVcsConsoleWriter.getInstance(this.myProject).showMessage(ex.getMessage());
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/vfs/GitVFSListener$5", "run"));
            }
        });
    }

    @TestOnly
    public void waitForExternalFilesEventsProcessedInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.waitForEventsProcessedInTestMode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 12, 25, 26, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/vfs/GitVFSListener";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedFiles";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFromMap";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToDelete";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "movedFiles";
                break;
            }
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToMove";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deletedFiles";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationTitle";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/vfs/GitVFSListener";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddTitle";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleFileAddTitle";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleFileAddPromptTemplate";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeleteTitle";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "selectFilePathsToDelete";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "executeAdd";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "performAdding";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "performDeletion";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "performMoveRename";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "executeAdding";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "executeAddingToIndex";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "executeDeletion";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "executeForceMove";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "selectFilePathsToDelete";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "performBackgroundOperation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 12, 25, 26, 27 -> new IllegalStateException(string);
        };
    }

    private static interface LongOperationPerRootExecutor {
        public void execute(@NotNull VirtualFile var1, @NotNull List<? extends FilePath> var2) throws VcsException;
    }
}

