/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.script;

import com.intellij.database.script.ScriptModelUtilCore;
import com.intellij.database.script.TooLongStatementException;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.dialects.EvaluationHelper;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CharArrayCharSequence;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public final class SqlReaderImpl {
    public static final Key<Integer> CUSTOM_CHUNK_SIZE = Key.create((String)"SQL_READER_CHUNK_SIZE_KEY");
    private static final Logger LOG = Logger.getInstance(SqlReaderImpl.class);
    private static final int READER_BUF_SIZE = 102400;
    private static final int PARSER_CHUNK = 1024000;

    @NotNull
    public static <E> JBIterable<SyntaxTraverser<E>> parseFile(final @NotNull Project project, final @NotNull Language language, final @NotNull VirtualFile virtualFile, final @NotNull Disposable disposable, final @NotNull EvaluationHelper evaluationHelper) {
        Document document;
        if (project == null) {
            SqlReaderImpl.$$$reportNull$$$0(0);
        }
        if (language == null) {
            SqlReaderImpl.$$$reportNull$$$0(1);
        }
        if (virtualFile == null) {
            SqlReaderImpl.$$$reportNull$$$0(2);
        }
        if (disposable == null) {
            SqlReaderImpl.$$$reportNull$$$0(3);
        }
        if (evaluationHelper == null) {
            SqlReaderImpl.$$$reportNull$$$0(4);
        }
        if ((document = ScriptModelUtilCore.getScriptDocument((VirtualFile)virtualFile)) != null) {
            JBIterable jBIterable = JBIterable.of((Object)evaluationHelper.parseStatements(project, language, document.getCharsSequence(), null));
            if (jBIterable == null) {
                SqlReaderImpl.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }
        return new JBIterable<SyntaxTraverser<E>>(){

            @NotNull
            public Iterator<SyntaxTraverser<E>> iterator() {
                Iterator iterator;
                try {
                    long length = virtualFile.getLength();
                    final InputStreamReader reader = new InputStreamReader(virtualFile.getInputStream(), virtualFile.getCharset());
                    Disposable inputDisposable = new Disposable(){

                        public void dispose() {
                            try {
                                reader.close();
                            }
                            catch (Exception e) {
                                LOG.warn((Throwable)e);
                            }
                        }
                    };
                    Disposer.register((Disposable)disposable, (Disposable)inputDisposable);
                    iterator = SqlReaderImpl.processSyntaxImpl(project, language, reader, length, SqlReaderImpl.getChunkSize(virtualFile), inputDisposable, evaluationHelper);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                if (iterator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlReaderImpl$1", "iterator"));
            }
        };
    }

    private static int getChunkSize(@NotNull VirtualFile file) {
        Integer customChunkSize;
        if (file == null) {
            SqlReaderImpl.$$$reportNull$$$0(6);
        }
        return (customChunkSize = (Integer)CUSTOM_CHUNK_SIZE.get((UserDataHolder)file)) == null ? 1024000 : customChunkSize;
    }

    /*
     * WARNING - void declaration
     */
    private static <E> Iterator<SyntaxTraverser<E>> processSyntaxImpl(@NotNull Project project, @NotNull Language dialect, final @NotNull Reader reader, final long fileSize, final int chunkSize, final @NotNull Disposable inputDisposable, @NotNull EvaluationHelper evaluationHelper) {
        void evaluationHelper2;
        if (project == null) {
            SqlReaderImpl.$$$reportNull$$$0(7);
        }
        if (dialect == null) {
            SqlReaderImpl.$$$reportNull$$$0(8);
        }
        if (reader == null) {
            SqlReaderImpl.$$$reportNull$$$0(9);
        }
        if (inputDisposable == null) {
            SqlReaderImpl.$$$reportNull$$$0(10);
        }
        if (evaluationHelper == null) {
            SqlReaderImpl.$$$reportNull$$$0(11);
        }
        return new Iterator<SyntaxTraverser<E>>(){
            final long myMaxMemory = Runtime.getRuntime().maxMemory();
            int myChunkSize = chunkSize;
            StringBuilder text = new StringBuilder(this.myChunkSize);
            final char[] buf = new char[Math.min(102400, this.myChunkSize)];
            final CharArrayCharSequence seq = new CharArrayCharSequence(this.buf);
            Exception error;
            boolean bufferPrepared;
            int partIndex;
            long partOffset;
            final /* synthetic */ EvaluationHelper val$evaluationHelper;
            final /* synthetic */ Project val$project;
            final /* synthetic */ Language val$dialect;
            {
                this.val$evaluationHelper = evaluationHelper;
                this.val$project = project;
                this.val$dialect = language;
            }

            @Override
            public boolean hasNext() {
                return this.bufferPrepared || this.prepareBuffer();
            }

            @Override
            public SyntaxTraverser<E> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                while (true) {
                    try {
                        SyntaxTraverser s = this.buildStatementTraverser();
                        this.bufferPrepared = false;
                        return s;
                    }
                    catch (TooLongStatementException e) {
                        if ((long)this.myChunkSize > this.myMaxMemory / 16L) {
                            throw e;
                        }
                        LOG.info(e.getMessage());
                        LOG.info("increasing parser buffer to: " + StringUtil.formatFileSize((long)this.myChunkSize) + " (file size " + StringUtil.formatFileSize((long)fileSize) + ")");
                        this.myChunkSize *= 2;
                        this.prepareBuffer();
                        continue;
                    }
                    break;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            boolean prepareBuffer() {
                int read;
                do {
                    try {
                        read = reader.read(this.buf);
                    }
                    catch (IOException e) {
                        this.error = e;
                        return false;
                    }
                    if ((read > 0 || this.text.isEmpty()) && (read <= 0 || this.text.append(this.seq.subSequence(0, read)).length() < this.myChunkSize)) continue;
                    this.bufferPrepared = true;
                    return true;
                } while (read > 0);
                Disposer.dispose((Disposable)inputDisposable);
                return false;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private SyntaxTraverser<E> buildStatementTraverser() {
                int lastOffset;
                boolean isLast = this.text.length() < this.myChunkSize;
                String str = this.text.toString();
                SyntaxTraverser traverser = this.parseStatementsImpl(str);
                int firstOffset = 0;
                if (!isLast) {
                    Object lastToSkip = traverser.traverse().last();
                    if (lastToSkip != null && traverser.api.typeOf(lastToSkip) == SqlCompositeElementTypes.SQL_INSERT_STATEMENT && traverser.api.rangeOf(lastToSkip).getStartOffset() == 0) {
                        SyntaxTraverser s = (SyntaxTraverser)traverser.reset();
                        Object valuesExpr = s.filterTypes(Conditions.equalTo((Object)SqlCompositeElementTypes.SQL_VALUES_EXPRESSION)).traverse().first();
                        Object valuesNode = s.filterTypes(Conditions.equalTo((Object)SqlCommonKeywords.SQL_VALUES)).traverse().first();
                        Condition isParExpr = Conditions.compose((Function)s.api.TO_TYPE, (Condition)Conditions.equalTo((Object)SqlCompositeElementTypes.SQL_PARENTHESIZED_EXPRESSION));
                        JBIterable parExprs = ((SyntaxTraverser)((SyntaxTraverser)((SyntaxTraverser)s.withRoot(valuesExpr)).expand(Conditions.equalTo((Object)valuesExpr))).filter(isParExpr)).traverse();
                        Object last = null;
                        Object prev = null;
                        for (Object expr : parExprs) {
                            prev = last;
                            last = expr;
                        }
                        if (valuesNode == null || last == null || prev == null) throw this.tooLongStatement(traverser, lastToSkip);
                        lastToSkip = last;
                        firstOffset = traverser.api.rangeOf(valuesNode).getEndOffset() + 1;
                        traverser = this.parseStatementsImpl(str.substring(0, traverser.api.rangeOf(prev).getEndOffset()));
                    } else {
                        if (lastToSkip == null || traverser.api.rangeOf(lastToSkip).getStartOffset() == 0) {
                            throw this.tooLongStatement(traverser, lastToSkip);
                        }
                        Object forceIgnore = lastToSkip;
                        traverser = (SyntaxTraverser)traverser.forceIgnore(input -> input == forceIgnore);
                    }
                    lastOffset = traverser.api.rangeOf(lastToSkip).getStartOffset();
                    this.text = this.text.delete(firstOffset, lastOffset);
                } else {
                    lastOffset = this.text.length();
                    this.text.setLength(0);
                }
                traverser.putUserData(ScriptModelUtilCore.PART_INDEX, (Object)this.partIndex);
                traverser.putUserData(ScriptModelUtilCore.PART_OFFSET, (Object)this.partOffset);
                ++this.partIndex;
                this.partOffset += (long)lastOffset;
                return traverser;
            }

            @NotNull
            private SyntaxTraverser<E> parseStatementsImpl(String s) {
                SyntaxTraverser syntaxTraverser = this.val$evaluationHelper.parseStatements(this.val$project, this.val$dialect, (CharSequence)s, null);
                if (syntaxTraverser == null) {
                    2.$$$reportNull$$$0(0);
                }
                return syntaxTraverser;
            }

            @NotNull
            private TooLongStatementException tooLongStatement(SyntaxTraverser<E> traverser, E lastToSkip) {
                return new TooLongStatementException(String.valueOf(lastToSkip == null ? "<unknown>" : traverser.api.typeOf(lastToSkip)) + " statement is longer than " + StringUtil.formatFileSize((long)this.myChunkSize));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlReaderImpl$2", "parseStatementsImpl"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationHelper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/script/SqlReaderImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/script/SqlReaderImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseFile";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChunkSize";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processSyntaxImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

