/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.el.util.processors;

import com.intellij.javaee.el.ELElementProcessor;
import com.intellij.javaee.el.psi.ELMethodCallExpression;
import com.intellij.javaee.el.psi.ELVariable;
import com.intellij.javaee.el.util.ELResolveUtil;
import com.intellij.javaee.model.psi.JavaeeImplicitVariable;
import com.intellij.lang.properties.IProperty;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ELElementResolveProcessor
extends ELElementProcessor {
    private final boolean allowPropertyMethodName;
    private final String myText;
    private final List<ResolveResult> myResult;
    private final Class<? extends PsiElement> myTargetClass;
    private PsiSubstitutor mySubstitutor;

    public ELElementResolveProcessor(@NotNull PsiElement context, String text, Class<? extends PsiElement> targetClass) {
        if (context == null) {
            ELElementResolveProcessor.$$$reportNull$$$0(0);
        }
        this.myResult = new SmartList();
        this.myText = text;
        this.myTargetClass = targetClass;
        this.allowPropertyMethodName = context.getParent() instanceof ELMethodCallExpression || ELResolveUtil.allowPropertyMethodName(context);
    }

    public List<ResolveResult> getResult() {
        return this.myResult;
    }

    @Override
    public boolean processVariable(ELVariable variable) {
        if (this.myText.equals(variable.getText())) {
            this.addResult((PsiElement)variable);
            return false;
        }
        return true;
    }

    @Override
    public boolean processNSPrefix(String prefix) {
        return true;
    }

    @Override
    public boolean processVariable(PsiVariable variable) {
        if (this.myText.equals(variable.getName())) {
            PsiElement resolve;
            PsiReference reference;
            PsiElement declaration;
            if (variable instanceof JavaeeImplicitVariable && (declaration = ((JavaeeImplicitVariable)variable).getDeclaration()) instanceof XmlAttributeValue && (reference = declaration.getReference()) != null && (resolve = reference.resolve()) instanceof PsiVariable) {
                this.addResult(resolve);
                return false;
            }
            this.addResult((PsiElement)variable);
            return false;
        }
        return true;
    }

    @Override
    public boolean processMethod(PsiMethod method) {
        String propertyName = PropertyUtilBase.getPropertyName((PsiMethod)method);
        if (this.myText.equals(propertyName)) {
            this.createResult(method);
        }
        if ((propertyName == null || this.allowPropertyMethodName) && this.myText.equals(method.getName())) {
            this.createResult(method);
            return true;
        }
        return true;
    }

    private void createResult(PsiMethod method) {
        this.addResult((PsiElement)method);
        method.putUserData(ELResolveUtil.SUBSTITUTOR, (Object)this.mySubstitutor);
    }

    private void addResult(PsiElement element) {
        this.myResult.add((ResolveResult)new PsiElementResolveResult(element));
    }

    @Override
    public boolean processField(PsiField field) {
        if (this.myText.equals(field.getName())) {
            this.addResult((PsiElement)field);
            return false;
        }
        return true;
    }

    @Override
    public boolean processClass(PsiClass psiClass, PsiImportStatement importStatement) {
        if (this.myText.equals(psiClass.getName())) {
            this.myResult.add((ResolveResult)new CandidateInfo((PsiElement)psiClass, PsiSubstitutor.EMPTY, null, null, false, (PsiElement)importStatement));
            return false;
        }
        return true;
    }

    @Override
    public boolean processProperty(IProperty property) {
        if (this.myText.equals(property.getName())) {
            this.addResult(property.getPsiElement());
        }
        return true;
    }

    @Override
    public void setSubstitutor(PsiSubstitutor substitutor) {
        this.mySubstitutor = substitutor;
    }

    @Override
    @Nullable
    public String getNameHint() {
        return this.myText;
    }

    @Override
    @Nullable
    public Class<? extends PsiElement> getTargetClass() {
        return this.myTargetClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javaee/el/util/processors/ELElementResolveProcessor", "<init>"));
    }
}

