/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.microservices.jvm.config.RelaxedNames;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.quarkus.config.QsConfigFileContributor;
import com.intellij.quarkus.config.jam.QsConfigItem;
import com.intellij.util.Processor;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/quarkus/config/QsConfigKeyReferenceSearcher;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;", "<init>", "()V", "processQuery", "", "parameters", "consumer", "Lcom/intellij/util/Processor;", "processConfigRootKey", "psiField", "Lcom/intellij/psi/PsiField;", "name", "", "getConfigRootKeyEffectiveSearchScope", "Lcom/intellij/psi/search/SearchScope;", "processConfigPropertiesKey", "intellij.quarkus"})
public final class QsConfigKeyReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public QsConfigKeyReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters parameters, @NotNull Processor<? super PsiReference> consumer) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (!QuarkusUtils.INSTANCE.hasQuarkusLibrary(parameters.getProject())) {
            return;
        }
        JamMemberMeta[] jamMemberMetaArray = parameters.getElementToSearch();
        PsiField psiField = jamMemberMetaArray instanceof PsiField ? (PsiField)jamMemberMetaArray : null;
        if (psiField == null) {
            return;
        }
        PsiField psiField2 = psiField;
        if (psiField2.hasModifier(JvmModifier.STATIC)) {
            return;
        }
        jamMemberMetaArray = new JamMemberMeta[]{QsConfigItem.Companion.getFIELD_META()};
        QsConfigItem item = (QsConfigItem)JamService.getJamService((Project)parameters.getProject()).getJamElement((PsiElement)psiField2, jamMemberMetaArray);
        if (item != null) {
            this.processConfigRootKey(parameters, psiField2, item.getName());
        } else {
            this.processConfigPropertiesKey(parameters, psiField2);
        }
    }

    private final void processConfigRootKey(ReferencesSearch.SearchParameters parameters, PsiField psiField, String name) {
        SearchScope searchScope = QsConfigFileContributor.Companion.getReferenceSearchScope(this.getConfigRootKeyEffectiveSearchScope(parameters, psiField));
        parameters.getOptimizer().searchWord(name, searchScope, (short)255, true, (PsiElement)psiField);
    }

    private final SearchScope getConfigRootKeyEffectiveSearchScope(ReferencesSearch.SearchParameters parameters, PsiField psiField) {
        if (parameters.isIgnoreAccessScope() || psiField.hasModifier(JvmModifier.PUBLIC)) {
            SearchScope searchScope = parameters.getEffectiveSearchScope();
            Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getEffectiveSearchScope(...)");
            return searchScope;
        }
        PsiClass psiClass = psiField.getContainingClass();
        if (psiClass == null) {
            SearchScope searchScope = parameters.getEffectiveSearchScope();
            Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getEffectiveSearchScope(...)");
            return searchScope;
        }
        PsiClass psiClass2 = psiClass;
        if (!psiClass2.isValid()) {
            SearchScope searchScope = parameters.getEffectiveSearchScope();
            Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getEffectiveSearchScope(...)");
            return searchScope;
        }
        SearchScope searchScope = PsiSearchHelper.getInstance((Project)psiClass2.getProject()).getUseScope((PsiElement)psiClass2);
        Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getUseScope(...)");
        SearchScope useScope = searchScope;
        SearchScope searchScope2 = parameters.getScopeDeterminedByUser().intersectWith(useScope);
        Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"intersectWith(...)");
        return searchScope2;
    }

    private final void processConfigPropertiesKey(ReferencesSearch.SearchParameters parameters, PsiField psiField) {
        if (!psiField.hasModifier(JvmModifier.PUBLIC) || psiField.hasModifier(JvmModifier.FINAL)) {
            return;
        }
        PsiClass psiClass = psiField.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiClass psiClass2 = psiClass;
        if (!psiClass2.isValid()) {
            return;
        }
        String string = psiField.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name = string;
        PsiMethod setter = PropertyUtilBase.findPropertySetter((PsiClass)psiClass2, (String)name, (boolean)false, (boolean)false);
        if (setter != null) {
            return;
        }
        String string2 = RelaxedNames.camelCaseToHyphen((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"camelCaseToHyphen(...)");
        String string3 = string2;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string4 = string3.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        String hyphenedName = string4;
        if (!Intrinsics.areEqual((Object)hyphenedName, (Object)name)) {
            SearchScope searchScope = parameters.getEffectiveSearchScope();
            Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getEffectiveSearchScope(...)");
            SearchScope searchScope2 = QsConfigFileContributor.Companion.getReferenceSearchScope(searchScope);
            parameters.getOptimizer().searchWord(hyphenedName, searchScope2, (short)255, true, (PsiElement)psiField);
        }
    }
}

