/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.validation.fixes.JSRemoveReadonlyModifierFix;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.HintedPsiElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.angular2.codeInsight.Angular2HighlightingUtils;
import org.angular2.codeInsight.config.Angular2Compiler;
import org.angular2.entities.source.Angular2SourceUtil;
import org.angular2.inspections.AngularInaccessibleSymbolInspection;
import org.angular2.inspections.AngularInaccessibleSymbolInspectionKt;
import org.angular2.inspections.quickfixes.AngularChangeModifierQuickFix;
import org.angular2.lang.Angular2Bundle;
import org.angular2.lang.expr.Angular2Language;
import org.angular2.lang.html.Angular2HtmlLanguage;
import org.angular2.lang.html.psi.Angular2HtmlPropertyBinding;
import org.angular2.lang.html.psi.PropertyBindingType;
import org.angular2.signals.Angular2SignalUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/angular2/inspections/AngularInaccessibleSymbolInspection;", "Lcom/intellij/lang/javascript/inspections/JSInspection;", "<init>", "()V", "isCoveredByTypeScriptServiceHighlighting", "", "()Z", "createVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "intellij.angular"})
public final class AngularInaccessibleSymbolInspection
extends JSInspection {
    public boolean isCoveredByTypeScriptServiceHighlighting() {
        return true;
    }

    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Language language2 = holder.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"getLanguage(...)");
        Language fileLang = language2;
        if (fileLang.isKindOf((Language)Angular2HtmlLanguage.INSTANCE) || fileLang.isKindOf((Language)Angular2Language.INSTANCE)) {
            return (PsiElementVisitor)new HintedPsiElementVisitor(holder){
                final /* synthetic */ ProblemsHolder $holder;
                {
                    this.$holder = $holder;
                }

                public List<Class<?>> getHintPsiElements() {
                    Object[] objectArray = new Class[]{JSReferenceExpression.class, Angular2HtmlPropertyBinding.class};
                    return CollectionsKt.listOf((Object[])objectArray);
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    PsiElement psiElement = element;
                    if (psiElement instanceof JSReferenceExpression) {
                        this.checkReference((JSReferenceExpression)element);
                    } else if (psiElement instanceof Angular2HtmlPropertyBinding) {
                        this.checkPropertyBinding((Angular2HtmlPropertyBinding)element);
                    }
                    super.visitElement(element);
                }

                private final void checkReference(JSReferenceExpression node) {
                    Object[] objectArray;
                    PsiElement resolved;
                    TypeScriptClass clazz;
                    if ((node.getQualifier() == null || node.getQualifier() instanceof JSThisExpression) && (clazz = (TypeScriptClass)PsiTreeUtil.getContextOfType((PsiElement)(resolved = node.resolve()), (Class[])(objectArray = new Class[]{TypeScriptClass.class}))) != null && resolved instanceof JSElement && !AngularInaccessibleSymbolInspectionKt.isAccessible(resolved, JSAttributeList.AccessType.PROTECTED)) {
                        PsiElement psiElement = node.getReferenceNameElement();
                        if (psiElement == null) {
                            psiElement = (PsiElement)node;
                        }
                        String string = Angular2Compiler.INSTANCE.isStrictTemplates((PsiElement)clazz) ? "angular.inspection.inaccessible-symbol.strict.private.message" : "angular.inspection.inaccessible-symbol.aot.message";
                        objectArray = new Object[4];
                        Intrinsics.checkNotNullExpressionValue((Object)StringUtil.capitalize((String)AngularInaccessibleSymbolInspectionKt.access$getKind(resolved)), (String)"capitalize(...)");
                        objectArray[1] = AngularInaccessibleSymbolInspectionKt.access$getHtmlName(resolved);
                        objectArray[2] = AngularInaccessibleSymbolInspectionKt.access$getHtmlAccessModifier((JSElement)resolved);
                        objectArray[3] = Angular2HighlightingUtils.INSTANCE.getHtmlName((JSClass)clazz);
                        String string2 = Angular2Bundle.Companion.htmlMessage(string, objectArray);
                        objectArray = new LocalQuickFix[]{new AngularChangeModifierQuickFix(JSAttributeList.AccessType.PROTECTED, null, 2, null)};
                        this.$holder.registerProblem(psiElement, string2, (LocalQuickFix[])objectArray);
                    }
                }

                private final void checkPropertyBinding(Angular2HtmlPropertyBinding element) {
                    if (element.getBindingType() == PropertyBindingType.PROPERTY) {
                        if (!Angular2Compiler.INSTANCE.isStrictInputAccessModifiers((PsiElement)element)) {
                            return;
                        }
                        List<JSAttributeListOwner> inputElements = AngularInaccessibleSymbolInspectionKt.getInputSourceElements(element);
                        TypeScriptClass typeScriptClass = Angular2SourceUtil.findComponentClass((PsiElement)element);
                        if (typeScriptClass == null) {
                            return;
                        }
                        TypeScriptClass owner = typeScriptClass;
                        for (JSAttributeListOwner input : inputElements) {
                            Object[] objectArray;
                            TypeScriptClass inputOwner;
                            JSAttributeList.AccessType minAccessType;
                            JSAttributeList jSAttributeList = input.getAttributeList();
                            JSAttributeList.AccessType accessType = jSAttributeList != null ? jSAttributeList.getAccessType() : null;
                            PsiElement $this$parentOfType_u24default$iv = (PsiElement)input;
                            boolean withSelf$iv = false;
                            boolean $i$f$parentOfType = false;
                            if ((TypeScriptClass)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, TypeScriptClass.class, (boolean)true) == null) {
                                return;
                            }
                            JSAttributeList.AccessType accessType2 = minAccessType = Intrinsics.areEqual((Object)inputOwner, (Object)owner) ? JSAttributeList.AccessType.PROTECTED : JSAttributeList.AccessType.PUBLIC;
                            if (!AngularInaccessibleSymbolInspectionKt.isAccessible((PsiElement)input, minAccessType)) {
                                PsiElement psiElement = (PsiElement)element.getNameElement();
                                String string = accessType == JSAttributeList.AccessType.PRIVATE ? "angular.inspection.inaccessible-symbol.strict.private.message" : "angular.inspection.inaccessible-symbol.strict.protected.message";
                                objectArray = new Object[4];
                                Intrinsics.checkNotNullExpressionValue((Object)StringUtil.capitalize((String)AngularInaccessibleSymbolInspectionKt.access$getKind((PsiElement)input)), (String)"capitalize(...)");
                                objectArray[1] = AngularInaccessibleSymbolInspectionKt.access$getHtmlName((PsiElement)input);
                                objectArray[2] = AngularInaccessibleSymbolInspectionKt.access$getHtmlAccessModifier((JSElement)input);
                                objectArray[3] = Angular2HighlightingUtils.INSTANCE.getHtmlName((JSClass)inputOwner);
                                String string2 = Angular2Bundle.Companion.htmlMessage(string, objectArray);
                                objectArray = new LocalQuickFix[]{new AngularChangeModifierQuickFix(minAccessType, inputOwner.getName())};
                                this.$holder.registerProblem(psiElement, string2, (LocalQuickFix[])objectArray);
                                continue;
                            }
                            JSAttributeList jSAttributeList2 = input.getAttributeList();
                            boolean bl = jSAttributeList2 != null ? jSAttributeList2.hasModifier(JSAttributeList.ModifierType.READONLY) : false;
                            if (!bl || ((Boolean)JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)((PsiElement)element), () -> createVisitor.1.checkPropertyBinding$lambda$0(input))).booleanValue()) continue;
                            objectArray = new Object[]{AngularInaccessibleSymbolInspectionKt.access$getHtmlName((PsiElement)input), AngularInaccessibleSymbolInspectionKt.access$getHtmlAccessModifier((JSElement)input), Angular2HighlightingUtils.INSTANCE.getHtmlName((JSClass)inputOwner)};
                            String string = Angular2Bundle.Companion.htmlMessage("angular.inspection.inaccessible-symbol.strict.read-only.message", objectArray);
                            objectArray = new LocalQuickFix[]{new JSRemoveReadonlyModifierFix(input)};
                            this.$holder.registerProblem((PsiElement)element.getNameElement(), string, (LocalQuickFix[])objectArray);
                        }
                    }
                }

                private static final boolean checkPropertyBinding$lambda$0(JSAttributeListOwner $input) {
                    return Angular2SignalUtils.INSTANCE.isDirectiveSignalInputOrOutput((PsiElement)$input);
                }
            };
        }
        PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
        Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
        return psiElementVisitor;
    }
}

