/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi;

import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class FtlLoopVariablesResolver {
    private final Map<String, List<FtlVariable>> myNewMap = new HashMap<String, List<FtlVariable>>();
    private final Map<String, List<FtlVariable>> myOldMap = new HashMap<String, List<FtlVariable>>();

    public void addVariable(FtlVariable declaration) {
        if (this.myOldMap.containsKey(declaration.getName())) {
            return;
        }
        SmartList list = this.myNewMap.get(declaration.getName());
        if (list == null) {
            list = new SmartList();
            this.myNewMap.put(declaration.getName(), (List<FtlVariable>)list);
        }
        list.add((FtlVariable)declaration);
    }

    public void handleLevelChange() {
        this.myOldMap.putAll(this.myNewMap);
        this.myNewMap.clear();
    }

    public Collection<FtlVariable> getResults() {
        this.handleLevelChange();
        return ContainerUtil.concat(this.myOldMap.values());
    }
}

