/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.files;

import com.intellij.freemarker.lexer.FtlDirectiveStyle;
import com.intellij.freemarker.lexer.FtlLexer;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.files.FtlFileType;
import com.intellij.freemarker.psi.files.FtlFileViewProvider;
import com.intellij.freemarker.psi.files.FtlSyntaxHighlighter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.templateLanguages.TemplateDataHighlighterWrapper;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FtlEditorHighlighter
extends LayeredLexerEditorHighlighter {
    private FtlDirectiveStyle myStyle;
    @Nullable
    private final Project myProject;
    @Nullable
    private final VirtualFile myVirtualFile;

    public FtlEditorHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile, @NotNull EditorColorsScheme colors) {
        if (colors == null) {
            FtlEditorHighlighter.$$$reportNull$$$0(0);
        }
        super((SyntaxHighlighter)new FtlSyntaxHighlighter(), colors);
        this.myProject = project;
        this.myVirtualFile = virtualFile;
        this.registerLayer((IElementType)FtlElementTypes.TEMPLATE_TEXT, new LayerDescriptor((SyntaxHighlighter)new TemplateDataHighlighterWrapper(FtlEditorHighlighter.getHighlighter(project, virtualFile)), ""));
        if (virtualFile != null) {
            this.myStyle = FtlLexer.guessDirectiveStyle(virtualFile, project);
        }
    }

    protected boolean updateLayers(@NotNull DocumentEvent e) {
        if (e == null) {
            FtlEditorHighlighter.$$$reportNull$$$0(1);
        }
        if (this.styleIsDefinitelyUnaffected(e)) {
            return false;
        }
        return this.updateLayers();
    }

    private boolean styleIsDefinitelyUnaffected(@NotNull DocumentEvent e) {
        if (e == null) {
            FtlEditorHighlighter.$$$reportNull$$$0(2);
        }
        if (this.myStyle != null && e.getOldLength() < 100 && e.getNewLength() < 100) {
            return !this.mightAffectStyle(e.getOldFragment(), e.getNewFragment(), e.getOffset(), e.getDocument());
        }
        return false;
    }

    private boolean mightAffectStyle(CharSequence oldFragment, CharSequence newFragment, int start, Document document) {
        String[] criticalTokens;
        char anotherStyleBrace;
        char currentStyleBrace = this.myStyle == FtlDirectiveStyle.ANGLE ? (char)'<' : '[';
        char c = anotherStyleBrace = this.myStyle == FtlDirectiveStyle.ANGLE ? (char)'[' : '<';
        if (StringUtil.indexOf((CharSequence)oldFragment, (char)currentStyleBrace) >= 0) {
            return true;
        }
        if (StringUtil.indexOf((CharSequence)newFragment, (char)anotherStyleBrace) >= 0) {
            return true;
        }
        CharSequence before = document.getImmutableCharSequence().subSequence(0, start);
        CharSequence after = document.getImmutableCharSequence().subSequence(start, start + newFragment.length());
        for (String token : criticalTokens = new String[]{"<#", "[#", "</#", "[/#", "${", "#{"}) {
            for (int split = 1; split < token.length(); ++split) {
                if (!StringUtil.endsWith((CharSequence)before, (CharSequence)token.substring(0, split)) && !StringUtil.startsWith((CharSequence)after, (CharSequence)token.substring(split))) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean updateLayers() {
        if (this.myVirtualFile == null || !this.myVirtualFile.isValid() || !FileTypeRegistry.getInstance().isFileOfType(this.myVirtualFile, (FileType)FtlFileType.INSTANCE)) {
            return false;
        }
        FtlDirectiveStyle style = FtlLexer.guessDirectiveStyle(this.myVirtualFile, this.myProject);
        if (style != this.myStyle) {
            this.myStyle = style;
            ((FtlLexer)this.getLexer()).clearStyle();
            return true;
        }
        return false;
    }

    @NotNull
    private static SyntaxHighlighter getHighlighter(Project project, VirtualFile virtualFile) {
        LanguageFileType type = project == null || virtualFile == null ? null : FtlFileViewProvider.getTemplateDataLanguage(virtualFile, project).getAssociatedFileType();
        LanguageFileType fileType = type == null ? FileTypes.PLAIN_TEXT : type;
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)fileType, (Project)project, (VirtualFile)virtualFile);
        assert (highlighter != null);
        SyntaxHighlighter syntaxHighlighter = highlighter;
        if (syntaxHighlighter == null) {
            FtlEditorHighlighter.$$$reportNull$$$0(3);
        }
        return syntaxHighlighter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colors";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/psi/files/FtlEditorHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/psi/files/FtlEditorHighlighter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateLayers";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "styleIsDefinitelyUnaffected";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

