/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.profile.pegdown;

import com.vladsch.flexmark.ext.abbreviation.AbbreviationExtension;
import com.vladsch.flexmark.ext.anchorlink.AnchorLinkExtension;
import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.ext.definition.DefinitionExtension;
import com.vladsch.flexmark.ext.escaped.character.EscapedCharacterExtension;
import com.vladsch.flexmark.ext.footnotes.FootnoteExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughSubscriptExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.SubscriptExtension;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListExtension;
import com.vladsch.flexmark.ext.ins.InsExtension;
import com.vladsch.flexmark.ext.superscript.SuperscriptExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.ext.toc.SimTocExtension;
import com.vladsch.flexmark.ext.toc.TocExtension;
import com.vladsch.flexmark.ext.toc.internal.TocOptions;
import com.vladsch.flexmark.ext.typographic.TypographicExtension;
import com.vladsch.flexmark.ext.wikilink.WikiLinkExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.ParserEmulationProfile;
import com.vladsch.flexmark.util.ast.KeepType;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.misc.Extension;
import java.util.ArrayList;
import java.util.Arrays;

public class PegdownOptionsAdapter {
    public static final DataKey<Integer> PEGDOWN_EXTENSIONS = ParserEmulationProfile.PEGDOWN_EXTENSIONS;
    private final MutableDataSet myOptions;
    private int myPegdownExtensions = 0;
    private boolean myIsUpdateNeeded = false;

    public PegdownOptionsAdapter() {
        this.myOptions = new MutableDataSet();
    }

    public PegdownOptionsAdapter(DataHolder dataSet) {
        this.myOptions = new MutableDataSet(dataSet);
    }

    public PegdownOptionsAdapter(int pegdownExtensions) {
        this.myOptions = new MutableDataSet();
        this.myPegdownExtensions = pegdownExtensions;
        this.myIsUpdateNeeded = true;
    }

    public static DataHolder flexmarkOptions(int pegdownExtensions, Extension ... extensions) {
        return PegdownOptionsAdapter.flexmarkOptions(false, pegdownExtensions, extensions);
    }

    public static DataHolder flexmarkOptions(boolean strictHtml, int pegdownExtensions, Extension ... extensions) {
        PegdownOptionsAdapter optionsAdapter = new PegdownOptionsAdapter(pegdownExtensions);
        return optionsAdapter.getFlexmarkOptions(strictHtml, extensions);
    }

    public boolean haveAnyExtensions(int mask) {
        return ParserEmulationProfile.haveAny(this.myPegdownExtensions, mask);
    }

    public boolean haveAllExtensions(int mask) {
        return ParserEmulationProfile.haveAll(this.myPegdownExtensions, mask);
    }

    public DataHolder getFlexmarkOptions(Extension ... additionalExtensions) {
        return this.getFlexmarkOptions(false, additionalExtensions);
    }

    public DataHolder getFlexmarkOptions(boolean strictHtml, Extension ... additionalExtensions) {
        if (this.myIsUpdateNeeded) {
            this.myIsUpdateNeeded = false;
            MutableDataSet options = this.myOptions;
            ArrayList<Extension> extensions = new ArrayList<Extension>(Arrays.asList(additionalExtensions));
            options.clear();
            options.set((DataKey)ParserEmulationProfile.PEGDOWN_EXTENSIONS, (Object)this.myPegdownExtensions);
            options.setFrom(strictHtml ? ParserEmulationProfile.PEGDOWN_STRICT : ParserEmulationProfile.PEGDOWN);
            options.set((DataKey)HtmlRenderer.SUPPRESS_HTML_BLOCKS, (Object)this.haveAnyExtensions(65536));
            options.set((DataKey)HtmlRenderer.SUPPRESS_INLINE_HTML, (Object)this.haveAnyExtensions(131072));
            extensions.add(EscapedCharacterExtension.create());
            if (this.haveAnyExtensions(4)) {
                extensions.add(AbbreviationExtension.create());
                options.set((DataKey)AbbreviationExtension.ABBREVIATIONS_KEEP, (Object)KeepType.LAST);
            }
            if (this.haveAnyExtensions(0x400400)) {
                options.set((DataKey)HtmlRenderer.RENDER_HEADER_ID, (Object)false);
                extensions.add(AnchorLinkExtension.create());
                if (this.haveAnyExtensions(0x400000)) {
                    options.set((DataKey)AnchorLinkExtension.ANCHORLINKS_WRAP_TEXT, (Object)false);
                } else if (this.haveAnyExtensions(1024)) {
                    options.set((DataKey)AnchorLinkExtension.ANCHORLINKS_WRAP_TEXT, (Object)true);
                }
            }
            if (this.haveAnyExtensions(16)) {
                extensions.add(AutolinkExtension.create());
            }
            if (this.haveAnyExtensions(64)) {
                extensions.add(DefinitionExtension.create());
            }
            if (!this.haveAnyExtensions(128)) {
                options.set((DataKey)Parser.FENCED_CODE_BLOCK_PARSER, (Object)false);
            } else {
                options.set((DataKey)Parser.MATCH_CLOSING_FENCE_CHARACTERS, (Object)false);
            }
            if (this.haveAnyExtensions(0x10000000)) {
                options.set((DataKey)Parser.LISTS_LOOSE_WHEN_HAS_NON_LIST_CHILDREN, (Object)true);
            }
            if (this.haveAnyExtensions(8)) {
                options.set((DataKey)HtmlRenderer.SOFT_BREAK, (Object)"<br />\n");
                options.set((DataKey)HtmlRenderer.HARD_BREAK, (Object)"<br />\n");
            }
            if (!this.haveAnyExtensions(262144)) {
                options.set((DataKey)Parser.HEADING_NO_ATX_SPACE, (Object)true);
            }
            if (this.haveAnyExtensions(3)) {
                extensions.add(TypographicExtension.create());
                options.set((DataKey)TypographicExtension.ENABLE_SMARTS, (Object)this.haveAnyExtensions(1));
                options.set((DataKey)TypographicExtension.ENABLE_QUOTES, (Object)this.haveAnyExtensions(2));
            }
            if (!this.haveAnyExtensions(0x100000)) {
                options.set((DataKey)Parser.THEMATIC_BREAK_RELAXED_START, (Object)false);
            }
            if (this.haveAnyExtensions(32)) {
                extensions.add(TablesExtension.create());
                options.set((DataKey)TablesExtension.TRIM_CELL_WHITESPACE, (Object)false);
                options.set((DataKey)TablesExtension.HEADER_SEPARATOR_COLUMN_MATCH, (Object)false);
            }
            if (this.haveAnyExtensions(0x200000)) {
                extensions.add(TaskListExtension.create());
            }
            if (this.haveAnyExtensions(256)) {
                extensions.add(WikiLinkExtension.create());
                options.set((DataKey)WikiLinkExtension.LINK_FIRST_SYNTAX, (Object)false);
                options.set((DataKey)WikiLinkExtension.ALLOW_ANCHORS, (Object)true);
            }
            if (this.haveAnyExtensions(524288) && this.haveAnyExtensions(512)) {
                extensions.add(StrikethroughSubscriptExtension.create());
            } else if (this.haveAnyExtensions(512)) {
                extensions.add(StrikethroughExtension.create());
            } else if (this.haveAnyExtensions(524288)) {
                extensions.add(SubscriptExtension.create());
            }
            if (this.haveAnyExtensions(0x8000000)) {
                extensions.add(SuperscriptExtension.create());
            }
            if (this.haveAnyExtensions(0x40000000)) {
                extensions.add(InsExtension.create());
            }
            if (this.haveAnyExtensions(0x2000000)) {
                extensions.add(SimTocExtension.create());
                options.set((DataKey)TocExtension.BLANK_LINE_SPACER, (Object)true);
                extensions.add(TocExtension.create());
                options.set((DataKey)TocExtension.LEVELS, (Object)TocOptions.getLevels(2, 3));
            }
            if (this.haveAnyExtensions(0x4000000)) {
                options.set((DataKey)Parser.PARSE_MULTI_LINE_IMAGE_URLS, (Object)true);
            }
            if (this.haveAnyExtensions(0x1000000)) {
                extensions.add(FootnoteExtension.create());
                options.set((DataKey)FootnoteExtension.FOOTNOTES_KEEP, (Object)KeepType.LAST);
            }
            this.myOptions.set((DataKey)Parser.EXTENSIONS, (Object)extensions);
        }
        return this.myOptions.toImmutable();
    }

    public PegdownOptionsAdapter setPegdownExtensions(int pegdownExtensions) {
        this.myPegdownExtensions = pegdownExtensions;
        this.myIsUpdateNeeded = true;
        return this;
    }

    public PegdownOptionsAdapter addPegdownExtensions(int pegdownExtensions) {
        this.myPegdownExtensions |= pegdownExtensions;
        this.myIsUpdateNeeded = true;
        return this;
    }

    public PegdownOptionsAdapter removePegdownExtensions(int pegdownExtensions) {
        this.myPegdownExtensions &= ~pegdownExtensions;
        this.myIsUpdateNeeded = true;
        return this;
    }
}

