/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence.builder.tree;

import com.vladsch.flexmark.util.misc.DelimitedBuilder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.builder.BasedSegmentBuilder;
import com.vladsch.flexmark.util.sequence.builder.IBasedSegmentBuilder;
import com.vladsch.flexmark.util.sequence.builder.Seg;
import com.vladsch.flexmark.util.sequence.builder.tree.Segment;
import com.vladsch.flexmark.util.sequence.builder.tree.SegmentOffsetTree;
import com.vladsch.flexmark.util.sequence.builder.tree.SegmentTreePos;
import com.vladsch.flexmark.util.sequence.builder.tree.SegmentTreeRange;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SegmentTree {
    public static final int MAX_VALUE = 0x1FFFFFFF;
    public static final int F_ANCHOR_FLAGS = -536870912;
    protected final int[] treeData;
    protected final byte[] segmentBytes;

    protected SegmentTree(int[] treeData, byte[] segmentBytes) {
        this.treeData = treeData;
        this.segmentBytes = segmentBytes;
    }

    public int[] getTreeData() {
        return this.treeData;
    }

    public byte[] getSegmentBytes() {
        return this.segmentBytes;
    }

    public int size() {
        return this.treeData.length / 2;
    }

    public int aggrLength(int pos) {
        return pos < 0 ? 0 : this.treeData[pos << 1];
    }

    public int byteOffsetData(int pos) {
        return this.treeData[(pos << 1) + 1];
    }

    public int byteOffset(int pos) {
        return SegmentTree.getByteOffset(this.treeData[(pos << 1) + 1]);
    }

    public static int getByteOffset(int byteOffsetData) {
        int offset = byteOffsetData & 0x1FFFFFFF;
        return offset == 0x1FFFFFFF ? -1 : offset;
    }

    public static int getAnchorOffset(int byteOffsetData) {
        return (byteOffsetData & 0xE0000000) >>> 29;
    }

    public boolean hasPreviousAnchor(int pos) {
        return SegmentTree.getAnchorOffset(this.treeData[(pos << 1) + 1]) > 0;
    }

    public int previousAnchorOffset(int pos) {
        int byteOffsetData = this.byteOffsetData(pos);
        return SegmentTree.getByteOffset(byteOffsetData) - SegmentTree.getAnchorOffset(byteOffsetData);
    }

    @Nullable
    public SegmentTreePos findSegmentPos(int index) {
        return SegmentTree.findSegmentPos(index, this.treeData, 0, this.size());
    }

    @NotNull
    public Segment getSegment(int byteOffset, int pos, int startIndex, @NotNull BasedSequence baseSeq) {
        return Segment.getSegment(this.segmentBytes, byteOffset, pos, startIndex, baseSeq);
    }

    @Nullable
    public Segment findSegment(int index, @NotNull BasedSequence baseSeq, @Nullable Segment hint) {
        return this.findSegment(index, 0, this.size(), baseSeq, hint);
    }

    @Nullable
    public Segment findSegment(int index, int startPos, int endPos, @NotNull BasedSequence baseSeq, @Nullable Segment hint) {
        SegmentTreePos treePos;
        if (hint != null) {
            int startIndex = hint.getStartIndex();
            if (index >= startIndex) {
                int endIndex = hint.getEndIndex();
                assert (index >= endIndex) : String.format("FindSegment should not be called, index %d is in range [%d, %d) of hint segment: %s", index, startIndex, endIndex, hint);
                if (hint.pos + 1 >= endPos) {
                    return null;
                }
                int nextLength = this.aggrLength(hint.pos + 1);
                if (index < nextLength) {
                    return Segment.getSegment(this.segmentBytes, this.byteOffset(hint.pos + 1), hint.pos + 1, endIndex, baseSeq);
                }
                startPos = hint.pos + 2;
            } else {
                if (hint.pos == startPos) {
                    return null;
                }
                int prevPrevLength = this.aggrLength(hint.pos - 2);
                if (index >= prevPrevLength) {
                    return Segment.getSegment(this.segmentBytes, this.byteOffset(hint.pos - 1), hint.pos - 1, prevPrevLength, baseSeq);
                }
                endPos = hint.pos - 1;
            }
        }
        if (startPos >= 0 && startPos < this.size()) {
            int firstLength = this.aggrLength(startPos);
            if (index < firstLength) {
                int prevLength = this.aggrLength(startPos - 1);
                if (index >= prevLength) {
                    return Segment.getSegment(this.segmentBytes, this.byteOffset(startPos), startPos, prevLength, baseSeq);
                }
                endPos = startPos;
            } else {
                ++startPos;
            }
        }
        if (endPos - 1 >= startPos) {
            int secondToLastLength = this.aggrLength(endPos - 2);
            if (index >= secondToLastLength) {
                int lastLength = this.aggrLength(endPos - 1);
                if (index >= lastLength) {
                    return null;
                }
                return Segment.getSegment(this.segmentBytes, this.byteOffset(endPos - 1), endPos - 1, secondToLastLength, baseSeq);
            }
            --endPos;
        }
        if ((treePos = this.findSegmentPos(index, startPos, endPos)) != null) {
            return Segment.getSegment(this.segmentBytes, this.byteOffset(treePos.pos), treePos.pos, treePos.startIndex, baseSeq);
        }
        return null;
    }

    @NotNull
    public SegmentTreeRange getSegmentRange(int startIndex, int endIndex, int startPos, int endPos, @NotNull BasedSequence baseSequence, @Nullable Segment hint) {
        Segment endSegment;
        Segment startSegment;
        if (startIndex == endIndex) {
            Segment segment = startSegment = hint == null || hint.notInSegment(startIndex) ? this.findSegment(startIndex, startPos, endPos, baseSequence, hint) : hint;
            if (startSegment == null) {
                Segment nextSegment;
                assert (startIndex > 0);
                Segment segment2 = startSegment = hint == null || hint.notInSegment(startIndex - 1) ? this.findSegment(startIndex - 1, startPos, endPos, baseSequence, hint) : hint;
                assert (startSegment != null);
                if (startSegment.notInSegment(startIndex) && startSegment.pos + 1 < this.size() && !(nextSegment = this.getSegment(startSegment.pos + 1, baseSequence)).notInSegment(startIndex)) {
                    startSegment = nextSegment;
                }
            }
            endSegment = startSegment;
        } else {
            Segment segment = startSegment = hint == null || hint.notInSegment(startIndex) ? this.findSegment(startIndex, startPos, endPos, baseSequence, hint) : hint;
            assert (startSegment != null);
            Segment segment3 = !startSegment.notInSegment(endIndex - 1) ? startSegment : (endSegment = hint == null || hint.notInSegment(endIndex - 1) ? this.findSegment(endIndex - 1, startPos, endPos, baseSequence, startSegment) : hint);
            assert (endSegment != null);
        }
        int startOffset = -1;
        int endOffset = -1;
        startOffset = startSegment.isText() ? this.getTextStartOffset(startSegment, baseSequence) : startSegment.getStartOffset() + startIndex - startSegment.getStartIndex();
        endOffset = endSegment.isText() ? this.getTextEndOffset(endSegment, baseSequence) : endSegment.getStartOffset() + endIndex - endSegment.getStartIndex();
        if (startOffset < 0) {
            if (startSegment.pos + 1 < this.size()) {
                Segment nextSegment = this.getSegment(startSegment.pos + 1, baseSequence);
                startOffset = nextSegment.getStartOffset();
                if (startOffset > endOffset && endOffset != -1) {
                    startOffset = endOffset;
                }
            } else {
                startOffset = endOffset;
            }
        }
        if (endOffset < startOffset) {
            endOffset = startOffset;
        }
        if (startOffset > baseSequence.length()) {
            throw new IllegalStateException(String.format("startOffset:%d > baseSeq.length: %d", startOffset, baseSequence.length()));
        }
        if (endOffset > baseSequence.length()) {
            throw new IllegalStateException(String.format("endOffset:%d > baseSeq.length: %d", endOffset, baseSequence.length()));
        }
        return new SegmentTreeRange(startIndex, endIndex, startOffset, endOffset, startSegment.pos, endSegment.pos + 1);
    }

    public int getTextEndOffset(Segment segment, @NotNull BasedSequence baseSequence) {
        Segment nextSegment;
        assert (segment.isText());
        if (segment.pos + 1 < this.size() && (nextSegment = this.getSegment(segment.pos + 1, baseSequence)).isBase()) {
            return nextSegment.getStartOffset();
        }
        return -1;
    }

    public int getTextStartOffset(Segment segment, @NotNull BasedSequence baseSequence) {
        assert (segment.isText());
        Segment prevSegment = this.getPrevAnchor(segment.pos, baseSequence);
        if (prevSegment == null && segment.pos > 0) {
            prevSegment = this.getSegment(segment.pos - 1, baseSequence);
        }
        if (prevSegment != null && prevSegment.isBase()) {
            return prevSegment.getEndOffset();
        }
        return -1;
    }

    public void addSegments(@NotNull IBasedSegmentBuilder<?> builder, @NotNull SegmentTreeRange treeRange) {
        this.addSegments(builder, treeRange.startIndex, treeRange.endIndex, treeRange.startOffset, treeRange.endOffset, treeRange.startPos, treeRange.endPos);
    }

    public void addSegments(@NotNull IBasedSegmentBuilder<?> builder, int startIndex, int endIndex, int startOffset, int endOffset, int startPos, int endPos) {
        if (startOffset != -1) {
            builder.appendAnchor(startOffset);
        }
        int currentEnd = startOffset;
        BasedSequence baseSequence = builder.getBaseSequence();
        for (int i = startPos; i < endPos; ++i) {
            Segment prevAnchor;
            Segment segment = this.getSegment(i, baseSequence);
            if (segment.isText() && (prevAnchor = this.getPrevAnchor(i, baseSequence)) != null) {
                builder.appendAnchor(prevAnchor.getStartOffset());
            }
            CharSequence charSequence = SegmentTree.getCharSequence(segment, startIndex, endIndex, startPos, endPos);
            if (segment.isText()) {
                Segment nextAnchor;
                builder.append(charSequence);
                int byteOffset = segment.byteOffset + segment.getByteLength();
                if (byteOffset >= this.segmentBytes.length || i + 1 < this.size() && byteOffset == this.byteOffset(i + 1) || !(nextAnchor = Segment.getSegment(this.segmentBytes, byteOffset, 0, 0, baseSequence)).isAnchor()) continue;
                builder.appendAnchor(nextAnchor.getStartOffset());
                continue;
            }
            assert (charSequence instanceof BasedSequence);
            BasedSequence basedSequence = (BasedSequence)charSequence;
            currentEnd = Math.max(currentEnd, basedSequence.getEndOffset());
            builder.append(basedSequence.getStartOffset(), basedSequence.getEndOffset());
        }
        if (endOffset != -1) {
            builder.appendAnchor(Math.max(currentEnd, endOffset));
        }
    }

    @NotNull
    public static CharSequence getCharSequence(@NotNull Segment segment, int startIndex, int endIndex, int startPos, int endPos) {
        int pos = segment.pos;
        CharSequence charSequence = pos == startPos && pos + 1 == endPos ? segment.getCharSequence().subSequence(startIndex - segment.getStartIndex(), endIndex - segment.getStartIndex()) : (pos == startPos ? segment.getCharSequence().subSequence(startIndex - segment.getStartIndex(), segment.length()) : (pos + 1 == endPos ? segment.getCharSequence().subSequence(0, endIndex - segment.getStartIndex()) : segment.getCharSequence()));
        return charSequence;
    }

    @Nullable
    public SegmentTreePos findSegmentPos(int index, int startPos, int endPos) {
        return SegmentTree.findSegmentPos(index, this.treeData, startPos, endPos);
    }

    @NotNull
    public Segment getSegment(int pos, @NotNull BasedSequence baseSeq) {
        return Segment.getSegment(this.segmentBytes, this.byteOffset(pos), pos, this.aggrLength(pos - 1), baseSeq);
    }

    @Nullable
    public Segment getPrevAnchor(int pos, @NotNull BasedSequence baseSeq) {
        return SegmentTree.getPrevAnchor(pos, this.treeData, this.segmentBytes, baseSeq);
    }

    @NotNull
    public String toString(@NotNull BasedSequence baseSeq) {
        Segment segment;
        DelimitedBuilder out = new DelimitedBuilder(", ");
        out.append(this.getClass().getSimpleName()).append("{aggr: {");
        int iMax = this.size();
        for (int i = 0; i < iMax; ++i) {
            out.append("[").append(this.aggrLength(i)).append(", ").append(this.byteOffset(i)).append(":");
            if (this.hasPreviousAnchor(i)) {
                out.append(", ").append(this.previousAnchorOffset(i)).append(":");
            }
            out.append("]").mark();
        }
        out.unmark().append(" }, seg: { ");
        for (int offset = 0; offset < this.segmentBytes.length; offset += segment.getByteLength()) {
            segment = Segment.getSegment(this.segmentBytes, offset, 0, 0, baseSeq);
            out.append(offset).append(":").append(segment).mark();
        }
        out.unmark().append(" } }");
        return out.toString();
    }

    @NotNull
    public String toString() {
        return this.toString(BasedSequence.NULL);
    }

    public static int aggrLength(int pos, int[] treeData) {
        return pos < 0 ? 0 : treeData[pos << 1];
    }

    public static int byteOffsetData(int pos, int[] treeData) {
        return treeData[(pos << 1) + 1];
    }

    public static int byteOffset(int pos, int[] treeData) {
        return SegmentTree.getByteOffset(SegmentTree.byteOffsetData(pos, treeData));
    }

    public static void setTreeData(int pos, int[] treeData, int agrrLength, int byteOffset, int prevAnchorOffset) {
        assert (byteOffset <= 0x1FFFFFFF);
        treeData[pos << 1] = agrrLength;
        treeData[(pos << 1) + 1] = byteOffset | (prevAnchorOffset == 0 ? 0 : prevAnchorOffset << 29);
    }

    public static boolean hasPreviousAnchor(int pos, int[] treeData) {
        return SegmentTree.getAnchorOffset(treeData[(pos << 1) + 1]) > 0;
    }

    public static int previousAnchorOffset(int pos, int[] treeData) {
        int byteOffsetData = SegmentTree.byteOffsetData(pos, treeData);
        return SegmentTree.getByteOffset(byteOffsetData) - SegmentTree.getAnchorOffset(byteOffsetData);
    }

    @Nullable
    public static SegmentTreePos findSegmentPos(int index, int[] treeData, int startPos, int endPos) {
        if (index == 0 && startPos == 0) {
            return new SegmentTreePos(0, 0, 0);
        }
        int iterations = 0;
        while (startPos < endPos) {
            int pos = startPos + endPos >> 1;
            int lastStart = startPos;
            int lastEnd = endPos;
            ++iterations;
            int endIndex = SegmentTree.aggrLength(pos, treeData);
            if (index >= endIndex) {
                startPos = pos + 1;
            } else {
                int startIndex = SegmentTree.aggrLength(pos - 1, treeData);
                if (index < startIndex) {
                    endPos = pos;
                } else {
                    return new SegmentTreePos(pos, startIndex, iterations);
                }
            }
            assert (lastStart != startPos || lastEnd != endPos) : "Range and position did not change after iteration: pos=" + pos + ", startPos=" + startPos + ", endPos=" + endPos + "\n" + Arrays.toString(treeData);
        }
        return null;
    }

    @Nullable
    public static Segment findSegment(int index, int[] treeData, int startPos, int endPos, byte[] segmentBytes, @NotNull BasedSequence baseSeq) {
        SegmentTreePos treePos = SegmentTree.findSegmentPos(index, treeData, startPos, endPos);
        if (treePos != null) {
            return Segment.getSegment(segmentBytes, SegmentTree.byteOffset(treePos.pos, treeData), treePos.pos, treePos.startIndex, baseSeq);
        }
        return null;
    }

    @NotNull
    public static Segment getSegment(int pos, int[] treeData, byte[] segmentBytes, @NotNull BasedSequence baseSeq) {
        return Segment.getSegment(segmentBytes, SegmentTree.byteOffset(pos, treeData), pos, SegmentTree.aggrLength(pos, treeData), baseSeq);
    }

    @Nullable
    public static Segment getPrevAnchor(int pos, int[] treeData, byte[] segmentBytes, @NotNull BasedSequence baseSeq) {
        int byteOffsetData = SegmentTree.byteOffsetData(pos, treeData);
        int anchorOffset = SegmentTree.getAnchorOffset(byteOffsetData);
        if (anchorOffset > 0) {
            int byteOffset = SegmentTree.getByteOffset(byteOffsetData) - anchorOffset;
            Segment anchor = Segment.getSegment(segmentBytes, byteOffset, -1, 0, baseSeq);
            assert (anchor.isAnchor());
            return anchor;
        }
        return null;
    }

    @NotNull
    public static SegmentTree build(@NotNull Iterable<Seg> segments, @NotNull CharSequence allText) {
        @NotNull SegmentTreeData segmentTreeData = SegmentTree.buildTreeData(segments, allText, true);
        return new SegmentTree(segmentTreeData.treeData, segmentTreeData.segmentBytes);
    }

    @NotNull
    public static SegmentTree build(@NotNull BasedSegmentBuilder builder) {
        @NotNull SegmentTreeData segmentTreeData = SegmentTree.buildTreeData(builder.getSegments(), builder.getText(), true);
        return new SegmentTree(segmentTreeData.treeData, segmentTreeData.segmentBytes);
    }

    @NotNull
    public static SegmentTreeData buildTreeData(@NotNull Iterable<Seg> segments, @NotNull CharSequence allText, boolean buildIndexData) {
        int byteLength = 0;
        int nonAnchors = 0;
        int lastEndOffset = 0;
        for (Seg seg : segments) {
            Segment.SegType segType = Segment.getSegType(seg, allText);
            byteLength += Segment.getSegByteLength(segType, seg.getSegStart(), seg.length());
            if (buildIndexData ? segType != Segment.SegType.ANCHOR : segType == Segment.SegType.BASE || segType == Segment.SegType.ANCHOR) {
                ++nonAnchors;
            }
            lastEndOffset = seg.getEnd();
        }
        int[] treeData = new int[nonAnchors * 2];
        byte[] segmentBytes = new byte[byteLength];
        int[] startIndices = buildIndexData ? null : new int[nonAnchors];
        int[] posNeedingAdjustment = buildIndexData ? null : new int[2];
        int posNeedingAdjustmentIndex = 0;
        int prevAnchorOffset = -1;
        int pos = 0;
        int offset = 0;
        int aggrLength = 0;
        int segOffset = 0;
        for (Seg seg : segments) {
            segOffset = offset;
            offset = Segment.addSegBytes(segmentBytes, offset, seg, allText);
            Segment.SegType segType = Segment.SegType.fromTypeMask(segmentBytes[segOffset]);
            if (buildIndexData) {
                if (segType == Segment.SegType.ANCHOR) {
                    prevAnchorOffset = segOffset;
                    continue;
                }
                SegmentTree.setTreeData(pos, treeData, aggrLength += seg.length(), segOffset, prevAnchorOffset == -1 ? 0 : segOffset - prevAnchorOffset);
                ++pos;
                prevAnchorOffset = -1;
                continue;
            }
            startIndices[pos] = aggrLength;
            if (posNeedingAdjustmentIndex > 0 && seg.getStart() >= 0) {
                int iMax = posNeedingAdjustmentIndex;
                for (int i = 0; i < iMax; ++i) {
                    treeData[posNeedingAdjustment[i] << 1] = seg.getStart();
                }
                posNeedingAdjustmentIndex = 0;
            }
            aggrLength += seg.length();
            if (segType != Segment.SegType.BASE && segType != Segment.SegType.ANCHOR) continue;
            SegmentTree.setTreeData(pos, treeData, seg.getEnd(), segOffset, 0);
            posNeedingAdjustment[posNeedingAdjustmentIndex++] = pos++;
        }
        if (!buildIndexData) {
            for (int i = 0; i < posNeedingAdjustmentIndex; ++i) {
                treeData[posNeedingAdjustment[i] << 1] = lastEndOffset;
            }
        }
        return new SegmentTreeData(treeData, segmentBytes, startIndices);
    }

    @NotNull
    public SegmentOffsetTree getSegmentOffsetTree(@NotNull BasedSequence baseSeq) {
        int nonAnchors = 0;
        int byteLength = this.segmentBytes.length;
        int segOffset = 0;
        int lastEndOffset = 0;
        while (segOffset < byteLength) {
            Segment seg = Segment.getSegment(this.segmentBytes, segOffset, nonAnchors, 0, baseSeq);
            segOffset += seg.getByteLength();
            if (!seg.isBase()) continue;
            ++nonAnchors;
            lastEndOffset = seg.getEndOffset();
        }
        int[] treeData = new int[nonAnchors * 2];
        int[] startIndices = new int[nonAnchors];
        int pos = 0;
        segOffset = 0;
        int length = 0;
        int[] posNeedingAdjustment = new int[2];
        int posNeedingAdjustmentIndex = 0;
        while (segOffset < byteLength) {
            Segment seg = Segment.getSegment(this.segmentBytes, segOffset, nonAnchors, length, baseSeq);
            if (posNeedingAdjustmentIndex > 0 && seg.getStartOffset() >= 0) {
                int iMax = posNeedingAdjustmentIndex;
                for (int i = 0; i < iMax; ++i) {
                    treeData[posNeedingAdjustment[i] << 1] = seg.getStartOffset();
                }
                posNeedingAdjustmentIndex = 0;
            }
            if (seg.isBase()) {
                SegmentTree.setTreeData(pos, treeData, seg.getEndOffset(), segOffset, 0);
                posNeedingAdjustment[posNeedingAdjustmentIndex++] = pos;
                startIndices[pos] = length;
                ++pos;
            }
            segOffset += seg.getByteLength();
            length += seg.length();
        }
        for (int i = 0; i < posNeedingAdjustmentIndex; ++i) {
            treeData[posNeedingAdjustment[i] << 1] = lastEndOffset;
        }
        return new SegmentOffsetTree(treeData, this.segmentBytes, startIndices);
    }

    protected static class SegmentTreeData {
        @NotNull
        public final int[] treeData;
        @NotNull
        public final byte[] segmentBytes;
        @Nullable
        public final int[] startIndices;

        public SegmentTreeData(@NotNull int[] treeData, @NotNull byte[] segmentBytes, @Nullable int[] startIndices) {
            this.treeData = treeData;
            this.segmentBytes = segmentBytes;
            this.startIndices = startIndices;
        }
    }
}

