/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.model.xml;

import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringBeanResolveConverter;
import com.intellij.spring.model.xml.BeanName;
import com.intellij.spring.model.xml.BeanNameProvider;
import com.intellij.spring.model.xml.BeanType;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.RequiredBeanType;
import com.intellij.spring.security.model.SpringSecurityVersion;
import com.intellij.spring.security.model.converters.SpringSecurityResourceConverter;
import com.intellij.spring.security.model.xml.ModelVersion;
import com.intellij.spring.security.model.xml.SpringSecurityDomElement;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.Referencing;
import com.intellij.util.xml.Required;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@BeanType(value="org.springframework.security.core.session.SessionRegistry")
@BeanName(provider=ConcurrencyControlBeanNameProvider.class)
@ModelVersion(value=SpringSecurityVersion.V_3_1)
public interface ConcurrencyControl
extends DomSpringBean,
SpringSecurityDomElement {
    @NotNull
    public GenericAttributeValue<Integer> getMaxSessions();

    @Referencing(value=SpringSecurityResourceConverter.class, soft=true)
    @NotNull
    public GenericAttributeValue<String> getExpiredUrl();

    @NotNull
    public GenericAttributeValue<Boolean> getErrorIfMaximumExceeded();

    @Required(value=false)
    @NotNull
    public GenericAttributeValue<String> getSessionRegistryAlias();

    @RequiredBeanType(value={"org.springframework.security.core.session.SessionRegistry"})
    @Convert(value=SpringBeanResolveConverter.class)
    @NotNull
    public GenericAttributeValue<SpringBeanPointer<?>> getSessionRegistryRef();

    public static class ConcurrencyControlBeanNameProvider
    implements BeanNameProvider<ConcurrencyControl> {
        @Nullable
        public String getBeanName(ConcurrencyControl control) {
            return control.getSessionRegistryAlias().getRawText();
        }
    }
}

