/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el.contextProviders.extensions;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.el.contextProviders.SpringElContextsExtension;
import com.intellij.spring.el.contextProviders.extensions.SpringCommentLightVariableBuilder;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UastContextKt;

final class SpringELCommentVariablesExtension
extends SpringElContextsExtension {
    public static final String EL_VAR = "@el";
    private static final Pattern VAR_PATTERN = Pattern.compile("(.+)\\s*:\\s*(.*)");

    SpringELCommentVariablesExtension() {
    }

    @Override
    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement contextElement) {
        UDeclaration uDeclaration;
        PsiElement context;
        if (contextElement == null) {
            SpringELCommentVariablesExtension.$$$reportNull$$$0(0);
        }
        SmartList variables = new SmartList();
        PsiFile containingFile = contextElement.getContainingFile();
        if (containingFile != null && (context = containingFile.getContext()) != null && (uDeclaration = (UDeclaration)UastContextKt.getUastParentOfType((PsiElement)context, UDeclaration.class)) != null) {
            while (uDeclaration != null) {
                variables.addAll(SpringELCommentVariablesExtension.getVariableFromComments(uDeclaration));
                uDeclaration = (UDeclaration)UastContextKt.getUastParentOfType((PsiElement)uDeclaration.getJavaPsi(), UDeclaration.class, (boolean)true);
            }
        }
        SmartList smartList = variables;
        if (smartList == null) {
            SpringELCommentVariablesExtension.$$$reportNull$$$0(1);
        }
        return smartList;
    }

    private static Collection<? extends PsiVariable> getVariableFromComments(@NotNull UDeclaration commentOwner) {
        PsiModifierListOwner modifierListOwner;
        PsiModifierList modifierList;
        if (commentOwner == null) {
            SpringELCommentVariablesExtension.$$$reportNull$$$0(2);
        }
        SmartList variables = new SmartList();
        List comments = ContainerUtil.map((Collection)commentOwner.getComments(), uComment -> uComment.getSourcePsi());
        SpringELCommentVariablesExtension.processComments((List<PsiVariable>)variables, comments.toArray(new PsiComment[0]));
        PsiElement psiElement = commentOwner.getJavaPsi();
        if (psiElement instanceof PsiModifierListOwner && (modifierList = (modifierListOwner = (PsiModifierListOwner)psiElement).getModifierList()) != null) {
            SpringELCommentVariablesExtension.processComments((List<PsiVariable>)variables, (PsiComment[])PsiTreeUtil.getChildrenOfType((PsiElement)modifierList, PsiComment.class));
        }
        return variables;
    }

    private static void processComments(@NotNull List<PsiVariable> variables, PsiComment @Nullable [] comments) {
        if (variables == null) {
            SpringELCommentVariablesExtension.$$$reportNull$$$0(3);
        }
        if (comments != null) {
            for (PsiComment comment : comments) {
                SpringELCommentVariablesExtension.processVariableDeclarations(comment.getText(), (vars, start, end) -> variables.addAll(SpringELCommentVariablesExtension.getVariables(comment, vars)));
            }
        }
    }

    public static void processVariableDeclarations(@NotNull String text, @NotNull ElVarsProcessor processor) {
        int end;
        int start;
        if (text == null) {
            SpringELCommentVariablesExtension.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            SpringELCommentVariablesExtension.$$$reportNull$$$0(5);
        }
        int elVarIndex = text.indexOf(EL_VAR);
        while (elVarIndex >= 0 && (start = text.indexOf("(", elVarIndex) + 1) < (end = text.indexOf(")", elVarIndex))) {
            String varsString = text.substring(start, end);
            if (StringUtil.isNotEmpty((String)varsString)) {
                processor.process(varsString, start, end);
            }
            elVarIndex = text.indexOf(EL_VAR, elVarIndex + 1);
        }
    }

    @NotNull
    private static List<PsiVariable> getVariables(@NotNull PsiComment comment, @NotNull String vars) {
        if (comment == null) {
            SpringELCommentVariablesExtension.$$$reportNull$$$0(6);
        }
        if (vars == null) {
            SpringELCommentVariablesExtension.$$$reportNull$$$0(7);
        }
        SmartList variables = new SmartList();
        for (String var : StringUtil.split((String)vars, (String)",")) {
            Matcher varMatcher = VAR_PATTERN.matcher(var.trim());
            if (!varMatcher.matches()) continue;
            String name = varMatcher.group(1).trim();
            String typeName = varMatcher.group(2).trim();
            String fqn = typeName.indexOf(36) >= 0 ? typeName.replace('$', '.') : typeName;
            PsiType type = PsiImplUtil.buildTypeFromTypeString((String)fqn.trim(), (PsiElement)comment, (PsiFile)comment.getContainingFile());
            variables.add(new SpringCommentLightVariableBuilder(name, type, comment));
        }
        SmartList smartList = variables;
        if (smartList == null) {
            SpringELCommentVariablesExtension.$$$reportNull$$$0(8);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/el/contextProviders/extensions/SpringELCommentVariablesExtension";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentOwner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/el/contextProviders/extensions/SpringELCommentVariablesExtension";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextVariables";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextVariables";
                break;
            }
            case 1: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVariableFromComments";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processComments";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processVariableDeclarations";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVariables";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 8 -> new IllegalStateException(string);
        };
    }

    public static interface ElVarsProcessor {
        public void process(@NotNull String var1, int var2, int var3);
    }
}

