/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.model;

import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.model.AliasedDependencyObject;
import com.intellij.kubernetes.helm.model.ChartPomTarget;
import com.intellij.kubernetes.helm.model.DirectDependencyObject;
import com.intellij.kubernetes.helm.model.HelmResolveUtilKt;
import com.intellij.kubernetes.helm.model.HelmYamlObject;
import com.intellij.kubernetes.helm.model.PathInChart;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLKeyValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B'\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0010\u001a\u00020\u0011H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u0082\u0001\u0002\u0017\u0018\u00a8\u0006\u0019"}, d2={"Lcom/intellij/kubernetes/helm/model/DependencyObject;", "Lcom/intellij/kubernetes/helm/model/HelmYamlObject;", "hostChart", "Lcom/intellij/kubernetes/helm/chart/Chart;", "dependency", "Lcom/intellij/kubernetes/helm/chart/Chart$Dependency;", "definitionElements", "", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/kubernetes/helm/chart/Chart;Lcom/intellij/kubernetes/helm/chart/Chart$Dependency;Ljava/util/Collection;)V", "getDependency", "()Lcom/intellij/kubernetes/helm/chart/Chart$Dependency;", "declarationElements", "getDeclarationElements", "()Ljava/util/Collection;", "createPomTarget", "Lcom/intellij/pom/PomTarget;", "description", "", "getDescription", "()Ljava/lang/String;", "Companion", "Lcom/intellij/kubernetes/helm/model/AliasedDependencyObject;", "Lcom/intellij/kubernetes/helm/model/DirectDependencyObject;", "intellij.clouds.kubernetes.backend"})
public abstract sealed class DependencyObject
extends HelmYamlObject
permits AliasedDependencyObject, DirectDependencyObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Chart.Dependency dependency;

    private DependencyObject(Chart hostChart, Chart.Dependency dependency, Collection<? extends PsiElement> definitionElements) {
        super(dependency.getEffectiveName(), definitionElements, new PathInChart(HelmResolveUtilKt.getObjectPath(dependency), hostChart), false, null, true);
        this.dependency = dependency;
    }

    @NotNull
    protected final Chart.Dependency getDependency() {
        return this.dependency;
    }

    @Override
    @NotNull
    public Collection<PsiElement> getDeclarationElements() {
        return CollectionsKt.listOf((Object)PomService.convertToPsi((Project)this.getPathInChart().getChart().getProject(), (PomTarget)this.createPomTarget()));
    }

    @Override
    @NotNull
    protected PomTarget createPomTarget() {
        return (PomTarget)new ChartPomTarget(this.dependency.getName(), this.getPathInChart(), this.dependency.getChart());
    }

    @Override
    @NotNull
    public String getDescription() {
        return "A section for overriding/defining values used in dependency \"" + this.getName() + "\"";
    }

    public /* synthetic */ DependencyObject(Chart hostChart, Chart.Dependency dependency, Collection definitionElements, DefaultConstructorMarker $constructor_marker) {
        this(hostChart, dependency, definitionElements);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a8\u0006\r"}, d2={"Lcom/intellij/kubernetes/helm/model/DependencyObject$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/kubernetes/helm/model/DependencyObject;", "chart", "Lcom/intellij/kubernetes/helm/chart/Chart;", "dependencyName", "", "keyVals", "", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "intellij.clouds.kubernetes.backend"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final DependencyObject create(@NotNull Chart chart, @NotNull String dependencyName, @NotNull Collection<? extends YAMLKeyValue> keyVals) {
            Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
            Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
            Intrinsics.checkNotNullParameter(keyVals, (String)"keyVals");
            Chart.Dependency dependency = chart.getDependencies().get(dependencyName);
            if (dependency == null) {
                return null;
            }
            Chart.Dependency dependency2 = dependency;
            return dependency2.getAlias() != null && !Intrinsics.areEqual((Object)dependency2.getAlias(), (Object)dependency2.getName()) ? (DependencyObject)new AliasedDependencyObject(chart, dependency2, keyVals) : (DependencyObject)new DirectDependencyObject(chart, dependency2, keyVals);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

