/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.fullLine.controlModel;

import com.intellij.fullLine.controlModel.MLApiControlModel;
import com.intellij.fullLine.controlModel.NanAndEmptyStringCleaner;
import com.intellij.ml.inline.completion.impl.control.ControlModel;
import com.intellij.ml.inline.completion.impl.control.ControlModelLoadingState;
import com.intellij.ml.inline.completion.impl.control.ControlModelService;
import com.intellij.ml.inline.completion.impl.control.ControlModelTag;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.mlapi.bundle.ModelPipelineLoader;
import com.jetbrains.mlapi.model.pipeline.ModelPipeline;
import com.jetbrains.mlapi.model.prediction.ClassesProbabilities;
import java.io.Closeable;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u0019*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0019BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u00000\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/fullLine/controlModel/MLApiControlModelService;", "I", "Lcom/intellij/ml/inline/completion/impl/control/ControlModelService;", "modelId", "", "modelStream", "Lkotlin/Function0;", "Ljava/io/InputStream;", "modelTag", "Lcom/intellij/ml/inline/completion/impl/control/ControlModelTag;", "useDefaultNanCleaner", "", "infoExtractor", "Lkotlin/Function1;", "Lcom/intellij/fullLine/controlModel/MLApiControlModel;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lcom/intellij/ml/inline/completion/impl/control/ControlModelTag;ZLkotlin/jvm/functions/Function1;)V", "_loadingState", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/ml/inline/completion/impl/control/ControlModelLoadingState;", "loadingState", "getLoadingState", "()Lcom/intellij/ml/inline/completion/impl/control/ControlModelLoadingState;", "scheduleLoading", "", "Companion", "intellij.fullLine.controlModel"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMLApiControlModelService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLApiControlModelService.kt\ncom/intellij/fullLine/controlModel/MLApiControlModelService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,75:1\n23#2:76\n*S KotlinDebug\n*F\n+ 1 MLApiControlModelService.kt\ncom/intellij/fullLine/controlModel/MLApiControlModelService\n*L\n72#1:76\n*E\n"})
public class MLApiControlModelService<I>
implements ControlModelService<I> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String modelId;
    @NotNull
    private final Function0<InputStream> modelStream;
    @Nullable
    private final ControlModelTag modelTag;
    private final boolean useDefaultNanCleaner;
    @NotNull
    private final Function1<MLApiControlModel, I> infoExtractor;
    @NotNull
    private AtomicReference<ControlModelLoadingState<I>> _loadingState;
    @NotNull
    private static final Logger LOG;

    public MLApiControlModelService(@NotNull String modelId, @NotNull Function0<? extends InputStream> modelStream, @Nullable ControlModelTag modelTag, boolean useDefaultNanCleaner, @NotNull Function1<? super MLApiControlModel, ? extends I> infoExtractor) {
        Intrinsics.checkNotNullParameter((Object)modelId, (String)"modelId");
        Intrinsics.checkNotNullParameter(modelStream, (String)"modelStream");
        Intrinsics.checkNotNullParameter(infoExtractor, (String)"infoExtractor");
        this.modelId = modelId;
        this.modelStream = modelStream;
        this.modelTag = modelTag;
        this.useDefaultNanCleaner = useDefaultNanCleaner;
        this.infoExtractor = infoExtractor;
        this._loadingState = new AtomicReference<Object>(null);
    }

    public /* synthetic */ MLApiControlModelService(String string, Function0 function0, ControlModelTag controlModelTag, boolean bl, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            controlModelTag = null;
        }
        this(string, (Function0<? extends InputStream>)function0, controlModelTag, bl, function1);
    }

    @NotNull
    public ControlModelLoadingState<I> getLoadingState() {
        ControlModelLoadingState controlModelLoadingState;
        if (this._loadingState.compareAndSet((ControlModelLoadingState<I>)null, (ControlModelLoadingState<I>)new ControlModelLoadingState.Loading())) {
            this.scheduleLoading();
        }
        if ((controlModelLoadingState = this._loadingState.get()) == null) {
            controlModelLoadingState = (ControlModelLoadingState)new ControlModelLoadingState.Error((Throwable)new IllegalStateException("Loading state is not set"));
        }
        return controlModelLoadingState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void scheduleLoading() {
        Closeable closeable = (Closeable)this.modelStream.invoke();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            ModelPipelineLoader modelPipelineLoader = ModelPipelineLoader.Companion.getDEFAULT();
            ExecutorService executorService = AppExecutorUtil.getAppExecutorService();
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"getAppExecutorService(...)");
            CompletionStage completionStage = ((CompletableFuture)modelPipelineLoader.load(it, executorService).thenAccept(arg_0 -> MLApiControlModelService.scheduleLoading$lambda$0$1(arg_0 -> MLApiControlModelService.scheduleLoading$lambda$0$0(this, arg_0), arg_0))).exceptionally(arg_0 -> MLApiControlModelService.scheduleLoading$lambda$0$2(this, arg_0));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final Unit scheduleLoading$lambda$0$0(MLApiControlModelService this$0, ModelPipeline loadedPipeline) {
        ModelPipeline pipeline = this$0.useDefaultNanCleaner ? new ModelPipeline(NanAndEmptyStringCleaner.INSTANCE, loadedPipeline.getBaseModel(), loadedPipeline.getInfo()) : loadedPipeline;
        MLApiControlModel controlModel = new MLApiControlModel((ModelPipeline<ClassesProbabilities>)pipeline.predictingClasses(), this$0.modelId, this$0.modelTag);
        this$0._loadingState.set((ControlModelLoadingState)new ControlModelLoadingState.Loaded((ControlModel)controlModel, this$0.infoExtractor.invoke((Object)controlModel)));
        return Unit.INSTANCE;
    }

    private static final void scheduleLoading$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Void scheduleLoading$lambda$0$2(MLApiControlModelService this$0, Throwable e) {
        AtomicReference atomicReference = this$0._loadingState;
        Intrinsics.checkNotNull((Object)e);
        atomicReference.set((ControlModelLoadingState)new ControlModelLoadingState.Error(e));
        LOG.error("Failed to load the ML API model '" + this$0.modelId + "'", e);
        return null;
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/fullLine/controlModel/MLApiControlModelService$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.fullLine.controlModel"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

