/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.model.xml.converters;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.WebModel;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.model.xml.FilterMapping;
import com.intellij.javaee.web.model.xml.WebApp;
import com.intellij.javaee.web.model.xml.WebAppVersion;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServletNameConverter
extends ResolvingConverter<CommonServlet> {
    @NotNull
    public Collection<? extends CommonServlet> getVariants(@NotNull ConvertContext context) {
        WebModel webModel;
        if (context == null) {
            ServletNameConverter.$$$reportNull$$$0(0);
        }
        List<Object> list = (webModel = ServletNameConverter.getModel(context)) == null ? Collections.emptyList() : webModel.getServlets();
        if (list == null) {
            ServletNameConverter.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    static WebModel getModel(ConvertContext context) {
        XmlFile file = context.getFile();
        WebFacet facet = WebUtil.getWebFacet((PsiElement)file);
        if (facet != null && !facet.getWebApps().isEmpty()) {
            return facet.getWebModel();
        }
        return WebUtil.getWebUtil().getLocalWebModel(file);
    }

    @NotNull
    public Set<String> getAdditionalVariants(@NotNull ConvertContext context) {
        if (context == null) {
            ServletNameConverter.$$$reportNull$$$0(2);
        }
        if (context.getInvocationElement().getParent() instanceof FilterMapping) {
            WebApp webApp = (WebApp)context.getInvocationElement().getParentOfType(WebApp.class, false);
            assert (webApp != null);
            WebAppVersion version = (WebAppVersion)((Object)webApp.getVersion().getValue());
            if (version != null && WebAppVersion.WebAppVersion_2_5.compareTo(version) <= 0) {
                Set<String> set = Collections.singleton("*");
                if (set == null) {
                    ServletNameConverter.$$$reportNull$$$0(3);
                }
                return set;
            }
        } else {
            Set<String> set = Collections.singleton("default");
            if (set == null) {
                ServletNameConverter.$$$reportNull$$$0(4);
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            ServletNameConverter.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Nullable
    public CommonServlet fromString(@Nullable @NonNls String s, @NotNull ConvertContext context) {
        if (context == null) {
            ServletNameConverter.$$$reportNull$$$0(6);
        }
        if (s == null) {
            return null;
        }
        WebModel webModel = ServletNameConverter.getModel(context);
        return webModel != null ? webModel.findServlet(s) : null;
    }

    @Nullable
    public String toString(@Nullable CommonServlet servlet, @NotNull ConvertContext context) {
        if (context == null) {
            ServletNameConverter.$$$reportNull$$$0(7);
        }
        return servlet != null ? servlet.getServletName().getStringValue() : null;
    }

    public String getErrorMessage(@Nullable String s, @NotNull ConvertContext context) {
        if (context == null) {
            ServletNameConverter.$$$reportNull$$$0(8);
        }
        return CodeInsightBundle.message((String)"error.cannot.resolve.0.1", (Object[])new Object[]{"Servlet", s});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/web/model/xml/converters/ServletNameConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/web/model/xml/converters/ServletNameConverter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalVariants";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

