/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.ed.annotation.attr;

import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.AbstractDynamicAttributeAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaAttributeAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaEnum;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.AnnotationModel;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.AnnotationModelBuilder;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.ArrayParameter;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.ReferenceParameter;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.StringParameter;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCardinalityAnnotation
extends AbstractDynamicAttributeAnnotation {
    public AbstractCardinalityAnnotation(@NotNull JpaAttributeAnnotation descriptor) {
        if (descriptor == null) {
            AbstractCardinalityAnnotation.$$$reportNull$$$0(0);
        }
        super(descriptor);
    }

    public static boolean insertCondition(EntityAttribute attribute) {
        return attribute.getCardinality() != null && !attribute.isTransient();
    }

    @Override
    public AnnotationModel generateModel(EntityAttribute attr, Entity entity, Project project) {
        List attrCascadeTypes;
        Module module = entity.getModule();
        AnnotationModelBuilder builder = new AnnotationModelBuilder(this.getFqn(project, module));
        EntityAttribute.Cardinality cardinality = attr.getCardinality();
        EntityAttribute.FetchType fetchType = attr.getFetchType();
        if (fetchType != null && fetchType != EntityAttribute.FetchType.getDefault(cardinality)) {
            builder.add("fetch", new ReferenceParameter(JpaEnum.FetchType.getEnumEntryFqn(project, module, fetchType.name())));
        }
        if (StringUtil.isNotEmpty((String)attr.getMappedBy())) {
            builder.add("mappedBy", new StringParameter(attr.getMappedBy()));
        }
        if (!(attrCascadeTypes = attr.getCascadeTypes().stream().distinct().collect(Collectors.toList())).isEmpty()) {
            if (attrCascadeTypes.size() > 4 || attrCascadeTypes.contains((Object)EntityAttribute.CascadeType.ALL)) {
                ReferenceParameter parameter = new ReferenceParameter(JpaEnum.CascadeType.getEnumEntryFqn(project, module, EntityAttribute.CascadeType.ALL.name()));
                builder.add("cascade", new ArrayParameter<ReferenceParameter>(Collections.singletonList(parameter)));
            } else {
                List cascadeTypes = StreamEx.of(attrCascadeTypes).map(type -> new ReferenceParameter(JpaEnum.CascadeType.getEnumEntryFqn(project, module, type.name()))).toList();
                builder.add("cascade", new ArrayParameter(cascadeTypes));
            }
        }
        return builder.build();
    }

    @Override
    public List<String> knownAttributes(EntityAttribute attribute) {
        return Arrays.asList("fetch", "mappedBy", "optional", "orphanRemoval", "cascade", "targetEntity");
    }

    public static List<String> getCardinalityFqns(Project project, Module module) {
        return StreamEx.of((Object[])EntityAttribute.Cardinality.values()).map(it -> it.getFqn(project, module)).toList();
    }

    protected abstract EntityAttribute.Cardinality getCardinality();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/jpa/jpb/model/backend/ed/annotation/attr/AbstractCardinalityAnnotation", "<init>"));
    }
}

