/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.model;

import com.intellij.jpa.jpb.model.model.DataModelItem;
import com.intellij.jpa.jpb.model.model.Datatype;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;

public abstract class EnumType
implements DataModelItem {
    public abstract List<Value> getValues();

    public Value getValue(String name) {
        for (Value value : this.getValues()) {
            if (!name.equals(value.getName())) continue;
            return value;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Enum)) {
            return false;
        }
        EnumType anEnum = (EnumType)o;
        return Objects.equals(this.getFqn(), anEnum.getFqn());
    }

    public int hashCode() {
        return Objects.hash(this.getFqn());
    }

    public String toString() {
        return this.getFqn();
    }

    @Override
    public int compareTo(Datatype o) {
        return ObjectUtils.compare((Comparable)((Object)this.getFqn()), (Comparable)((Object)o.getFqn()));
    }

    public boolean isValid() {
        return true;
    }

    public static class Value {
        public static final String NAME = "name";
        public static final String VALUE = "value";
        private String name;
        private String value;

        public Value() {
        }

        public Value(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Value value1 = (Value)o;
            if (!Objects.equals(this.name, value1.name)) {
                return false;
            }
            return Objects.equals(this.value, value1.value);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }
}

