/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.repository;

import com.google.common.base.Preconditions;
import com.intellij.jpa.jpb.model.repository.PropertyReferenceException;
import com.intellij.jpa.jpb.model.util.AttributeUtil;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.PropertyUtilBase;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyPath {
    private static final String PARSE_DEPTH_EXCEEDED = "Trying to parse a path with depth greater than 1000! This has been disabled for security reasons to prevent parsing overflows.";
    private static final String DELIMITERS = "_\\.";
    private static final Pattern SPLITTER = Pattern.compile("(?:[%s]?([%s]*?[^%s]+))".replaceAll("%s", "_\\."));
    private final String name;
    private final PsiClass propertyType;
    private final boolean isCollection;
    @Nullable
    private PropertyPath next;

    PropertyPath(String name, PsiClass owningType, List<PropertyPath> base) {
        Preconditions.checkArgument((!StringUtil.isEmptyOrSpaces((String)name) ? 1 : 0) != 0, (Object)"Name must not be null or empty!");
        Preconditions.checkNotNull((Object)owningType, (Object)"Owning type must not be null!");
        Preconditions.checkNotNull(base, (Object)"Previously found properties must not be null!");
        String propertyName = Introspector.decapitalize(name);
        PsiField foundMember = owningType.findFieldByName(name, true);
        if (foundMember == null) {
            foundMember = PropertyUtilBase.findPropertyGetter((PsiClass)owningType, (String)propertyName, (boolean)false, (boolean)true);
        }
        if (foundMember == null) {
            throw new PropertyReferenceException("Property '" + name + "' not found in '" + owningType.getQualifiedName() + "' class");
        }
        this.propertyType = AttributeUtil.getReferencedClass((PsiMember)foundMember);
        this.isCollection = this.propertyType != null ? EntityUtil.getCollectionType((PsiMember)foundMember) != null : false;
        this.name = propertyName;
    }

    public static PropertyPath fromSafely(String source2, @NotNull PsiClass type) {
        if (type == null) {
            PropertyPath.$$$reportNull$$$0(0);
        }
        try {
            return PropertyPath.from(source2, type);
        }
        catch (Exception e) {
            return new PropertyPath(source2, type, Collections.emptyList());
        }
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public static PropertyPath from(String source2, PsiClass type) {
        ArrayList<String> iteratorSource = new ArrayList<String>();
        Matcher matcher = SPLITTER.matcher("_" + source2);
        while (matcher.find()) {
            iteratorSource.add(matcher.group(1));
        }
        Iterator parts = iteratorSource.iterator();
        PropertyPath result = null;
        ArrayList<PropertyPath> current = new ArrayList<PropertyPath>();
        while (parts.hasNext()) {
            if (result == null) {
                result = PropertyPath.create((String)parts.next(), type, current);
                current.add(result);
                continue;
            }
            current.add(PropertyPath.create((String)parts.next(), current));
        }
        if (result == null) {
            throw new IllegalStateException(String.format("Expected parsing to yield a PropertyPath from %s but got null!", source2));
        }
        return result;
    }

    private static PropertyPath create(String source2, List<PropertyPath> base) {
        PropertyPath propertyPath;
        PropertyPath previous = base.get(base.size() - 1);
        previous.next = propertyPath = PropertyPath.create(source2, previous.propertyType, base);
        return propertyPath;
    }

    private static PropertyPath create(String source2, PsiClass owningType, List<PropertyPath> base) {
        return PropertyPath.create(source2, owningType, "", base);
    }

    private static PropertyPath create(String source2, PsiClass owningType, String addTail, List<PropertyPath> base) {
        if (base.size() > 1000) {
            throw new IllegalArgumentException(PARSE_DEPTH_EXCEEDED);
        }
        PropertyPath current = null;
        try {
            current = new PropertyPath(source2, owningType, base);
            if (!base.isEmpty()) {
                base.get((int)(base.size() - 1)).next = current;
            }
            ArrayList<PropertyPath> newBase = new ArrayList<PropertyPath>(base);
            newBase.add(current);
            if (!StringUtil.isEmptyOrSpaces((String)addTail)) {
                current.next = PropertyPath.create(addTail, current.propertyType, newBase);
            }
            return current;
        }
        catch (PropertyReferenceException e) {
            if (current != null) {
                throw e;
            }
            PropertyReferenceException exception = e;
            Pattern pattern = Pattern.compile("\\p{Lu}\\p{Ll}*$");
            Matcher matcher = pattern.matcher(source2);
            if (matcher.find() && matcher.start() != 0) {
                int position = matcher.start();
                String head = source2.substring(0, position);
                String tail = source2.substring(position);
                return PropertyPath.create(head, owningType, tail + addTail, base);
            }
            throw exception;
        }
    }

    public String toDotPath() {
        if (this.next != null) {
            return this.name + "." + this.next.toDotPath();
        }
        return this.name;
    }

    @Nullable
    public PropertyPath getNext() {
        return this.next;
    }

    public String getName() {
        return this.name;
    }

    public PsiClass getPropertyType() {
        return this.propertyType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/jpa/jpb/model/repository/PropertyPath", "fromSafely"));
    }
}

