/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.relations.dump;

import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.providers.RMLMutableInstancesProvider;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.RelationSignature;
import com.intellij.rml.dfa.impl.relations.dump.RelationDump;
import com.intellij.rml.dfa.impl.relations.dump.RelationHandle;
import com.intellij.rml.dfa.impl.repositories.MutableRelationsRepository;
import com.intellij.rml.dfa.impl.symtable.MutableSymbolTable;
import com.intellij.rml.dfa.impl.ui.Messages;
import com.intellij.rml.dfa.impl.ui.ThreadCallback;
import com.intellij.rml.dfa.impl.ui.UICallback;
import com.intellij.rml.dfa.utils.Cancellation;
import com.intellij.util.ArrayUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class RelationsTextDump {
    private static final String SIGNATURE_KEYWORD = "$signature";
    private static final String TUPLE_KEYWORD = "$tuple";
    private final RMLMutableInstancesProvider managerInstancesProvider;
    private final UICallback uiCallback;
    private final String dumpPath;
    private Map<String, RelationSignature> signatures;

    public RelationsTextDump(String dumpPath, RMLMutableInstancesProvider provider) {
        this.dumpPath = dumpPath;
        this.managerInstancesProvider = provider;
        this.uiCallback = provider.getUICallback();
    }

    public RelationSignature[] getSignatures() {
        return this.signatures.values().toArray(RelationSignature.EMPTY_ARRAY);
    }

    public void writeDump(String[] relations, ThreadCallback threadCallback) throws Exception {
        FileOutputStream fos = new FileOutputStream(this.dumpPath);
        PrintStream out = new PrintStream(new BufferedOutputStream(fos));
        for (int i = 0; i < relations.length; ++i) {
            Attribute[][] tuples;
            threadCallback.informProgress(i, relations.length, Messages.getString(RelationsTextDump.class.getName() + "-0") + relations[i]);
            threadCallback.checkCancelled();
            IRelation relation = this.managerInstancesProvider.getRelationsRepository().getRelation(relations[i]);
            out.print("$signature " + relations[i] + ":");
            for (int j = 0; j < relation.getDomains().length; ++j) {
                out.print("\r\n" + relation.getDomainType(j).getName());
            }
            out.println();
            for (Attribute[] tuple : tuples = relation.getAttributes(this.managerInstancesProvider.getSymbolTable())) {
                out.print("$tuple " + relations[i] + ":");
                for (Attribute attr : tuple) {
                    out.print("\r\n" + String.valueOf(attr));
                }
                out.println();
            }
        }
        out.close();
        fos.close();
    }

    public void readDomainsFromDump(Cancellation cancellation, final MutableSymbolTable symbolTable) {
        this.signatures = new HashMap<String, RelationSignature>();
        this.passFile(new LineProcessor(){

            @Override
            public void processLine(String keyWord, String name, String[] tokens) {
                if (tokens.length == 0) {
                    RelationsTextDump.this.uiCallback.showError(Messages.getString(RelationsTextDump.class.getName() + "-1") + RelationsTextDump.this.dumpPath + "\"", true);
                    return;
                }
                if (keyWord.equals(RelationsTextDump.SIGNATURE_KEYWORD)) {
                    DomainType[] types = new DomainType[tokens.length];
                    for (int i = 0; i < types.length; ++i) {
                        types[i] = symbolTable.getDomainType(tokens[i]);
                        if (types[i] != null) continue;
                        RelationsTextDump.this.uiCallback.showError(Messages.getString(RelationsTextDump.class.getName() + "-2") + tokens[i] + Messages.getString(RelationsTextDump.class.getName() + "-3") + RelationsTextDump.this.dumpPath + "\"", true);
                        return;
                    }
                    RelationsTextDump.this.signatures.put(name, new RelationSignature(name, types));
                } else if (keyWord.equals(RelationsTextDump.TUPLE_KEYWORD)) {
                    RelationSignature signature = RelationsTextDump.this.signatures.get(name);
                    if (signature == null) {
                        RelationsTextDump.this.uiCallback.showError(Messages.getString(RelationsTextDump.class.getName() + "-4") + name + Messages.getString(RelationsTextDump.class.getName() + "-5") + RelationsTextDump.this.dumpPath + "\"", true);
                        return;
                    }
                    if (signature.getTypes().length != tokens.length) {
                        RelationsTextDump.this.uiCallback.showError(Messages.getString(RelationsTextDump.class.getName() + "-6") + name + Messages.getString(RelationsTextDump.class.getName() + "-7") + RelationsTextDump.this.dumpPath + "\"", true);
                        return;
                    }
                    for (int i = 0; i < signature.getTypes().length; ++i) {
                        symbolTable.addAttribute(new Attribute(tokens[i]), signature.getType(i), "From text dump", "");
                    }
                }
            }
        }, cancellation);
    }

    public void readRelationsFromDump(MutableRelationsRepository relationsRepository, Cancellation cancellation) {
        RelationDump dump = new RelationDump(this.managerInstancesProvider);
        final HashMap<String, RelationHandle> handles = new HashMap<String, RelationHandle>();
        for (String name : this.signatures.keySet()) {
            handles.put(name, dump.addRelation(this.signatures.get(name)));
        }
        this.passFile(new LineProcessor(){

            @Override
            public void processLine(String keyWord, String name, String[] tokens) {
                if (keyWord.equals(RelationsTextDump.TUPLE_KEYWORD)) {
                    RelationHandle handle = (RelationHandle)handles.get(name);
                    handle.addTuple(tokens);
                }
            }
        }, cancellation);
        dump.copyToRepository(relationsRepository);
    }

    private void passFile(LineProcessor lineProcessor, Cancellation cancellation) {
        try {
            String[] keywords = new String[]{SIGNATURE_KEYWORD, TUPLE_KEYWORD};
            BufferedReader in = new BufferedReader(new FileReader(this.dumpPath));
            ArrayList<String> tuple = null;
            String keyWord = null;
            String name = null;
            while (true) {
                int i;
                cancellation.checkCancelled();
                String line = in.readLine();
                if (line == null) break;
                if ((line = line.trim()).startsWith("#")) continue;
                for (i = 0; i < keywords.length; ++i) {
                    if (!line.startsWith(keywords[i])) continue;
                    if (keyWord != null) {
                        lineProcessor.processLine(keyWord, name, ArrayUtil.toStringArray((Collection)tuple));
                    }
                    keyWord = keywords[i];
                    name = line.substring(keywords[i].length() + 1, line.length() - 1);
                    tuple = new ArrayList<String>();
                    break;
                }
                if (i != keywords.length) continue;
                tuple.add(line);
            }
            if (keyWord != null) {
                lineProcessor.processLine(keyWord, name, ArrayUtil.toStringArray(tuple));
            }
            in.close();
        }
        catch (IOException e) {
            this.uiCallback.showError(Messages.getString(RelationsTextDump.class.getName() + "-8") + this.dumpPath + "\"", e, true);
        }
    }

    private static interface LineProcessor {
        public void processLine(String var1, String var2, String[] var3);
    }
}

