/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.scripts;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.relations.RelationSignature;
import com.intellij.rml.dfa.impl.repositories.HypoteticRelationsRepository;
import com.intellij.rml.dfa.impl.ui.Messages;
import java.util.Set;

public class GenericDomainTypeUnifier {
    private final HypoteticRelationsRepository holder;

    public GenericDomainTypeUnifier(HypoteticRelationsRepository holder) {
        this.holder = holder;
    }

    public String unifySignatures(Set<RelationSignature> signatures, String scriptName) {
        for (RelationSignature signature : signatures) {
            DomainType[] trueTypes;
            String genericRelation = signature.getName();
            if (this.holder.containsRelation(genericRelation)) {
                trueTypes = this.holder.getDomainTypes(genericRelation);
            } else if (this.holder.getParent().containsRelation(genericRelation)) {
                trueTypes = this.holder.getParent().getDomainTypes(genericRelation);
            } else {
                return genericRelation;
            }
            if (trueTypes.length != signature.getTypes().length) {
                throw new DfaInternalException(Messages.getString(GenericDomainTypeUnifier.class.getName() + "-0") + genericRelation + Messages.getString(GenericDomainTypeUnifier.class.getName() + "-1") + scriptName + Messages.getString(GenericDomainTypeUnifier.class.getName() + "-2"));
            }
            for (int j = 0; j < trueTypes.length; ++j) {
                DomainType type = signature.getType(j);
                if (type.equals(trueTypes[j])) continue;
                throw new DfaInternalException(Messages.getString(GenericDomainTypeUnifier.class.getName() + "-6") + genericRelation + Messages.getString(GenericDomainTypeUnifier.class.getName() + "-7") + scriptName + Messages.getString(GenericDomainTypeUnifier.class.getName() + "-8"));
            }
        }
        return null;
    }
}

