/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.transform;

import com.intellij.rml.dfa.impl.ir.cfg.IrCFGBlockImpl;
import com.intellij.rml.dfa.impl.transform.IrTransformStage;
import com.intellij.rml.dfa.ir.ast.IrComparisonCondition;
import com.intellij.rml.dfa.ir.ast.IrCondition;
import com.intellij.rml.dfa.ir.ast.IrFunctionDecl;
import com.intellij.rml.dfa.ir.ast.IrRequirementStmt;
import com.intellij.rml.dfa.ir.ast.IrStatement;
import com.intellij.rml.dfa.ir.ast.IrTopLevelDecl;
import com.intellij.rml.dfa.ir.cfg.IrCFGBlock;
import com.intellij.rml.dfa.ir.cfg.IrConditionalJump;
import com.intellij.rml.dfa.ir.cfg.IrJump;
import com.intellij.rml.dfa.utils.RMLOptions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/rml/dfa/impl/transform/AddBranchRequirementsStage;", "Lcom/intellij/rml/dfa/impl/transform/IrTransformStage;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "transform", "Lcom/intellij/rml/dfa/ir/ast/IrTopLevelDecl;", "decl", "options", "Lcom/intellij/rml/dfa/utils/RMLOptions;", "intellij.rml.dfa.impl"})
public final class AddBranchRequirementsStage
implements IrTransformStage {
    @NotNull
    private final String name;

    public AddBranchRequirementsStage() {
        this.name = "Add branch requirements";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public IrTopLevelDecl transform(@NotNull IrTopLevelDecl decl, @NotNull RMLOptions options) {
        Intrinsics.checkNotNullParameter((Object)decl, (String)"decl");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (decl instanceof IrFunctionDecl) {
            for (IrJump jump : ((IrFunctionDecl)decl).getBody().getJumps().values()) {
                IrCondition condition;
                if (!(jump instanceof IrConditionalJump) || !((condition = ((IrConditionalJump)jump).getCondition()) instanceof IrComparisonCondition)) continue;
                IrComparisonCondition trueBranchCondition = new IrComparisonCondition(((IrComparisonCondition)condition).getLeft(), ((IrComparisonCondition)condition).getRight(), ((IrComparisonCondition)condition).getKind(), ((IrComparisonCondition)condition).getLocation());
                IrComparisonCondition falseBranchCondition = new IrComparisonCondition(((IrComparisonCondition)condition).getLeft(), ((IrComparisonCondition)condition).getRight(), ((IrComparisonCondition)condition).getKind().invert(), ((IrComparisonCondition)condition).getLocation());
                IrCFGBlock irCFGBlock = ((IrConditionalJump)jump).getTrueBranch();
                Intrinsics.checkNotNull((Object)irCFGBlock, (String)"null cannot be cast to non-null type com.intellij.rml.dfa.impl.ir.cfg.IrCFGBlockImpl");
                ((IrCFGBlockImpl)irCFGBlock).getInstructions().add(0, (IrStatement)new IrRequirementStmt((IrCondition)trueBranchCondition, ((IrComparisonCondition)condition).getLocation()));
                IrCFGBlock irCFGBlock2 = ((IrConditionalJump)jump).getFalseBranch();
                Intrinsics.checkNotNull((Object)irCFGBlock2, (String)"null cannot be cast to non-null type com.intellij.rml.dfa.impl.ir.cfg.IrCFGBlockImpl");
                ((IrCFGBlockImpl)irCFGBlock2).getInstructions().add(0, (IrStatement)new IrRequirementStmt((IrCondition)falseBranchCondition, ((IrComparisonCondition)condition).getLocation()));
            }
        }
        return decl;
    }
}

