/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDataSourceConfigurable<M extends DataSourceManager<T>, T extends RawDataSource>
extends AbstractDatabaseConfigurable<T> {
    protected final M myManager;
    protected final T myDataSource;

    public AbstractDataSourceConfigurable(@NotNull M manager, @NotNull T dataSource, @NotNull Project project) {
        if (manager == null) {
            AbstractDataSourceConfigurable.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            AbstractDataSourceConfigurable.$$$reportNull$$$0(1);
        }
        if (project == null) {
            AbstractDataSourceConfigurable.$$$reportNull$$$0(2);
        }
        super(project, dataSource);
        this.myManager = manager;
        this.myDataSource = dataSource;
    }

    @NotNull
    public T getDataSource() {
        T t = this.myDataSource;
        if (t == null) {
            AbstractDataSourceConfigurable.$$$reportNull$$$0(3);
        }
        return t;
    }

    @NotNull
    public M getManager() {
        M m = this.myManager;
        if (m == null) {
            AbstractDataSourceConfigurable.$$$reportNull$$$0(4);
        }
        return m;
    }

    @NotNull
    public T getTempTarget() {
        T t = this.getTempDataSource();
        if (t == null) {
            AbstractDataSourceConfigurable.$$$reportNull$$$0(5);
        }
        return t;
    }

    public boolean isTempTarget(@Nullable Object target) {
        return target instanceof DasDataSource && ((DasDataSource)target).getUniqueId().equals(((RawDataSource)this.getTarget()).getUniqueId());
    }

    public DatabaseCredentials getSecretService() {
        return this.myController.getSecretService();
    }

    @NotNull
    public abstract T getTempDataSource();

    @NotNull
    protected String createUniqueName(String baseName) {
        String string = this.myController != null ? this.myController.generateObjectName(this.getDataSource(), baseName) : DbUtil.generateUniqueDataSourceName((Project)this.myProject, (String)baseName);
        if (string == null) {
            AbstractDataSourceConfigurable.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isModified() {
        return this.isNewDataSource();
    }

    protected boolean isNewDataSource() {
        for (DasDataSource ds : this.myManager.getDataSources()) {
            if (ds != this.myDataSource) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/AbstractDataSourceConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/AbstractDataSourceConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempTarget";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createUniqueName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

