/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml;

import com.intellij.CommonBundle;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.AsyncFileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.project.DumbModeBlockedFunctionality;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.uml.UmlEditorProvider;
import com.intellij.uml.UmlEditorProviderKt;
import com.intellij.uml.UmlVirtualFileSystem;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.uml.utils.UmlFileConverter;
import java.io.IOException;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\r\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/uml/UmlEditorProvider;", "Lcom/intellij/openapi/fileEditor/AsyncFileEditorProvider;", "<init>", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "convertFile", "createFileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "document", "Lcom/intellij/openapi/editor/Document;", "editorCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/Document;Lkotlinx/coroutines/CoroutineScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createEditor", "getEditorTypeId", "", "Lorg/jetbrains/annotations/NonNls;", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "Companion", "intellij.diagram.impl"})
public final class UmlEditorProvider
implements AsyncFileEditorProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TYPE_ID = "UmlEditorProvider";

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.getFileSystem() instanceof LocalFileSystem && StringsKt.equals((String)"uml", (String)file.getExtension(), (boolean)true)) {
            if (DumbService.Companion.isDumb(project)) {
                return false;
            }
            if (UmlEditorProviderKt.access$isJourneyUmlFormat(file)) {
                return false;
            }
            if (UmlEditorProviderKt.access$isNewUmlFormat(file)) {
                return true;
            }
            if (UmlEditorProviderKt.access$isOldUmlFormat(file)) {
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    return this.convertFile(project, file);
                }
                ApplicationManager.getApplication().invokeLater(() -> UmlEditorProvider.accept$lambda$0(this, project, file));
            }
            return false;
        }
        if (file instanceof UmlVirtualFileSystem.UmlVirtualFile) {
            if (DumbService.Companion.isDumb(project)) {
                return false;
            }
            DiagramProvider provider = ((UmlVirtualFileSystem.UmlVirtualFile)file).getUmlProvider();
            if (provider != null) {
                return UmlEditorProviderKt.access$getElementFromFile(project, (UmlVirtualFileSystem.UmlVirtualFile)file) != null || UmlVirtualFileSystem.isShowChangesFile(file);
            }
        }
        return false;
    }

    private final boolean convertFile(Project project, VirtualFile file) {
        Boolean success;
        if (Messages.showOkCancelDialog((Project)project, (String)DiagramBundle.message("dialog.message.this.file.has.old.format.would.you.like.to.convert.it", new Object[0]), (String)DiagramBundle.message("dialog.title.old.diagram.format", new Object[0]), (Icon)AllIcons.FileTypes.Diagram) == 0 && !(success = (Boolean)WriteAction.computeAndWait(() -> UmlEditorProvider.convertFile$lambda$0(file, this, project))).booleanValue()) {
            Messages.showErrorDialog((Project)project, (String)DiagramBundle.message("dialog.message.can.t.save.converted.content.into.file.check.read.only.status", new Object[0]), (String)CommonBundle.getErrorTitle());
            return true;
        }
        return false;
    }

    @Nullable
    public Object createFileEditor(@NotNull Project project, @NotNull VirtualFile file, @Nullable Document document, @NotNull CoroutineScope editorCoroutineScope, @NotNull Continuation<? super FileEditor> $completion) {
        return BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super FileEditor>, Object>(file, project, null){
            int label;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Project $project;
            {
                this.$file = $file;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!(this.$file instanceof UmlVirtualFileSystem.UmlVirtualFile)) break;
                        this.label = 1;
                        Object object2 = CoroutinesKt.writeIntentReadAction(() -> createFileEditor.2.invokeSuspend$lambda$0(this.$project, this.$file), (Continuation)((Continuation)this));
                        Object object3 = object2;
                        if (object2 != object) return object3;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                if (!(this.$file.getFileSystem() instanceof LocalFileSystem)) return UmlEditorProviderKt.access$createUnknownDiagramEmptyEditor(this.$project, this.$file);
                FileEditor fileEditor = UmlEditorProviderKt.access$createEditorFromLocalFileSystem(this.$project, this.$file);
                if (fileEditor == null) return UmlEditorProviderKt.access$createUnknownDiagramEmptyEditor(this.$project, this.$file);
                return fileEditor;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super FileEditor> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final FileEditor invokeSuspend$lambda$0(Project $project, VirtualFile $file) {
                return UmlEditorProviderKt.access$createEditorFromPsiElement($project, (UmlVirtualFileSystem.UmlVirtualFile)$file);
            }
        }), $completion);
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        FileEditor editor;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (DumbService.Companion.isDumb(project)) {
            DumbService dumbService = DumbService.Companion.getInstance(project);
            String string = DiagramBundle.message("notification.can.t.open.diagram.while.indexing.is.in.progress", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            dumbService.showDumbModeNotificationForFunctionality(string, DumbModeBlockedFunctionality.Uml);
            return UmlEditorProviderKt.access$createUnknownDiagramEmptyEditor(project, file);
        }
        if (file instanceof UmlVirtualFileSystem.UmlVirtualFile) {
            return UmlEditorProviderKt.access$createEditorFromPsiElement(project, (UmlVirtualFileSystem.UmlVirtualFile)file);
        }
        if (file.getFileSystem() instanceof LocalFileSystem && (editor = UmlEditorProviderKt.access$createEditorFromLocalFileSystem(project, file)) != null) {
            return editor;
        }
        return UmlEditorProviderKt.access$createUnknownDiagramEmptyEditor(project, file);
    }

    @NotNull
    public String getEditorTypeId() {
        return TYPE_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }

    private static final void accept$lambda$0(UmlEditorProvider this$0, Project $project, VirtualFile $file) {
        this$0.convertFile($project, $file);
    }

    private static final Boolean convertFile$lambda$0(VirtualFile $file, UmlEditorProvider this$0, Project $project) {
        try {
            VirtualFile virtualFile = $file.copy((Object)this$0, $file.getParent(), $file.getName() + ".bak.xml");
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"copy(...)");
            VirtualFile copy = virtualFile;
            PsiFile xml = PsiManager.getInstance((Project)$project).findFile(copy);
            if (!(xml instanceof XmlFile)) {
                return false;
            }
            XmlDocument xmlDoc = ((XmlFile)xml).getDocument();
            if (xmlDoc == null) {
                return false;
            }
            org.jdom.Document doc = UmlFileConverter.convert(xmlDoc);
            boolean result = DiagramState.writeXml($file, $project, doc);
            copy.delete(null);
            return result;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/uml/UmlEditorProvider$Companion;", "", "<init>", "()V", "TYPE_ID", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.diagram.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

