/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.javascript.debugger.ui.shared.VariableViewDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.XSourcePositionWrapper;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDescriptor;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XKeywordValuePresentation;
import com.intellij.xdebugger.frame.presentation.XStringValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.XValueTextProvider;
import com.intellij.xdebugger.impl.ui.visualizedtext.VisualizedTextPopupUtil;
import com.jetbrains.javascript.debugger.JavaScriptDebugAware;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentConsumer;
import org.jetbrains.concurrency.ObsolescentFunction;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.concurrency.ValueNodeAsyncFunction;
import org.jetbrains.debugger.ArrayPresentation;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.FunctionScopesValueGroup;
import org.jetbrains.debugger.LazyVariablesGroupKt;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.ObjectProperty;
import org.jetbrains.debugger.ObjectValuePresentation;
import org.jetbrains.debugger.PresentationProvider;
import org.jetbrains.debugger.PsiVisitors;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptDebuggerBundle;
import org.jetbrains.debugger.ScriptManager;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.debugger.VariablesKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.ArrayValue;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.debugger.values.IndexedVariablesConsumer;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.StringValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 a2\u00020\u00012\u00020\u00022\u00020\u0003:\u0003_`aB\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\u000bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J*\u00105\u001a\b\u0012\u0004\u0012\u0002000\u001e2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u00106\u001a\u0004\u0018\u00010\u00052\u0006\u00101\u001a\u000202H\u0002J\n\u00107\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u00108\u001a\u00020\u0015H\u0016J\u001e\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00101\u001a\u000202H\u0002J\u0010\u00109\u001a\u0002002\u0006\u00101\u001a\u00020:H\u0016J\u0012\u0010;\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010=\u0018\u00010<H\u0016J\u001e\u00109\u001a\b\u0012\u0004\u0012\u0002000\u001e2\u0006\u0010>\u001a\u00020?2\u0006\u00101\u001a\u00020:H\u0002J$\u0010@\u001a\u0006\u0012\u0002\b\u00030\u001e2\u0006\u0010\u000e\u001a\u00020A2\u0006\u00101\u001a\u00020:2\u0006\u0010B\u001a\u00020\u0015H\u0002J&\u0010C\u001a\b\u0012\u0004\u0012\u0002000\u001e2\u0006\u0010\u000e\u001a\u00020D2\u0006\u00101\u001a\u00020:2\u0006\u0010B\u001a\u00020\u0015H\u0002JF\u0010E\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00132\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\u0006\u00101\u001a\u00020:2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010G\u001a\u00020?2\u0006\u0010H\u001a\u00020\u0015H\u0002J\u001e\u0010I\u001a\u0002002\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\u0006\u00101\u001a\u00020:H\u0002J\n\u0010O\u001a\u0004\u0018\u00010PH\u0016J\b\u0010Q\u001a\u0004\u0018\u00010\u000fJ\b\u0010R\u001a\u00020\u0015H\u0016J\u0010\u0010S\u001a\u0002002\u0006\u0010T\u001a\u00020UH\u0016J\u0010\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020YH\u0016J\n\u0010Z\u001a\u0004\u0018\u00010\u0005H\u0016J(\u0010[\u001a\u0002002\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00050]2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00032\u0006\u0010^\u001a\u00020\u0005H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0016\u0010%\u001a\u0004\u0018\u00010&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0016\u0010)\u001a\u0004\u0018\u00010*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0014\u0010K\u001a\u00020L8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bM\u0010N\u00a8\u0006b"}, d2={"Lorg/jetbrains/debugger/VariableView;", "Lcom/intellij/xdebugger/frame/XNamedValue;", "Lcom/intellij/xdebugger/impl/ui/XValueTextProvider;", "Lorg/jetbrains/debugger/VariableContext;", "variableName", "", "variable", "Lorg/jetbrains/debugger/Variable;", "context", "<init>", "(Ljava/lang/String;Lorg/jetbrains/debugger/Variable;Lorg/jetbrains/debugger/VariableContext;)V", "(Lorg/jetbrains/debugger/Variable;Lorg/jetbrains/debugger/VariableContext;)V", "getVariableName", "()Ljava/lang/String;", "value", "Lorg/jetbrains/debugger/values/Value;", "_memberFilter", "Lorg/jetbrains/debugger/MemberFilter;", "remainingChildren", "", "watchableAsEvaluationExpression", "", "viewSupport", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "getViewSupport", "()Lorg/jetbrains/debugger/DebuggerViewSupport;", "parent", "getParent", "()Lorg/jetbrains/debugger/VariableContext;", "memberFilter", "Lorg/jetbrains/concurrency/Promise;", "getMemberFilter", "()Lorg/jetbrains/concurrency/Promise;", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "getEvaluateContext", "()Lorg/jetbrains/debugger/EvaluateContext;", "scope", "Lorg/jetbrains/debugger/Scope;", "getScope", "()Lorg/jetbrains/debugger/Scope;", "vm", "Lorg/jetbrains/debugger/Vm;", "getVm", "()Lorg/jetbrains/debugger/Vm;", "isLazy", "()Z", "computePresentation", "", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "setEvaluatedValue", "error", "getValueText", "shouldShowTextValue", "computeChildren", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "getXValueDescriptorAsync", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/xdebugger/frame/XDescriptor;", "remainingChildrenOffset", "", "computeIndexedProperties", "Lorg/jetbrains/debugger/values/ArrayValue;", "isLastChildren", "computeNamedProperties", "Lorg/jetbrains/debugger/values/ObjectValue;", "processNamedObjectProperties", "variables", "maxChildrenToAdd", "defaultIsLast", "computeArrayRanges", "properties", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "getModifier", "Lcom/intellij/xdebugger/frame/XValueModifier;", "getValue", "canNavigateToSource", "computeSourcePosition", "navigatable", "Lcom/intellij/xdebugger/frame/XNavigatable;", "computeInlineDebuggerData", "Lcom/intellij/util/ThreeState;", "callback", "Lcom/intellij/xdebugger/frame/XInlineDebuggerDataCallback;", "getEvaluationExpression", "addVarName", "list", "Lcom/intellij/util/SmartList;", "name", "ObsolescentIndexedVariablesConsumer", "StringFullValueEvaluator", "Companion", "intellij.javascript.debugger.ui"})
@SourceDebugExtension(value={"SMAP\nVariableView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VariableView.kt\norg/jetbrains/debugger/VariableView\n+ 2 promise.kt\norg/jetbrains/concurrency/Promises__PromiseKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,582:1\n103#2,5:583\n103#2,5:588\n131#2,3:593\n148#2,3:596\n1#3:599\n*S KotlinDebug\n*F\n+ 1 VariableView.kt\norg/jetbrains/debugger/VariableView\n*L\n140#1:583,5\n182#1:588,5\n79#1:593,3\n89#1:596,3\n*E\n"})
public final class VariableView
extends XNamedValue
implements XValueTextProvider,
VariableContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String variableName;
    @NotNull
    private final Variable variable;
    @NotNull
    private final VariableContext context;
    @Nullable
    private volatile Value value;
    @Nullable
    private MemberFilter _memberFilter;
    @Nullable
    private volatile List<? extends Variable> remainingChildren;
    @NotNull
    private final VariableContext parent;

    public VariableView(@NotNull String variableName, @NotNull Variable variable, @NotNull VariableContext context) {
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(variableName);
        this.variableName = variableName;
        this.variable = variable;
        this.parent = this.context = context;
    }

    @Override
    @NotNull
    public String getVariableName() {
        return this.variableName;
    }

    public VariableView(@NotNull Variable variable, @NotNull VariableContext context) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = variable.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this(string, variable, context);
    }

    @Override
    public boolean watchableAsEvaluationExpression() {
        return this.context.watchableAsEvaluationExpression();
    }

    @Override
    @NotNull
    public DebuggerViewSupport getViewSupport() {
        return this.context.getViewSupport();
    }

    @Override
    @NotNull
    public VariableContext getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public Promise<MemberFilter> getMemberFilter() {
        return this.context.getViewSupport().getMemberFilter(this);
    }

    @Override
    @NotNull
    public EvaluateContext getEvaluateContext() {
        return this.context.getEvaluateContext();
    }

    @Override
    @Nullable
    public Scope getScope() {
        return this.context.getScope();
    }

    @Override
    @Nullable
    public Vm getVm() {
        return this.context.getVm();
    }

    public final boolean isLazy() {
        return this.variable instanceof ObjectProperty && ((ObjectProperty)this.variable).getGetter() != null;
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        this.value = this.variable.getValue();
        if (this.value != null) {
            Value value = this.value;
            Intrinsics.checkNotNull((Object)value);
            this.computePresentation(value, node);
            return;
        }
        if (!this.isLazy()) {
            this.context.getMemberFilter().then(arg_0 -> VariableView.computePresentation$lambda$1(arg_0 -> VariableView.computePresentation$lambda$0(this, node, arg_0), arg_0));
            return;
        }
        node.setPresentation(null, new XValuePresentation(){

            public void renderValue(XValuePresentation.XValueTextRenderer renderer) {
                Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
                renderer.renderValue("");
            }
        }, false);
        String string = ScriptDebuggerBundle.message((String)"full.evaluator.invoke.getter", (Object[])new Object[0]);
        node.setFullValueEvaluator(new XFullValueEvaluator(this, node, string){
            final /* synthetic */ VariableView this$0;
            final /* synthetic */ XValueNode $node;
            {
                this.this$0 = $receiver;
                this.$node = $node;
                super($super_call_param$1);
            }

            /*
             * WARNING - void declaration
             */
            public void startEvaluation(XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                void node$iv;
                void $this$thenAsync$iv;
                Object object;
                VariableView context;
                Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
                ValueModifier valueModifier = VariableView.access$getVariable$p(this.this$0).getValueModifier();
                VariableContext nonProtoContext = VariableView.access$getContext$p(this.this$0);
                while (nonProtoContext instanceof VariableView && VariableViewKt.access$isPrototypeVariable(((VariableView)nonProtoContext).getVariableName())) {
                    valueModifier = VariableView.access$getVariable$p((VariableView)nonProtoContext).getValueModifier();
                    nonProtoContext = ((VariableView)nonProtoContext).getParent();
                }
                if (valueModifier == null) {
                    VariableContext variableContext = nonProtoContext;
                    Intrinsics.checkNotNull((Object)variableContext, (String)"null cannot be cast to non-null type org.jetbrains.debugger.VariableView");
                    context = (VariableView)variableContext;
                    object = VariableView.access$getVariable$p(context).getValue();
                    ValueModifier valueModifier2 = object instanceof ValueModifier ? (ValueModifier)object : null;
                    if (valueModifier2 == null) {
                        return;
                    }
                    valueModifier = valueModifier2;
                }
                context = valueModifier.evaluateGet(VariableView.access$getVariable$p(this.this$0), this.this$0.getEvaluateContext());
                Obsolescent obsolescent = (Obsolescent)this.$node;
                object = this.this$0;
                XValueNode xValueNode = this.$node;
                boolean $i$f$thenAsync = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$thenAsync$iv.thenAsync((Function)new ValueNodeAsyncFunction<Value, Unit>((Obsolescent)node$iv, callback, (VariableView)object, xValueNode){
                    final /* synthetic */ XFullValueEvaluator.XFullValueEvaluationCallback $callback$inlined;
                    final /* synthetic */ VariableView this$0;
                    final /* synthetic */ XValueNode $node$inlined;
                    {
                        this.$callback$inlined = xFullValueEvaluationCallback;
                        this.this$0 = variableView;
                        this.$node$inlined = xValueNode;
                        super($node);
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public Promise fun(Object param) {
                        Value it = (Value)param;
                        boolean bl = false;
                        this.$callback$inlined.evaluated("");
                        return VariableView.access$setEvaluatedValue(this.this$0, it, null, this.$node$inlined);
                    }
                }), (String)"thenAsync(...)");
            }
        }.setShowValuePopup(false));
    }

    private final Promise<Unit> setEvaluatedValue(Value value, String error, XValueNode node) {
        Promise promise;
        if (value == null) {
            String string = error;
            if (string == null) {
                string = "Internal Error";
            }
            node.setPresentation(AllIcons.Debugger.Db_primitive, null, string, false);
            promise = Promises.resolvedPromise();
        } else {
            this.value = value;
            promise = this.computePresentation(value, node);
        }
        return promise;
    }

    @Nullable
    public String getValueText() {
        Value value = this.value;
        return value != null ? value.getValueString() : null;
    }

    public boolean shouldShowTextValue() {
        Value value = this.value;
        return (value != null ? value.getType() : null) == ValueType.STRING;
    }

    /*
     * WARNING - void declaration
     */
    private final Promise<Unit> computePresentation(Value value, XValueNode node) {
        void $this$then$iv;
        Promise promise = Promises.first((Collection)JavaScriptDebugAware.Companion.getEP_NAME().getExtensionList(), (Obsolescent)((Obsolescent)node), arg_0 -> VariableView.computePresentation$lambda$2(value, node, this, arg_0));
        Obsolescent obsolescent$iv = (Obsolescent)node;
        boolean $i$f$then = false;
        Promise promise2 = $this$then$iv.then((Function)new ObsolescentFunction<JavaScriptDebugAware, Unit>(obsolescent$iv, this, value, node){
            final /* synthetic */ Obsolescent $obsolescent;
            final /* synthetic */ VariableView this$0;
            final /* synthetic */ Value $value$inlined;
            final /* synthetic */ XValueNode $node$inlined;
            {
                this.$obsolescent = $obsolescent;
                this.this$0 = variableView;
                this.$value$inlined = value;
                this.$node$inlined = xValueNode;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * Enabled aggressive block sorting
             */
            public Object fun(Object param) {
                JavaScriptDebugAware extensionWithAlternativePresentation = (JavaScriptDebugAware)param;
                boolean bl = false;
                if (extensionWithAlternativePresentation != null) return Unit.INSTANCE;
                if (VariableView.access$getVariable$p(this.this$0) instanceof ObjectProperty) {
                    String string = ((ObjectProperty)VariableView.access$getVariable$p(this.this$0)).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (VariableViewKt.access$isPrototypeVariable(string) && this.$value$inlined.getType() != ValueType.NULL) {
                        Intrinsics.checkNotNull((Object)this.$value$inlined, (String)"null cannot be cast to non-null type org.jetbrains.debugger.values.ObjectValue");
                        VariableView.Companion.setObjectPresentation((ObjectValue)this.$value$inlined, VariableView.access$getIcon(this.this$0), this.$node$inlined);
                        return Unit.INSTANCE;
                    }
                }
                switch (WhenMappings.$EnumSwitchMapping$0[this.$value$inlined.getType().ordinal()]) {
                    case 1: 
                    case 2: {
                        DebuggerViewSupport debuggerViewSupport = VariableView.access$getContext$p(this.this$0).getViewSupport();
                        Intrinsics.checkNotNull((Object)this.$value$inlined, (String)"null cannot be cast to non-null type org.jetbrains.debugger.values.ObjectValue");
                        debuggerViewSupport.computeObjectPresentation((ObjectValue)this.$value$inlined, VariableView.access$getVariable$p(this.this$0), VariableView.access$getContext$p(this.this$0), this.$node$inlined, VariableView.access$getIcon(this.this$0));
                        return Unit.INSTANCE;
                    }
                    case 3: {
                        this.$node$inlined.setPresentation(VariableView.access$getIcon(this.this$0), (XValuePresentation)new ObjectValuePresentation(VariableViewKt.trimFunctionDescription(this.$value$inlined)), true);
                        return Unit.INSTANCE;
                    }
                    case 4: {
                        VariableView.access$getContext$p(this.this$0).getViewSupport().computeArrayPresentation(this.$value$inlined, VariableView.access$getVariable$p(this.this$0), VariableView.access$getContext$p(this.this$0), this.$node$inlined, VariableView.access$getIcon(this.this$0));
                        return Unit.INSTANCE;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        Icon icon = VariableView.access$getIcon(this.this$0);
                        String string = this.$value$inlined.getValueString();
                        Intrinsics.checkNotNull((Object)string);
                        this.$node$inlined.setPresentation(icon, (XValuePresentation)new XKeywordValuePresentation(string), false);
                        return Unit.INSTANCE;
                    }
                    case 8: 
                    case 9: {
                        Icon icon = VariableView.access$getIcon(this.this$0);
                        String string = this.$value$inlined.getValueString();
                        Intrinsics.checkNotNull((Object)string);
                        this.$node$inlined.setPresentation(icon, VariableViewKt.access$createNumberPresentation(string), false);
                        return Unit.INSTANCE;
                    }
                    case 10: {
                        Icon icon = VariableView.access$getIcon(this.this$0);
                        String string = this.$value$inlined.getValueString();
                        Intrinsics.checkNotNull((Object)string);
                        this.$node$inlined.setPresentation(icon, (XValuePresentation)new XStringValuePresentation(string), false);
                        String string2 = this.$value$inlined.getValueString();
                        Intrinsics.checkNotNull((Object)string2);
                        if (!VisualizedTextPopupUtil.isVisualizable((String)string2)) {
                            String string3 = this.$value$inlined.getValueString();
                            Intrinsics.checkNotNull((Object)string3);
                            if (string3.length() <= 1000) return Unit.INSTANCE;
                        }
                        this.$node$inlined.setFullValueEvaluator((XFullValueEvaluator)new StringFullValueEvaluator(this.$value$inlined));
                        return Unit.INSTANCE;
                    }
                }
                Icon icon = VariableView.access$getIcon(this.this$0);
                String string = this.$value$inlined.getValueString();
                Intrinsics.checkNotNull((Object)string);
                this.$node$inlined.setPresentation(icon, null, string, true);
                return Unit.INSTANCE;
            }

            public boolean isObsolete() {
                return this.$obsolescent.isObsolete();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return promise2;
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ApplicationManager.getApplication().executeOnPooledThread(() -> VariableView.computeChildren$lambda$0(this, node));
    }

    @Nullable
    public CompletableFuture<XDescriptor> getXValueDescriptorAsync() {
        return CompletableFuture.completedFuture(new VariableViewDescriptor());
    }

    /*
     * WARNING - void declaration
     */
    private final Promise<Unit> computeChildren(int remainingChildrenOffset, XCompositeNode node) {
        void $this$then$iv;
        Promise promise = Promises.first((Collection)JavaScriptDebugAware.Companion.getEP_NAME().getExtensionList(), (Obsolescent)((Obsolescent)node), arg_0 -> VariableView.computeChildren$lambda$1(this, node, arg_0));
        Obsolescent obsolescent$iv = (Obsolescent)node;
        boolean $i$f$then = false;
        Promise promise2 = $this$then$iv.then((Function)new ObsolescentFunction<JavaScriptDebugAware, Unit>(obsolescent$iv, node, this, remainingChildrenOffset){
            final /* synthetic */ Obsolescent $obsolescent;
            final /* synthetic */ XCompositeNode $node$inlined;
            final /* synthetic */ VariableView this$0;
            final /* synthetic */ int $remainingChildrenOffset$inlined;
            {
                this.$obsolescent = $obsolescent;
                this.$node$inlined = xCompositeNode;
                this.this$0 = variableView;
                this.$remainingChildrenOffset$inlined = n;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public Object fun(Object param) {
                JavaScriptDebugAware extensionWithAlternativeChildrenComputation = (JavaScriptDebugAware)param;
                boolean bl = false;
                if (extensionWithAlternativeChildrenComputation == null) {
                    this.$node$inlined.setAlreadySorted(true);
                    if (!(VariableView.access$getValue$p(this.this$0) instanceof ObjectValue)) {
                        this.$node$inlined.addChildren(XValueChildrenList.EMPTY, true);
                    } else if (this.$remainingChildrenOffset$inlined > 0) {
                        List list = VariableView.access$getRemainingChildren$p(this.this$0);
                        Intrinsics.checkNotNull((Object)list);
                        List list2 = list;
                        int to = RangesKt.coerceAtMost((int)(this.$remainingChildrenOffset$inlined + 100), (int)list2.size());
                        boolean isLast = to == list2.size();
                        this.$node$inlined.addChildren(VariablesKt.createVariablesList(list2, this.$remainingChildrenOffset$inlined, to, this.this$0, VariableView.access$get_memberFilter$p(this.this$0)), isLast);
                        if (!isLast) {
                            this.$node$inlined.tooManyChildren(list2.size() - to, new Runnable(this.this$0, this.$remainingChildrenOffset$inlined, this.$node$inlined){
                                final /* synthetic */ VariableView this$0;
                                final /* synthetic */ int $remainingChildrenOffset;
                                final /* synthetic */ XCompositeNode $node;
                                {
                                    this.this$0 = $receiver;
                                    this.$remainingChildrenOffset = $remainingChildrenOffset;
                                    this.$node = $node;
                                }

                                public final void run() {
                                    VariableView.access$computeChildren(this.this$0, this.$remainingChildrenOffset + 100, this.$node);
                                }
                            });
                        }
                    } else {
                        Promise $this$thenAsync$iv;
                        Obsolescent node$iv;
                        Value value = VariableView.access$getValue$p(this.this$0);
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.jetbrains.debugger.values.ObjectValue");
                        ObjectValue objectValue = (ObjectValue)value;
                        boolean hasNamedProperties = objectValue.hasProperties() != ThreeState.NO;
                        boolean hasIndexedProperties = objectValue.hasIndexedProperties() != ThreeState.NO;
                        SmartList promises = new SmartList();
                        Promise<Object> additionalProperties = this.this$0.getViewSupport().computeAdditionalObjectProperties(objectValue, VariableView.access$getVariable$p(this.this$0), this.this$0, this.$node$inlined);
                        if (additionalProperties != null) {
                            promises.add(additionalProperties);
                        }
                        if (hasIndexedProperties) {
                            Intrinsics.checkNotNull((Object)objectValue, (String)"null cannot be cast to non-null type org.jetbrains.debugger.values.ArrayValue");
                            promises.add((Object)VariableView.access$computeIndexedProperties(this.this$0, (ArrayValue)objectValue, this.$node$inlined, !hasNamedProperties && additionalProperties == null));
                        }
                        if (hasNamedProperties) {
                            if (additionalProperties == null || additionalProperties.getState() != Promise.State.PENDING) {
                                v2 = promises.add((Object)VariableView.access$computeNamedProperties(this.this$0, objectValue, this.$node$inlined, !hasIndexedProperties && additionalProperties == null));
                            } else {
                                Promise<Object> promise = additionalProperties;
                                node$iv = (Obsolescent)this.$node$inlined;
                                boolean $i$f$thenAsync = false;
                                Promise promise2 = $this$thenAsync$iv.thenAsync((Function)new ValueNodeAsyncFunction<Object, Unit>(node$iv, this.this$0, objectValue, this.$node$inlined){
                                    final /* synthetic */ VariableView this$0;
                                    final /* synthetic */ ObjectValue $objectValue$inlined;
                                    final /* synthetic */ XCompositeNode $node$inlined;
                                    {
                                        this.this$0 = variableView;
                                        this.$objectValue$inlined = objectValue;
                                        this.$node$inlined = xCompositeNode;
                                        super($node);
                                    }

                                    public Promise<Unit> fun(Object param) {
                                        Object it = param;
                                        boolean bl = false;
                                        return VariableView.access$computeNamedProperties(this.this$0, this.$objectValue$inlined, this.$node$inlined, true);
                                    }
                                });
                                Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"thenAsync(...)");
                                v2 = promises.add((Object)promise2);
                            }
                        }
                        if (hasIndexedProperties == hasNamedProperties || additionalProperties != null) {
                            void $this$processed$iv;
                            $this$thenAsync$iv = Promises.all((Collection)((Collection)promises));
                            node$iv = (Obsolescent)this.$node$inlined;
                            boolean $i$f$processed = false;
                            Promise promise = $this$processed$iv.onProcessed((Consumer)new ObsolescentConsumer<Object>(node$iv, this.$node$inlined){
                                final /* synthetic */ XCompositeNode $node$inlined;
                                {
                                    this.$node$inlined = xCompositeNode;
                                    super($node);
                                }

                                public void accept(Object param) {
                                    boolean bl = false;
                                    this.$node$inlined.addChildren(XValueChildrenList.EMPTY, true);
                                }
                            });
                            Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"onProcessed(...)");
                        }
                    }
                }
                return Unit.INSTANCE;
            }

            public boolean isObsolete() {
                return this.$obsolescent.isObsolete();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return promise2;
    }

    private final Promise<?> computeIndexedProperties(ArrayValue value, XCompositeNode node, boolean isLastChildren) {
        return ObjectValue.getIndexedProperties$default((ObjectValue)((ObjectValue)value), (int)0, (int)value.getLength(), (int)100, (IndexedVariablesConsumer)new ObsolescentIndexedVariablesConsumer(node, value, this, isLastChildren){
            final /* synthetic */ XCompositeNode $node;
            final /* synthetic */ ArrayValue $value;
            final /* synthetic */ VariableView this$0;
            final /* synthetic */ boolean $isLastChildren;
            {
                this.$node = $node;
                this.$value = $value;
                this.this$0 = $receiver;
                this.$isLastChildren = $isLastChildren;
                super($node);
            }

            public void consumeRanges(int[] ranges) {
                if (ranges == null) {
                    XValueChildrenList groupList = new XValueChildrenList();
                    LazyVariablesGroupKt.addGroups(this.$value, computeIndexedProperties.consumeRanges.2.INSTANCE, groupList, 0, this.$value.getLength(), 100, this.this$0);
                    this.$node.addChildren(groupList, this.$isLastChildren);
                } else {
                    LazyVariablesGroupKt.addRanges((ObjectValue)this.$value, ranges, this.$node, this.this$0, this.$isLastChildren);
                }
            }

            public void consumeVariables(List<? extends Variable> variables) {
                Intrinsics.checkNotNullParameter(variables, (String)"variables");
                this.$node.addChildren(VariablesKt.createVariablesList(variables, this.this$0, null), this.$isLastChildren);
            }
        }, null, (int)16, null);
    }

    private final Promise<Unit> computeNamedProperties(ObjectValue value, XCompositeNode node, boolean isLastChildren) {
        return VariablesKt.processVariables(this, (Promise<List<Variable>>)value.getProperties(), (Obsolescent)node, (Function2<? super MemberFilter, ? super List<? extends Variable>, Unit>)((Function2)(arg_0, arg_1) -> VariableView.computeNamedProperties$lambda$0(this, value, node, isLastChildren, arg_0, arg_1)));
    }

    private final List<Variable> processNamedObjectProperties(List<? extends Variable> variables, XCompositeNode node, VariableContext context, MemberFilter memberFilter, int maxChildrenToAdd, boolean defaultIsLast) {
        List<Variable> list = VariablesKt.filterAndSort(variables, memberFilter);
        if (list.isEmpty()) {
            if (defaultIsLast) {
                node.addChildren(XValueChildrenList.EMPTY, true);
            }
            return null;
        }
        int to = RangesKt.coerceAtMost((int)maxChildrenToAdd, (int)list.size());
        boolean isLast = to == list.size();
        node.addChildren(VariablesKt.createVariablesList(list, 0, to, context, memberFilter), defaultIsLast && isLast);
        if (isLast) {
            return null;
        }
        node.tooManyChildren(list.size() - to, () -> VariableView.processNamedObjectProperties$lambda$0(this, node));
        return list;
    }

    private final void computeArrayRanges(List<? extends Variable> properties, XCompositeNode node) {
        int count;
        MemberFilter memberFilter = this._memberFilter;
        Intrinsics.checkNotNull((Object)memberFilter);
        List<Variable> variables = VariablesKt.filterAndSort(properties, memberFilter);
        int bucketSize = 100;
        if (count <= bucketSize) {
            node.addChildren(VariablesKt.createVariablesList(variables, this, null), true);
            return;
        }
        for (count = variables.size(); count > 0 && !Character.isDigit(variables.get(count - 1).getName().charAt(0)); --count) {
        }
        XValueChildrenList groupList = new XValueChildrenList();
        if (count > 0) {
            LazyVariablesGroupKt.addGroups(variables, computeArrayRanges.1.INSTANCE, groupList, 0, count, bucketSize, this);
        }
        int notGroupedVariablesOffset = 0;
        if (variables.size() - count > bucketSize) {
            for (notGroupedVariablesOffset = variables.size(); notGroupedVariablesOffset > 0; --notGroupedVariablesOffset) {
                String string = variables.get(notGroupedVariablesOffset - 1).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.startsWith$default((String)string, (String)"__", (boolean)false, (int)2, null)) break;
            }
            if (notGroupedVariablesOffset > 0) {
                LazyVariablesGroupKt.addGroups(variables, computeArrayRanges.2.INSTANCE, groupList, count, notGroupedVariablesOffset, bucketSize, this);
            }
        } else {
            notGroupedVariablesOffset = count;
        }
        int n = variables.size();
        for (int i = notGroupedVariablesOffset; i < n; ++i) {
            Variable variable = variables.get(i);
            MemberFilter memberFilter2 = this._memberFilter;
            Intrinsics.checkNotNull((Object)memberFilter2);
            groupList.add((XNamedValue)new VariableView(memberFilter2.rawNameToSource(variable), variable, this));
        }
        node.addChildren(groupList, true);
    }

    private final Icon getIcon() {
        Value value = this.value;
        Intrinsics.checkNotNull((Object)value);
        return Companion.getIcon(value);
    }

    @Nullable
    public XValueModifier getModifier() {
        if (!this.variable.isMutable()) {
            return null;
        }
        return new XValueModifier(this){
            final /* synthetic */ VariableView this$0;
            {
                this.this$0 = $receiver;
            }

            public String getInitialValueEditorText() {
                String string;
                Value value = VariableView.access$getValue$p(this.this$0);
                Intrinsics.checkNotNull((Object)value);
                if (value.getType() == ValueType.STRING) {
                    Value value2 = VariableView.access$getValue$p(this.this$0);
                    Intrinsics.checkNotNull((Object)value2);
                    String string2 = value2.getValueString();
                    Intrinsics.checkNotNull((Object)string2);
                    String string3 = string2;
                    StringBuilder builder = new StringBuilder(string3.length());
                    builder.append('\"');
                    StringUtil.escapeStringCharacters((int)string3.length(), (String)string3, (StringBuilder)builder);
                    builder.append('\"');
                    return builder.toString();
                }
                Value value3 = VariableView.access$getValue$p(this.this$0);
                Intrinsics.checkNotNull((Object)value3);
                if (value3.getType().isObjectType()) {
                    string = null;
                } else {
                    Value value4 = VariableView.access$getValue$p(this.this$0);
                    Intrinsics.checkNotNull((Object)value4);
                    string = value4.getValueString();
                }
                return string;
            }

            public void setValue(XExpression expression, XValueModifier.XModificationCallback callback) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
                ValueModifier valueModifier = VariableView.access$getVariable$p(this.this$0).getValueModifier();
                Intrinsics.checkNotNull((Object)valueModifier);
                Variable variable = VariableView.access$getVariable$p(this.this$0);
                String string = expression.getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExpression(...)");
                valueModifier.setValue(variable, string, this.this$0.getEvaluateContext()).onSuccess(arg_0 -> getModifier.1.setValue$lambda$1(arg_0 -> getModifier.1.setValue$lambda$0(this.this$0, callback, arg_0), arg_0)).onError(arg_0 -> getModifier.1.setValue$lambda$3(arg_0 -> getModifier.1.setValue$lambda$2(callback, arg_0), arg_0));
            }

            private static final Unit setValue$lambda$0(VariableView this$0, XValueModifier.XModificationCallback $callback, Object it) {
                VariableView.access$setValue$p(this$0, null);
                $callback.valueModified();
                return Unit.INSTANCE;
            }

            private static final void setValue$lambda$1(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }

            private static final Unit setValue$lambda$2(XValueModifier.XModificationCallback $callback, Throwable it) {
                String string = it.getMessage();
                Intrinsics.checkNotNull((Object)string);
                $callback.errorOccurred(string);
                return Unit.INSTANCE;
            }

            private static final void setValue$lambda$3(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        };
    }

    @Nullable
    public final Value getValue() {
        return this.variable.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canNavigateToSource() {
        if (this.value instanceof FunctionValue) {
            Value value = this.value;
            Object object = value;
            if (value == null) return true;
            String string = object.getValueString();
            object = string;
            if (string == null) return true;
            if (!StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"[native code]", (boolean)false, (int)2, null)) return true;
            boolean bl = true;
            if (!bl) return true;
        }
        if (!this.getViewSupport().canNavigateToSource(this.variable, this.context)) return false;
        return true;
    }

    public void computeSourcePosition(@NotNull XNavigatable navigatable) {
        Intrinsics.checkNotNullParameter((Object)navigatable, (String)"navigatable");
        if (this.value instanceof FunctionValue) {
            Value value = this.value;
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.jetbrains.debugger.values.FunctionValue");
            Promise promise = ((FunctionValue)value).resolve().onSuccess(arg_0 -> VariableView.computeSourcePosition$lambda$1(arg_0 -> VariableView.computeSourcePosition$lambda$0(this, navigatable, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)promise);
        } else {
            DebuggerViewSupport debuggerViewSupport = this.getViewSupport();
            String string = this.getVariableName();
            Value value = this.value;
            Intrinsics.checkNotNull((Object)value);
            debuggerViewSupport.computeSourcePosition(string, value, this.variable, this.context, navigatable);
        }
    }

    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull XInlineDebuggerDataCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        return this.getViewSupport().computeInlineDebuggerData(this.getVariableName(), this.variable, this.context, callback);
    }

    @Nullable
    public String getEvaluationExpression() {
        if (!this.watchableAsEvaluationExpression()) {
            return null;
        }
        if (this.context.getVariableName() == null) {
            return this.variable.getName();
        }
        SmartList list = new SmartList();
        VariableContext variableContext = this.getParent();
        String string = this.variable.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.addVarName((SmartList<String>)list, variableContext, string);
        VariableContext parent = this.context;
        while (true) {
            VariableContext variableContext2 = parent;
            if ((variableContext2 != null ? variableContext2.getVariableName() : null) == null) break;
            VariableContext variableContext3 = parent.getParent();
            String string2 = parent.getVariableName();
            Intrinsics.checkNotNull((Object)string2);
            this.addVarName((SmartList<String>)list, variableContext3, string2);
            parent = parent.getParent();
        }
        return this.context.getViewSupport().propertyNamesToString((List)list, false);
    }

    private final void addVarName(SmartList<String> list, VariableContext parent, String name) {
        if (parent == null || parent.getVariableName() != null) {
            v0 = list.add((Object)name);
        } else {
            String[] stringArray = new String[]{"."};
            v0 = list.addAll((Collection)CollectionsKt.reversed((Iterable)StringsKt.split$default((CharSequence)name, (String[])stringArray, (boolean)false, (int)0, (int)6, null)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Promise computePresentation$lambda$0(VariableView this$0, XValueNode $node, MemberFilter filter) {
        void $this$onError$iv;
        Promise $this$thenAsync$iv;
        EvaluateContext evaluateContext = this$0.getEvaluateContext();
        String string = this$0.variable.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = filter.sourceNameToRaw(string);
        if (string2 == null) {
            String string3 = this$0.variable.getName();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        }
        Promise promise = EvaluateContext.evaluate$default((EvaluateContext)evaluateContext, (String)string2, null, (boolean)false, null, (int)14, null);
        Obsolescent node$iv = (Obsolescent)$node;
        boolean $i$f$thenAsync = false;
        Promise promise2 = $this$thenAsync$iv.thenAsync((Function)new ValueNodeAsyncFunction<EvaluateResult, Unit>(node$iv, this$0, $node){
            final /* synthetic */ VariableView this$0;
            final /* synthetic */ XValueNode $node$inlined;
            {
                this.this$0 = variableView;
                this.$node$inlined = xValueNode;
                super($node);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public Promise fun(Object param) {
                Promise promise;
                EvaluateResult it = (EvaluateResult)param;
                boolean bl = false;
                if (it.getWasThrown()) {
                    promise = VariableView.access$setEvaluatedValue(this.this$0, this.this$0.getViewSupport().transformErrorOnGetUsedReferenceValue(it.getValue(), null), null, this.$node$inlined);
                } else {
                    VariableView.access$setValue$p(this.this$0, it.getValue());
                    VariableView.access$getVariable$p(this.this$0).setValue(it.getValue());
                    promise = VariableView.access$computePresentation(this.this$0, it.getValue(), this.$node$inlined);
                }
                return promise;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"thenAsync(...)");
        $this$thenAsync$iv = promise2;
        node$iv = (Obsolescent)$node;
        boolean $i$f$onError = false;
        Promise promise3 = $this$onError$iv.onError((Consumer)new ObsolescentConsumer<Throwable>(node$iv, this$0, $node){
            final /* synthetic */ VariableView this$0;
            final /* synthetic */ XValueNode $node$inlined;
            {
                this.this$0 = variableView;
                this.$node$inlined = xValueNode;
                super($node);
            }

            public void accept(Throwable param) {
                Intrinsics.checkNotNullParameter((Object)param, (String)"param");
                Throwable it = param;
                boolean bl = false;
                VariableView.access$setEvaluatedValue(this.this$0, this.this$0.getViewSupport().transformErrorOnGetUsedReferenceValue(null, it.getMessage()), it.getMessage(), this.$node$inlined);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)promise3, (String)"onError(...)");
        return promise3;
    }

    private static final Promise computePresentation$lambda$1(Function1 $tmp0, Object p0) {
        return (Promise)$tmp0.invoke(p0);
    }

    private static final Promise computePresentation$lambda$2(Value $value, XValueNode $node, VariableView this$0, JavaScriptDebugAware it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.computeAlternativeValuePresentation($value, $node, this$0.getIcon());
    }

    private static final void computeChildren$lambda$0(VariableView this$0, XCompositeNode $node) {
        this$0.computeChildren(0, $node);
    }

    private static final Promise computeChildren$lambda$1(VariableView this$0, XCompositeNode $node, JavaScriptDebugAware it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.computeAlternativeChildren(this$0.value, $node, this$0);
    }

    private static final Unit computeNamedProperties$lambda$0(VariableView this$0, ObjectValue $value, XCompositeNode $node, boolean $isLastChildren, MemberFilter memberFilter, List variables) {
        FunctionValue functionValue;
        Intrinsics.checkNotNullParameter((Object)memberFilter, (String)"memberFilter");
        Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
        this$0._memberFilter = memberFilter;
        if ($value.getType() == ValueType.ARRAY && !($value instanceof ArrayValue)) {
            this$0.computeArrayRanges(variables, $node);
            return Unit.INSTANCE;
        }
        FunctionValue functionValue2 = functionValue = $value instanceof FunctionValue ? (FunctionValue)$value : null;
        if (functionValue != null && functionValue.hasScopes() == ThreeState.NO) {
            functionValue = null;
        }
        this$0.remainingChildren = this$0.processNamedObjectProperties(variables, $node, this$0, memberFilter, 100, $isLastChildren && functionValue == null);
        if (functionValue != null) {
            $node.addChildren(XValueChildrenList.bottomGroup((XValueGroup)new FunctionScopesValueGroup(functionValue, this$0.context)), $isLastChildren && this$0.remainingChildren == null);
        }
        return Unit.INSTANCE;
    }

    private static final void processNamedObjectProperties$lambda$0(VariableView this$0, XCompositeNode $node) {
        this$0.computeChildren(100, $node);
    }

    private static final Unit computeSourcePosition$lambda$0(VariableView this$0, XNavigatable $navigatable, FunctionValue function) {
        Vm vm = this$0.getVm();
        Intrinsics.checkNotNull((Object)vm);
        ScriptManager scriptManager = vm.getScriptManager();
        Intrinsics.checkNotNull((Object)function);
        scriptManager.getScript(function).onSuccess(arg_0 -> VariableView.computeSourcePosition$lambda$0$1(arg_0 -> VariableView.computeSourcePosition$lambda$0$0($navigatable, this$0, function, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private static final Unit computeSourcePosition$lambda$0$0(XNavigatable $navigatable, VariableView this$0, FunctionValue $function, Script script) {
        v0 = $navigatable;
        v1 = script;
        if (v1 == null) ** GOTO lbl-1000
        var4_4 = v1;
        var6_5 = v0;
        $i$a$-let-VariableView$computeSourcePosition$1$1$1 = false;
        v2 = this$0.getViewSupport().getSourceInfo(null, it, $function.getOpenParenLine(), $function.getOpenParenColumn());
        v0 = var6_5;
        v1 = v2;
        if (v2 != null) {
            it = v1;
            var6_5 = v0;
            $i$a$-let-VariableView$computeSourcePosition$1$1$2 = false;
            v3 = new XSourcePositionWrapper((SourceInfo)it){

                public Navigatable createNavigatable(Project project) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Navigatable navigatable = (Navigatable)ReadAction.compute(() -> computeSourcePosition.1.1.2.1.createNavigatable$lambda$0(this, project));
                    if (navigatable == null) {
                        Navigatable navigatable2 = super.createNavigatable(project);
                        navigatable = navigatable2;
                        Intrinsics.checkNotNullExpressionValue((Object)navigatable2, (String)"createNavigatable(...)");
                    }
                    return navigatable;
                }

                private static final Navigatable createNavigatable$lambda$0(computeSourcePosition.1.1.2.1 this$0, Project $project) {
                    return (Navigatable)PsiVisitors.visit((XSourcePosition)this$0.myPosition, (Project)$project, null, computeSourcePosition.1.1.2.1::createNavigatable$lambda$0$0);
                }

                private static final Navigatable createNavigatable$lambda$0$0(XSourcePosition xSourcePosition, PsiElement element, int n, Document document) {
                    Intrinsics.checkNotNullParameter((Object)xSourcePosition, (String)"<unused var>");
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Intrinsics.checkNotNullParameter((Object)document, (String)"<unused var>");
                    PsiElement referenceCandidate = element;
                    PsiElement psiReference = null;
                    while (referenceCandidate.getPrevSibling() != null) {
                        if (!(referenceCandidate instanceof PsiReference)) continue;
                        psiReference = referenceCandidate;
                        break;
                    }
                    if (psiReference == null) {
                        PsiElement psiElement;
                        referenceCandidate = element.getParent();
                        while ((psiElement = referenceCandidate) != null && (psiElement = psiElement.getPrevSibling()) != null) {
                            referenceCandidate = psiElement;
                            if (!(referenceCandidate instanceof PsiReference)) continue;
                            psiReference = referenceCandidate;
                            break;
                        }
                    }
                    PsiElement psiElement = psiReference;
                    PsiElement psiElement2 = psiElement == null ? element.getNavigationElement() : psiElement.getNavigationElement();
                    return psiElement2 instanceof Navigatable ? (Navigatable)psiElement2 : null;
                }
            };
            v0 = var6_5;
        } else lbl-1000:
        // 2 sources

        {
            v3 = null;
        }
        v0.setSourcePosition((XSourcePosition)v3);
        return Unit.INSTANCE;
    }

    private static final void computeSourcePosition$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void computeSourcePosition$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Variable access$getVariable$p(VariableView $this) {
        return $this.variable;
    }

    public static final /* synthetic */ VariableContext access$getContext$p(VariableView $this) {
        return $this.context;
    }

    public static final /* synthetic */ Promise access$setEvaluatedValue(VariableView $this, Value value, String error, XValueNode node) {
        return $this.setEvaluatedValue(value, error, node);
    }

    public static final /* synthetic */ Value access$getValue$p(VariableView $this) {
        return $this.value;
    }

    public static final /* synthetic */ void access$setValue$p(VariableView $this, Value value) {
        $this.value = value;
    }

    public static final /* synthetic */ Promise access$computePresentation(VariableView $this, Value value, XValueNode node) {
        return $this.computePresentation(value, node);
    }

    public static final /* synthetic */ Icon access$getIcon(VariableView $this) {
        return $this.getIcon();
    }

    public static final /* synthetic */ List access$getRemainingChildren$p(VariableView $this) {
        return $this.remainingChildren;
    }

    public static final /* synthetic */ MemberFilter access$get_memberFilter$p(VariableView $this) {
        return $this._memberFilter;
    }

    public static final /* synthetic */ Promise access$computeChildren(VariableView $this, int remainingChildrenOffset, XCompositeNode node) {
        return $this.computeChildren(remainingChildrenOffset, node);
    }

    public static final /* synthetic */ Promise access$computeIndexedProperties(VariableView $this, ArrayValue value, XCompositeNode node, boolean isLastChildren) {
        return $this.computeIndexedProperties(value, node, isLastChildren);
    }

    public static final /* synthetic */ Promise access$computeNamedProperties(VariableView $this, ObjectValue value, XCompositeNode node, boolean isLastChildren) {
        return $this.computeNamedProperties(value, node, isLastChildren);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ&\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\r\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/debugger/VariableView$Companion;", "", "<init>", "()V", "setObjectPresentation", "", "value", "Lorg/jetbrains/debugger/values/ObjectValue;", "icon", "Ljavax/swing/Icon;", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "setArrayPresentation", "Lorg/jetbrains/debugger/values/Value;", "context", "Lorg/jetbrains/debugger/VariableContext;", "getIcon", "intellij.javascript.debugger.ui"})
    @SourceDebugExtension(value={"SMAP\nVariableView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VariableView.kt\norg/jetbrains/debugger/VariableView$Companion\n+ 2 promise.kt\norg/jetbrains/concurrency/Promises__PromiseKt\n*L\n1#1,582:1\n110#2,3:583\n148#2,3:586\n*S KotlinDebug\n*F\n+ 1 VariableView.kt\norg/jetbrains/debugger/VariableView$Companion\n*L\n513#1:583,3\n514#1:586,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void setObjectPresentation(@NotNull ObjectValue value, @NotNull Icon icon, @NotNull XValueNode node) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            node.setPresentation(icon, (XValuePresentation)new ObjectValuePresentation(VariableViewKt.getObjectValueDescription(value)), value.hasProperties() != ThreeState.NO);
        }

        /*
         * WARNING - void declaration
         */
        public final void setArrayPresentation(@NotNull Value value, @NotNull VariableContext context, @NotNull Icon icon, @NotNull XValueNode node) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            boolean bl2 = bl = value.getType() == ValueType.ARRAY;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (value instanceof ArrayValue) {
                int length = ((ArrayValue)value).getLength();
                node.setPresentation(icon, (XValuePresentation)new ArrayPresentation(length, ((ArrayValue)value).getClassName()), length > 0);
                return;
            }
            if (value instanceof PresentationProvider && ((PresentationProvider)value).computePresentation(node, icon)) {
                return;
            }
            String valueString = value.getValueString();
            if (valueString != null && (StringsKt.endsWith$default((String)valueString, (String)")", (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)valueString, (char)']', (boolean)false, (int)2, null)) && VariableViewKt.access$getARRAY_DESCRIPTION_PATTERN$p().matcher(valueString).find()) {
                node.setPresentation(icon, null, valueString, true);
                v1 = Unit.INSTANCE;
            } else {
                void $this$onError$iv;
                Promise $this$onSuccess$iv;
                Promise promise = EvaluateContext.evaluate$default((EvaluateContext)context.getEvaluateContext(), (String)"a.length", Collections.singletonMap("a", value), (boolean)false, null, (int)8, null);
                Obsolescent node$iv = (Obsolescent)node;
                boolean $i$f$onSuccess = false;
                Promise promise2 = $this$onSuccess$iv.onSuccess((Consumer)new ObsolescentConsumer<EvaluateResult>(node$iv, node, icon){
                    final /* synthetic */ XValueNode $node$inlined;
                    final /* synthetic */ Icon $icon$inlined;
                    {
                        this.$node$inlined = xValueNode;
                        this.$icon$inlined = icon;
                        super($node);
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public void accept(Object param) {
                        EvaluateResult it = (EvaluateResult)param;
                        boolean bl = false;
                        this.$node$inlined.setPresentation(this.$icon$inlined, null, "Array[" + it.getValue().getValueString() + "]", true);
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"onSuccess(...)");
                $this$onSuccess$iv = promise2;
                node$iv = (Obsolescent)node;
                boolean $i$f$onError = false;
                Promise promise3 = $this$onError$iv.onError((Consumer)new ObsolescentConsumer<Throwable>(node$iv, node, icon, valueString){
                    final /* synthetic */ XValueNode $node$inlined;
                    final /* synthetic */ Icon $icon$inlined;
                    final /* synthetic */ String $valueString$inlined;
                    {
                        this.$node$inlined = xValueNode;
                        this.$icon$inlined = icon;
                        this.$valueString$inlined = string;
                        super($node);
                    }

                    public void accept(Throwable param) {
                        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
                        Throwable it = param;
                        boolean bl = false;
                        boolean $i$f$logger = false;
                        Logger logger = Logger.getInstance(VariableView.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.error("Failed to evaluate array length: " + it);
                        this.$node$inlined.setPresentation(this.$icon$inlined, null, this.$valueString$inlined != null ? this.$valueString$inlined : "Array", true);
                    }
                });
                v1 = promise3;
                Intrinsics.checkNotNullExpressionValue((Object)promise3, (String)"onError(...)");
            }
        }

        @NotNull
        public final Icon getIcon(@NotNull Value value) {
            Icon icon;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            ValueType type = value.getType();
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    Icon icon2 = AllIcons.Nodes.Lambda;
                    icon = icon2;
                    Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Lambda");
                    break;
                }
                case 2: {
                    Icon icon3 = AllIcons.Debugger.Db_array;
                    icon = icon3;
                    Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Db_array");
                    break;
                }
                default: {
                    if (type.isObjectType()) {
                        Icon icon4 = AllIcons.Debugger.Value;
                        icon = icon4;
                        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Value");
                        break;
                    }
                    Icon icon5 = AllIcons.Debugger.Db_primitive;
                    icon = icon5;
                    Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"Db_primitive");
                }
            }
            return icon;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ValueType.values().length];
                try {
                    nArray[ValueType.FUNCTION.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ValueType.ARRAY.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/debugger/VariableView$ObsolescentIndexedVariablesConsumer;", "Lorg/jetbrains/debugger/values/IndexedVariablesConsumer;", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "<init>", "(Lcom/intellij/xdebugger/frame/XCompositeNode;)V", "getNode", "()Lcom/intellij/xdebugger/frame/XCompositeNode;", "isObsolete", "", "()Z", "intellij.javascript.debugger.ui"})
    public static abstract class ObsolescentIndexedVariablesConsumer
    extends IndexedVariablesConsumer {
        @NotNull
        private final XCompositeNode node;

        public ObsolescentIndexedVariablesConsumer(@NotNull XCompositeNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.node = node;
        }

        @NotNull
        protected final XCompositeNode getNode() {
            return this.node;
        }

        public boolean isObsolete() {
            return this.node.isObsolete();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/debugger/VariableView$StringFullValueEvaluator;", "Lcom/intellij/xdebugger/frame/XFullValueEvaluator;", "value", "Lorg/jetbrains/debugger/values/Value;", "<init>", "(Lorg/jetbrains/debugger/values/Value;)V", "startEvaluation", "", "callback", "Lcom/intellij/xdebugger/frame/XFullValueEvaluator$XFullValueEvaluationCallback;", "intellij.javascript.debugger.ui"})
    private static final class StringFullValueEvaluator
    extends XFullValueEvaluator {
        @NotNull
        private final Value value;

        public StringFullValueEvaluator(@NotNull Value value) {
            int n;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof StringValue) {
                n = ((StringValue)value).getLength();
            } else {
                String string = value.getValueString();
                Intrinsics.checkNotNull((Object)string);
                n = string.length();
            }
            super(n);
            this.value = value;
        }

        public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            if (!(this.value instanceof StringValue) || !((StringValue)this.value).isTruncated()) {
                String string = this.value.getValueString();
                Intrinsics.checkNotNull((Object)string);
                callback.evaluated(string);
                return;
            }
            AtomicBoolean evaluated = new AtomicBoolean();
            ((StringValue)this.value).getFullString().onSuccess(arg_0 -> StringFullValueEvaluator.startEvaluation$lambda$1(arg_0 -> StringFullValueEvaluator.startEvaluation$lambda$0(callback, evaluated, this, arg_0), arg_0)).onError(arg_0 -> StringFullValueEvaluator.startEvaluation$lambda$3(arg_0 -> StringFullValueEvaluator.startEvaluation$lambda$2(callback, arg_0), arg_0));
        }

        private static final Unit startEvaluation$lambda$0(XFullValueEvaluator.XFullValueEvaluationCallback $callback, AtomicBoolean $evaluated, StringFullValueEvaluator this$0, String it) {
            if (!$callback.isObsolete() && $evaluated.compareAndSet(false, true)) {
                String string = this$0.value.getValueString();
                Intrinsics.checkNotNull((Object)string);
                $callback.evaluated(string);
            }
            return Unit.INSTANCE;
        }

        private static final void startEvaluation$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final Unit startEvaluation$lambda$2(XFullValueEvaluator.XFullValueEvaluationCallback $callback, Throwable it) {
            String string = it.getMessage();
            Intrinsics.checkNotNull((Object)string);
            $callback.errorOccurred(string);
            return Unit.INSTANCE;
        }

        private static final void startEvaluation$lambda$3(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValueType.values().length];
            try {
                nArray[ValueType.OBJECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.NODE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.FUNCTION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.ARRAY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.BOOLEAN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.NULL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.UNDEFINED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.NUMBER.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.BIGINT.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.STRING.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

