/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.references;

import com.intellij.beanValidation.utils.BVUtils;
import com.intellij.codeInsight.highlighting.HighlightedReference;
import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.references.I18nUtil;
import com.intellij.lang.properties.references.PropertiesPsiCompletionUtil;
import com.intellij.lang.properties.references.PropertyReferenceBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class BvMessageReference
extends PropertyReferenceBase
implements HighlightedReference {
    BvMessageReference(@NotNull String key, @NotNull PsiElement element, @NotNull TextRange range) {
        if (key == null) {
            BvMessageReference.$$$reportNull$$$0(0);
        }
        if (element == null) {
            BvMessageReference.$$$reportNull$$$0(1);
        }
        if (range == null) {
            BvMessageReference.$$$reportNull$$$0(2);
        }
        super(key, true, element, range);
    }

    public boolean isHighlightedWhenSoft() {
        return true;
    }

    public Object @NotNull [] getVariants() {
        LinkedHashSet variants = new LinkedHashSet();
        HashSet<String> keys = new HashSet<String>();
        for (PropertiesFile file : this.getPropertiesFiles()) {
            LinkedHashSet newVariants = new LinkedHashSet();
            PropertiesPsiCompletionUtil.addVariantsFromFile((PropertyReferenceBase)this, (PropertiesFile)file, newVariants);
            for (Object variant : newVariants) {
                String key;
                if (!(variant instanceof Property) || keys.contains(key = ((Property)variant).getKey())) continue;
                variants.add(variant);
                keys.add(key);
            }
        }
        Object[] objectArray = ArrayUtil.toObjectArray(variants);
        if (objectArray == null) {
            BvMessageReference.$$$reportNull$$$0(3);
        }
        return objectArray;
    }

    @NotNull
    protected List<PropertiesFile> getPropertiesFiles() {
        String classFqn;
        PsiElement element = this.getElement();
        PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (parentClass != null && (classFqn = parentClass.getQualifiedName()) != null && BvMessageReference.isInConstraintPackage(classFqn) && BVUtils.isHibernateValidatorAvailable(element.getProject())) {
            Project project = element.getProject();
            PropertiesReferenceManager propertiesReferenceManager = PropertiesReferenceManager.getInstance((Project)project);
            List list = propertiesReferenceManager.findPropertiesFiles(GlobalSearchScope.allScope((Project)project), "org.hibernate.validator.ValidationMessages", BundleNameEvaluator.DEFAULT);
            if (list == null) {
                BvMessageReference.$$$reportNull$$$0(4);
            }
            return list;
        }
        List list = I18nUtil.propertiesFilesByBundleName((String)"ValidationMessages", (PsiElement)element);
        if (list == null) {
            BvMessageReference.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static boolean isInConstraintPackage(String classFqn) {
        return classFqn.startsWith("javax.validation.constraints.") || classFqn.startsWith("jakarta.validation.constraints.");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/beanValidation/references/BvMessageReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/beanValidation/references/BvMessageReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

