/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import de.plushnikov.intellij.plugin.problem.LombokProblem;
import de.plushnikov.intellij.plugin.problem.ProblemValidationSink;
import de.plushnikov.intellij.plugin.processor.AbstractProcessor;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class CleanupProcessor
extends AbstractProcessor {
    public CleanupProcessor() {
        super(PsiElement.class, "lombok.Cleanup");
    }

    @Override
    @NotNull
    public Collection<PsiAnnotation> collectProcessedAnnotations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CleanupProcessor.$$$reportNull$$$0(0);
        }
        List<PsiAnnotation> list = Collections.emptyList();
        if (list == null) {
            CleanupProcessor.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<LombokProblem> verifyAnnotation(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            CleanupProcessor.$$$reportNull$$$0(2);
        }
        ProblemValidationSink problemNewBuilder = new ProblemValidationSink();
        PsiLocalVariable psiVariable = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiLocalVariable.class);
        if (null != psiVariable) {
            String cleanupName = PsiAnnotationUtil.getStringAnnotationValue(psiAnnotation, "value", "close");
            if (StringUtil.isEmptyOrSpaces((String)cleanupName)) {
                problemNewBuilder.addErrorMessage("inspection.message.cleanup.value.cannot.be.empty.string", new Object[0]);
            } else {
                CleanupProcessor.validateCleanUpMethodExists(psiVariable, cleanupName, problemNewBuilder);
            }
            CleanupProcessor.validateInitializerExist(problemNewBuilder, psiVariable);
        } else {
            problemNewBuilder.addErrorMessage("inspection.message.cleanup.legal.only.on.local.variable.declarations", new Object[0]);
        }
        Set<LombokProblem> set = problemNewBuilder.getProblems();
        if (set == null) {
            CleanupProcessor.$$$reportNull$$$0(3);
        }
        return set;
    }

    private static void validateCleanUpMethodExists(@NotNull PsiLocalVariable psiVariable, @NotNull String cleanupName, @NotNull ProblemValidationSink problemNewBuilder) {
        PsiType psiType;
        if (psiVariable == null) {
            CleanupProcessor.$$$reportNull$$$0(4);
        }
        if (cleanupName == null) {
            CleanupProcessor.$$$reportNull$$$0(5);
        }
        if (problemNewBuilder == null) {
            CleanupProcessor.$$$reportNull$$$0(6);
        }
        if ((psiType = psiVariable.getType()) instanceof PsiClassType) {
            PsiClassType psiClassType = (PsiClassType)psiType;
            PsiClass psiClassOfField = psiClassType.resolve();
            if (psiClassOfField != null) {
                PsiMethod[] methods = psiClassOfField.findMethodsByName(cleanupName, true);
                boolean hasCleanupMethod = false;
                for (PsiMethod method : methods) {
                    if (0 != method.getParameterList().getParametersCount()) continue;
                    hasCleanupMethod = true;
                }
                if (!hasCleanupMethod) {
                    problemNewBuilder.addErrorMessage("inspection.message.cleanup.method.s.not.found.on.target.class", cleanupName);
                }
            }
        } else {
            problemNewBuilder.addErrorMessage("inspection.message.cleanup.legal.only.on.local.variable.declaration.inside.block", new Object[0]);
        }
    }

    private static void validateInitializerExist(@NotNull ProblemValidationSink problemNewBuilder, @NotNull PsiLocalVariable psiVariable) {
        if (problemNewBuilder == null) {
            CleanupProcessor.$$$reportNull$$$0(7);
        }
        if (psiVariable == null) {
            CleanupProcessor.$$$reportNull$$$0(8);
        }
        if (!psiVariable.hasInitializer()) {
            problemNewBuilder.addErrorMessage("inspection.message.cleanup.variable.declarations.need.to.be.initialized", new Object[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/CleanupProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiVariable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cleanupName";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemNewBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/CleanupProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProcessedAnnotations";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "verifyAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectProcessedAnnotations";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "verifyAnnotation";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateCleanUpMethodExists";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateInitializerExist";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

