/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz.builder;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.processor.handler.SuperBuilderHandler;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SuperBuilderProcessor
extends AbstractClassProcessor {
    public SuperBuilderProcessor() {
        super((Class<? extends PsiElement>)PsiMethod.class, "lombok.experimental.SuperBuilder");
    }

    private static SuperBuilderHandler getBuilderHandler() {
        return new SuperBuilderHandler();
    }

    @Override
    protected boolean possibleToGenerateElementNamed(@NotNull String nameHint, @NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (nameHint == null) {
            SuperBuilderProcessor.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            SuperBuilderProcessor.$$$reportNull$$$0(1);
        }
        if (psiAnnotation == null) {
            SuperBuilderProcessor.$$$reportNull$$$0(2);
        }
        return nameHint.equals("toBuilder") || nameHint.equals(psiClass.getName()) || nameHint.equals(SuperBuilderProcessor.getBuilderHandler().getBuilderMethodName(psiAnnotation));
    }

    @Override
    protected Collection<String> getNamesOfPossibleGeneratedElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            SuperBuilderProcessor.$$$reportNull$$$0(3);
        }
        if (psiAnnotation == null) {
            SuperBuilderProcessor.$$$reportNull$$$0(4);
        }
        SuperBuilderHandler builderHandler = SuperBuilderProcessor.getBuilderHandler();
        String builderMethodName = builderHandler.getBuilderMethodName(psiAnnotation);
        String constructorName = StringUtil.notNullize((String)psiClass.getName());
        return List.of(builderMethodName, "toBuilder", constructorName);
    }

    @Override
    @NotNull
    public Collection<PsiAnnotation> collectProcessedAnnotations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SuperBuilderProcessor.$$$reportNull$$$0(5);
        }
        Collection<PsiAnnotation> result = super.collectProcessedAnnotations(psiClass);
        SuperBuilderProcessor.addJacksonizedAnnotation(psiClass, result);
        this.addFieldsAnnotation(result, psiClass, "lombok.Singular", "lombok.Builder.Default");
        Collection<PsiAnnotation> collection = result;
        if (collection == null) {
            SuperBuilderProcessor.$$$reportNull$$$0(6);
        }
        return collection;
    }

    private static void addJacksonizedAnnotation(@NotNull PsiClass psiClass, Collection<PsiAnnotation> result) {
        PsiAnnotation jacksonizedAnnotation;
        if (psiClass == null) {
            SuperBuilderProcessor.$$$reportNull$$$0(7);
        }
        if (null != (jacksonizedAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiClass, "lombok.extern.jackson.Jacksonized"))) {
            result.add(jacksonizedAnnotation);
        }
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiAnnotation == null) {
            SuperBuilderProcessor.$$$reportNull$$$0(8);
        }
        if (psiClass == null) {
            SuperBuilderProcessor.$$$reportNull$$$0(9);
        }
        if (builder == null) {
            SuperBuilderProcessor.$$$reportNull$$$0(10);
        }
        return true;
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target, @Nullable String nameHint) {
        SuperBuilderHandler builderHandler;
        String builderClassName;
        PsiClass builderBaseClass;
        if (psiClass == null) {
            SuperBuilderProcessor.$$$reportNull$$$0(11);
        }
        if (psiAnnotation == null) {
            SuperBuilderProcessor.$$$reportNull$$$0(12);
        }
        if (target == null) {
            SuperBuilderProcessor.$$$reportNull$$$0(13);
        }
        if (null != (builderBaseClass = psiClass.findInnerClassByName(builderClassName = (builderHandler = SuperBuilderProcessor.getBuilderHandler()).getBuilderClassName(psiClass), false))) {
            String builderImplClassName;
            PsiClass builderImplClass;
            PsiClassType psiTypeBaseWithGenerics = SuperBuilderHandler.getTypeWithWildcardsForSuperBuilderTypeParameters(builderBaseClass);
            builderHandler.createBuilderBasedConstructor(psiClass, builderBaseClass, psiAnnotation, psiTypeBaseWithGenerics).ifPresent(target::add);
            target.addAll(builderHandler.createBuilderDefaultProviderMethodsIfNecessary(psiClass, null, builderBaseClass, psiAnnotation));
            if (!psiClass.hasModifierProperty("abstract") && null != (builderImplClass = psiClass.findInnerClassByName(builderImplClassName = builderHandler.getBuilderImplClassName(psiClass), false))) {
                builderHandler.createBuilderMethodIfNecessary(psiClass, builderBaseClass, builderImplClass, psiAnnotation, psiTypeBaseWithGenerics).ifPresent(target::add);
                SuperBuilderHandler.createToBuilderMethodIfNecessary(psiClass, builderBaseClass, builderImplClass, psiAnnotation, psiTypeBaseWithGenerics).ifPresent(target::add);
            }
        }
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        if (psiField == null) {
            SuperBuilderProcessor.$$$reportNull$$$0(14);
        }
        if (psiAnnotation == null) {
            SuperBuilderProcessor.$$$reportNull$$$0(15);
        }
        return LombokPsiElementUsage.READ_WRITE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameHint";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/builder/SuperBuilderProcessor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/builder/SuperBuilderProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProcessedAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "possibleToGenerateElementNamed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNamesOfPossibleGeneratedElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectProcessedAnnotations";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addJacksonizedAnnotation";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generatePsiElements";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

