/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.languagescope.java;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.dupLocator.JavaDuplicatesMatcher;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.clones.languagescope.java.JavaDuplicatesBundle;
import com.jetbrains.clones.structures.TextClone;
import com.jetbrains.clones.structures.TextFragment;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.style.UnnecessarilyQualifiedStaticUsageInspection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReplaceWithCallFix
extends PsiUpdateModCommandQuickFix
implements HighPriorityAction {
    private final SmartPsiFileRange myRange;
    @NotNull
    private final String myCall;
    @NotNull
    private final String myPresentable;
    private static final Comparator<PsiMethod> METHOD_COMPARATOR = Comparator.comparing(m -> !ReplaceWithCallFix.getContainingClassName(m).endsWith("Util") && !ReplaceWithCallFix.getContainingClassName(m).endsWith("Utils")).thenComparingInt(m -> ReplaceWithCallFix.getContainingClassName(m).length()).thenComparingInt(m -> m.getName().length()).thenComparing(m -> Objects.requireNonNull(Objects.requireNonNull(m.getContainingClass()).getQualifiedName())).thenComparing(m -> m.getName()).thenComparing(m -> m.getTextOffset());

    @NotNull
    private static String getContainingClassName(PsiMethod m) {
        String string = Objects.requireNonNull(Objects.requireNonNull(m.getContainingClass()).getName());
        if (string == null) {
            ReplaceWithCallFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public ReplaceWithCallFix(SmartPsiFileRange range, @NotNull String call, @NotNull String presentable) {
        if (call == null) {
            ReplaceWithCallFix.$$$reportNull$$$0(1);
        }
        if (presentable == null) {
            ReplaceWithCallFix.$$$reportNull$$$0(2);
        }
        this.myRange = range;
        this.myCall = call;
        this.myPresentable = presentable;
    }

    @NotNull
    String getMethodPresentableName() {
        String string = this.myPresentable;
        if (string == null) {
            ReplaceWithCallFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaDuplicatesBundle.message("inspection.method.body.copy.fix.family.name", new Object[0]);
        if (string == null) {
            ReplaceWithCallFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = CommonQuickFixBundle.message((String)"fix.replace.with.x.call", (Object[])new Object[]{this.myPresentable});
        if (string == null) {
            ReplaceWithCallFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        if (project == null) {
            ReplaceWithCallFix.$$$reportNull$$$0(6);
        }
        if (element == null) {
            ReplaceWithCallFix.$$$reportNull$$$0(7);
        }
        if (updater == null) {
            ReplaceWithCallFix.$$$reportNull$$$0(8);
        }
        PsiFile file = element.getContainingFile();
        Document document = file.getViewProvider().getDocument();
        Segment range = this.myRange.getRange();
        if (range == null) {
            return;
        }
        document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)this.myCall);
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(range.getStartOffset() + this.myCall.length() - 2), PsiMethodCallExpression.class);
        if (call != null) {
            call = (PsiMethodCallExpression)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)call);
            PsiReferenceExpression methodExpr = call.getMethodExpression();
            if (UnnecessarilyQualifiedStaticUsageInspection.isUnnecessarilyQualifiedAccess((PsiJavaCodeReferenceElement)methodExpr, (boolean)false, (boolean)false, (boolean)false)) {
                Objects.requireNonNull(methodExpr.getQualifierExpression()).delete();
            }
            CodeStyleManager.getInstance((Project)project).reformat(call.getParent());
        }
    }

    @Nullable
    public static ReplaceWithCallFix createFix(@NotNull Project project, @NotNull TextClone clone) {
        JavaDuplicatesMatcher swapped;
        if (project == null) {
            ReplaceWithCallFix.$$$reportNull$$$0(9);
        }
        if (clone == null) {
            ReplaceWithCallFix.$$$reportNull$$$0(10);
        }
        TextFragment main = clone.getMain();
        VirtualFile mainFile = main.getFile();
        PsiJavaFile javaFile = (PsiJavaFile)ObjectUtils.tryCast((Object)PsiManager.getInstance((Project)project).findFile(mainFile), PsiJavaFile.class);
        if (javaFile == null) {
            return null;
        }
        List duplicates = clone.getDuplicates();
        PsiResolveHelper helper = PsiResolveHelper.getInstance((Project)project);
        MatchedMethod method = duplicates.stream().map(dup -> ReplaceWithCallFix.findMethod(project, dup)).filter(Objects::nonNull).filter(m -> ReplaceWithCallFix.isAccessible(m.method(), helper, (PsiElement)javaFile)).min(Comparator.comparing(MatchedMethod::method, METHOD_COMPARATOR)).orElse(null);
        if (method == null) {
            return null;
        }
        PsiElement[] mainElements = ReplaceWithCallFix.getFragmentElements(project, main);
        PsiElement[] dupElements = ReplaceWithCallFix.getFragmentElements(project, method.fragment());
        JavaDuplicatesMatcher matcher = new JavaDuplicatesMatcher(dupElements, List.of(mainElements));
        if (!matcher.compare()) {
            return null;
        }
        String call = matcher.createCall(method.method(), method.returnVariable());
        if (call == null) {
            return null;
        }
        MatchedMethod thisMethod = ReplaceWithCallFix.findMethod(project, main);
        if (thisMethod != null && ReplaceWithCallFix.isAccessible(thisMethod.method(), helper, (PsiElement)method.method()) && METHOD_COMPARATOR.compare(thisMethod.method(), method.method()) < 0 && (swapped = new JavaDuplicatesMatcher(mainElements, List.of(dupElements))).compare() && swapped.createCall(thisMethod.method(), thisMethod.returnVariable()) != null) {
            return null;
        }
        String methodName = PsiFormatUtil.formatMethod((PsiMethod)method.method(), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4097, (int)0);
        SmartPsiFileRange rangePointer = SmartPointerManager.getInstance((Project)project).createSmartPsiFileRangePointer((PsiFile)javaFile, main.getRange());
        return new ReplaceWithCallFix(rangePointer, call, methodName);
    }

    private static boolean isAccessible(@NotNull PsiMethod method, @NotNull PsiResolveHelper helper, @NotNull PsiElement place) {
        if (method == null) {
            ReplaceWithCallFix.$$$reportNull$$$0(11);
        }
        if (helper == null) {
            ReplaceWithCallFix.$$$reportNull$$$0(12);
        }
        if (place == null) {
            ReplaceWithCallFix.$$$reportNull$$$0(13);
        }
        return Stream.iterate(method, x$0 -> Objects.nonNull(x$0), rec$ -> ((PsiMember)rec$).getContainingClass()).allMatch(member -> helper.isAccessible((PsiMember)member, place, null));
    }

    public static PsiElement[] getFragmentElements(@NotNull Project project, @NotNull TextFragment textFragment) {
        PsiFile file;
        if (project == null) {
            ReplaceWithCallFix.$$$reportNull$$$0(14);
        }
        if (textFragment == null) {
            ReplaceWithCallFix.$$$reportNull$$$0(15);
        }
        if ((file = PsiManager.getInstance((Project)project).findFile(textFragment.getFile())) == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        TextRange range = textFragment.getRange();
        PsiExpression expr = CodeInsightUtil.findExpressionInRange((PsiFile)file, (int)range.getStartOffset(), (int)range.getEndOffset());
        if (expr != null) {
            return new PsiElement[]{expr};
        }
        return CodeInsightUtil.findStatementsInRange((PsiFile)file, (int)range.getStartOffset(), (int)range.getEndOffset());
    }

    @Nullable
    private static MatchedMethod findMethod(@NotNull Project project, @NotNull TextFragment fragment) {
        PsiJavaFile javaFile;
        if (project == null) {
            ReplaceWithCallFix.$$$reportNull$$$0(16);
        }
        if (fragment == null) {
            ReplaceWithCallFix.$$$reportNull$$$0(17);
        }
        if ((javaFile = (PsiJavaFile)ObjectUtils.tryCast((Object)PsiManager.getInstance((Project)project).findFile(fragment.getFile()), PsiJavaFile.class)) == null) {
            return null;
        }
        TextRange range = fragment.getRange();
        PsiElement start = javaFile.findElementAt(range.getStartOffset());
        PsiElement end = javaFile.findElementAt(range.getEndOffset());
        if (start == null || end == null) {
            return null;
        }
        if (end instanceof PsiWhiteSpace) {
            end = end.getPrevSibling();
            range = TextRange.create((int)range.getStartOffset(), (int)end.getTextRange().getEndOffset());
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)start, (PsiElement)end);
        PsiMethod candidate = null;
        PsiLocalVariable returnVar = null;
        if (parent instanceof PsiCodeBlock) {
            PsiCodeBlock block = (PsiCodeBlock)parent;
            PsiStatement[] statements = block.getStatements();
            if (statements.length == 0) {
                return null;
            }
            if (!range.contains(statements[0].getTextRange())) {
                return null;
            }
            PsiStatement lastStatement = statements[statements.length - 1];
            if (!range.contains(lastStatement.getTextRange())) {
                PsiReturnStatement returnStatement;
                if (statements.length >= 2 && range.contains(statements[statements.length - 2].getTextRange()) && lastStatement instanceof PsiReturnStatement && (returnVar = ExpressionUtils.resolveLocalVariable((PsiExpression)(returnStatement = (PsiReturnStatement)lastStatement).getReturnValue())) != null) {
                    if (!range.contains(returnVar.getTextRange())) {
                        return null;
                    }
                    if (PsiUtil.findReturnStatements((PsiCodeBlock)block).length != 1) {
                        return null;
                    }
                }
                if (returnVar == null) {
                    return null;
                }
            }
            candidate = (PsiMethod)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethod.class);
        }
        if (candidate == null) {
            return null;
        }
        if (!candidate.getModifierList().hasModifierProperty("static")) {
            return null;
        }
        if (candidate.isDeprecated()) {
            return null;
        }
        PsiClass containingClass = candidate.getContainingClass();
        if (containingClass == null || containingClass.getQualifiedName() == null) {
            return null;
        }
        return new MatchedMethod(fragment, candidate, returnVar);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/clones/languagescope/java/ReplaceWithCallFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentable";
                break;
            }
            case 6: 
            case 9: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clone";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textFragment";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingClassName";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/clones/languagescope/java/ReplaceWithCallFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodPresentableName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFix";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFragmentElements";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> new IllegalArgumentException(string);
        };
    }

    private record MatchedMethod(@NotNull TextFragment fragment, @NotNull PsiMethod method, @Nullable PsiLocalVariable returnVariable) {
        @NotNull
        private final TextFragment fragment;
        @NotNull
        private final PsiMethod method;

        private MatchedMethod(@NotNull TextFragment fragment, @NotNull PsiMethod method, @Nullable PsiLocalVariable returnVariable) {
            if (fragment == null) {
                MatchedMethod.$$$reportNull$$$0(0);
            }
            if (method == null) {
                MatchedMethod.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public TextFragment fragment() {
            TextFragment textFragment = this.fragment;
            if (textFragment == null) {
                MatchedMethod.$$$reportNull$$$0(2);
            }
            return textFragment;
        }

        @NotNull
        public PsiMethod method() {
            PsiMethod psiMethod = this.method;
            if (psiMethod == null) {
                MatchedMethod.$$$reportNull$$$0(3);
            }
            return psiMethod;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/clones/languagescope/java/ReplaceWithCallFix$MatchedMethod";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/clones/languagescope/java/ReplaceWithCallFix$MatchedMethod";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fragment";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "method";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

