/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.utils;

import com.intellij.DynamicBundle;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.ide.DataManager;
import com.intellij.javaee.appServers.AppServersIntegrationBundle;
import com.intellij.javaee.appServers.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServers.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.appServers.integration.ApplicationServersUtil;
import com.intellij.javaee.appServers.integration.impl.ApplicationServerImpl;
import com.intellij.javaee.appServers.openapi.ex.AppServerIntegrationsManager;
import com.intellij.javaee.appServers.run.configuration.JavaeeAppServerConfigurationType;
import com.intellij.javaee.appServers.serverInstances.ApplicationServersManager;
import com.intellij.javaee.appServers.utils.supportProvider.AddAppServerSupportUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.NamedColorUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationServerPanel {
    private JPanel myPanel;
    private JComboBox<ApplicationServer> myComboBox;
    private JButton myNewButton;
    private JBLabel myLabel;
    private JPanel myContextComponent;

    public ApplicationServerPanel() {
        this.$$$setupUI$$$();
    }

    public ApplicationServerPanel initialize() {
        return this.initialize(true, false);
    }

    public ApplicationServerPanel initialize(boolean addLabel, boolean allowNullSelection) {
        final List<ApplicationServer> servers = ApplicationServerPanel.getSuitableServers();
        DefaultComboBoxModel<ApplicationServer> model = new DefaultComboBoxModel<ApplicationServer>(servers.toArray(new ApplicationServer[0]));
        if (allowNullSelection) {
            model.insertElementAt(null, 0);
            model.setSelectedItem(null);
        }
        this.myComboBox.setModel(model);
        this.myComboBox.setRenderer((ListCellRenderer<ApplicationServer>)new SimpleListCellRenderer<ApplicationServer>(){

            public void customize(@NotNull JList list, ApplicationServer value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value == null) {
                    this.setText(AppServersIntegrationBundle.message((String)"app.server.panel.no.server", (Object[])new Object[0]));
                    if (!selected) {
                        this.setForeground(NamedColorUtil.getInactiveTextColor());
                    }
                } else {
                    this.setText(value.getName());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/javaee/appServers/utils/ApplicationServerPanel$1", "customize"));
            }
        });
        this.myNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultActionGroup group = new DefaultActionGroup();
                for (final AppServerIntegration integration : AppServerIntegrationsManager.getInstance().getAllIntegrations()) {
                    group.add(new AnAction(integration.getPresentableName(), integration.getPresentableName(), integration.getIcon()){

                        public void actionPerformed(@NotNull AnActionEvent e) {
                            if (e == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            ApplicationServersManager.ApplicationServersManagerModifiableModel model = ApplicationServersManager.getInstance().createModifiableModel();
                            ApplicationServerImpl server = ApplicationServersUtil.createNewApplicationServer(integration, model, servers, ApplicationServerPanel.this.getTargetContextComponent());
                            ApplicationManager.getApplication().runWriteAction(() -> model.commit());
                            if (server != null) {
                                ApplicationServerPanel.this.myComboBox.addItem(server);
                                ApplicationServerPanel.this.myComboBox.setSelectedItem(server);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javaee/appServers/utils/ApplicationServerPanel$2$1", "actionPerformed"));
                        }
                    });
                }
                JBPopupFactory.getInstance().createActionGroupPopup(AppServersIntegrationBundle.message((String)"app.server.panel.new.server", (Object[])new Object[0]), (ActionGroup)group, DataManager.getInstance().getDataContext((Component)ApplicationServerPanel.this.getTargetContextComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false).showUnderneathOf((Component)ApplicationServerPanel.this.myNewButton);
            }
        });
        if (!addLabel) {
            this.myLabel.setVisible(false);
        }
        return this;
    }

    private JPanel getTargetContextComponent() {
        JPanel contextComponent = this.myContextComponent;
        if (contextComponent == null) {
            contextComponent = this.myPanel;
        }
        return contextComponent;
    }

    public void addServerSelectionListener(ActionListener listener) {
        this.myComboBox.addActionListener(listener);
    }

    private static List<ApplicationServer> getSuitableServers() {
        ArrayList<ApplicationServer> servers = new ArrayList<ApplicationServer>();
        for (ApplicationServer server : ApplicationServersManager.getInstance().getApplicationServers()) {
            AppServerIntegration integration = server.getSourceIntegration();
            if (integration == null || !ApplicationServerPanel.isSuitableIntegration(integration)) continue;
            servers.add(server);
        }
        servers.sort(AddAppServerSupportUtil.createAppServerComparator());
        return servers;
    }

    private static boolean isSuitableIntegration(AppServerIntegration integration) {
        return ApplicationServerPanel.findLocalConfigurationFactory(integration) != null;
    }

    @Nullable
    public static ConfigurationFactory findLocalConfigurationFactory(AppServerIntegration integration) {
        for (ConfigurationType type : ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList()) {
            if (!(type instanceof JavaeeAppServerConfigurationType) || !integration.equals(((JavaeeAppServerConfigurationType)type).getIntegration())) continue;
            return ((JavaeeAppServerConfigurationType)type).getLocalFactory();
        }
        return null;
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    @Nullable
    public ApplicationServer getSelectedServer() {
        return (ApplicationServer)this.myComboBox.getSelectedItem();
    }

    public void setSelectedServer(@Nullable ApplicationServer value) {
        this.myComboBox.setSelectedItem(value);
    }

    public List<ApplicationServer> getServers() {
        ComboBoxModel<ApplicationServer> model = this.myComboBox.getModel();
        ArrayList<ApplicationServer> servers = new ArrayList<ApplicationServer>();
        for (int i = 0; i < model.getSize(); ++i) {
            ApplicationServer server = (ApplicationServer)model.getElementAt(i);
            if (server == null) continue;
            servers.add(server);
        }
        return servers;
    }

    public JBLabel getLabel() {
        return this.myLabel;
    }

    public JPanel getContextComponent() {
        return this.myContextComponent;
    }

    public void setContextComponent(JPanel contextComponent) {
        this.myContextComponent = contextComponent;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JBLabel jBLabel;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), 4, 4, false, false));
        this.myLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/AppServersIntegrationBundle", ApplicationServerPanel.class).getString("ApplicationServerPanel.label.application.server"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myComboBox = jComboBox;
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 3, null, new Dimension(200, -1), null));
        this.myNewButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/AppServersIntegrationBundle", ApplicationServerPanel.class).getString("ApplicationServerPanel.button.new"));
        jPanel.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 4, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        jBLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

