/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.ui.browser.strategy;

import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.swagger.core.ui.SwPreviewType;
import com.intellij.swagger.core.ui.browser.strategy.SwPreviewCustomization;
import com.intellij.swagger.core.ui.browser.strategy.SwPreviewProviderStrategy;
import com.intellij.swagger.core.ui.browser.strategy.SwaggerUiProviderStrategy;
import com.intellij.swagger.core.ui.jcefHandler.SwCefCorsRequestHandler;
import com.intellij.swagger.core.ui.jcefHandler.SwCefResourceRequestHandler;
import com.intellij.swagger.core.ui.utils.SwCommonJsUtilsKt;
import com.intellij.swagger.core.ui.utils.SwaggerUiJsUtilsKt;
import com.intellij.swagger.core.ui.utils.SwaggerUiScrollProvider;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefJSQuery;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefRequestHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/swagger/core/ui/browser/strategy/SwaggerUiProviderStrategy;", "Lcom/intellij/swagger/core/ui/browser/strategy/SwPreviewProviderStrategy;", "<init>", "()V", "installOn", "Lcom/intellij/swagger/core/ui/browser/strategy/SwPreviewCustomization;", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "cefBrowser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "SwaggerUiPreviewCustomization", "intellij.swagger.core"})
public final class SwaggerUiProviderStrategy
implements SwPreviewProviderStrategy {
    @NotNull
    public static final SwaggerUiProviderStrategy INSTANCE = new SwaggerUiProviderStrategy();

    private SwaggerUiProviderStrategy() {
    }

    @Override
    @NotNull
    public SwPreviewCustomization installOn(@NotNull TextEditor textEditor, @NotNull JBCefBrowser cefBrowser, @NotNull VirtualFile virtualFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)textEditor, (String)"textEditor");
        Intrinsics.checkNotNullParameter((Object)cefBrowser, (String)"cefBrowser");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JBCefJSQuery jBCefJSQuery = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)cefBrowser));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery, (String)"create(...)");
        JBCefJSQuery scrollQuery = jBCefJSQuery;
        JBCefJSQuery jBCefJSQuery2 = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)cefBrowser));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery2, (String)"create(...)");
        JBCefJSQuery statisticsQuery = jBCefJSQuery2;
        CefLoadHandlerAdapter scrollHandler2 = SwCommonJsUtilsKt.setupCefLoadHandler(scrollQuery, cefBrowser, (Function2<? super JBCefJSQuery, ? super JBCefBrowser, Unit>)((Function2)installOn.scrollHandler.1.INSTANCE));
        CefLoadHandlerAdapter statisticsHandler2 = SwCommonJsUtilsKt.setupCefLoadHandler(statisticsQuery, cefBrowser, (Function2<? super JBCefJSQuery, ? super JBCefBrowser, Unit>)((Function2)installOn.statisticsHandler.1.INSTANCE));
        SwCefResourceRequestHandler[] swCefResourceRequestHandlerArray = new SwCefResourceRequestHandler[]{new SwCefCorsRequestHandler()};
        CefRequestHandler cefRequestHandler = SwCommonJsUtilsKt.setupSwaggerResourcesRequestHandlerChain(cefBrowser, swCefResourceRequestHandlerArray);
        CefLifeSpanHandler browseUrlHandler = SwCommonJsUtilsKt.setupBrowseUrlHandler(cefBrowser);
        Function1<String, JBCefJSQuery.Response> previewToEditorNavigationHandler = SwCommonJsUtilsKt.setupNavigationFromPreviewToEditor(scrollQuery, textEditor, project);
        Function1<String, JBCefJSQuery.Response> jsStatisticsHandler = SwaggerUiJsUtilsKt.setupSwaggerUiJsStatisticsHandler(statisticsQuery, project);
        CaretListener navigationEditorCaretListener = SwCommonJsUtilsKt.setupNavigationEditorCaretListener(cefBrowser, textEditor, project, new SwaggerUiScrollProvider());
        return new SwaggerUiPreviewCustomization(scrollQuery, statisticsQuery, (CefLoadHandler)scrollHandler2, (CefLoadHandler)statisticsHandler2, cefRequestHandler, previewToEditorNavigationHandler, jsStatisticsHandler, navigationEditorCaretListener, browseUrlHandler);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b\u0012\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001f\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001f\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006."}, d2={"Lcom/intellij/swagger/core/ui/browser/strategy/SwaggerUiProviderStrategy$SwaggerUiPreviewCustomization;", "Lcom/intellij/swagger/core/ui/browser/strategy/SwPreviewCustomization;", "myScrollQuery", "Lcom/intellij/ui/jcef/JBCefJSQuery;", "myStatisticsQuery", "myScrollHandler", "Lorg/cef/handler/CefLoadHandler;", "myStatisticsHandler", "myCefRequestHandler", "Lorg/cef/handler/CefRequestHandler;", "myPreviewToEditorNavigationHandler", "Lkotlin/Function1;", "", "Lcom/intellij/ui/jcef/JBCefJSQuery$Response;", "myJsStatisticsHandler", "myEditorCaretListener", "Lcom/intellij/openapi/editor/event/CaretListener;", "myLifeSpanHandler", "Lorg/cef/handler/CefLifeSpanHandler;", "<init>", "(Lcom/intellij/ui/jcef/JBCefJSQuery;Lcom/intellij/ui/jcef/JBCefJSQuery;Lorg/cef/handler/CefLoadHandler;Lorg/cef/handler/CefLoadHandler;Lorg/cef/handler/CefRequestHandler;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lcom/intellij/openapi/editor/event/CaretListener;Lorg/cef/handler/CefLifeSpanHandler;)V", "getMyScrollQuery", "()Lcom/intellij/ui/jcef/JBCefJSQuery;", "getMyStatisticsQuery", "getMyScrollHandler", "()Lorg/cef/handler/CefLoadHandler;", "getMyStatisticsHandler", "getMyCefRequestHandler", "()Lorg/cef/handler/CefRequestHandler;", "getMyPreviewToEditorNavigationHandler", "()Lkotlin/jvm/functions/Function1;", "getMyJsStatisticsHandler", "getMyEditorCaretListener", "()Lcom/intellij/openapi/editor/event/CaretListener;", "getMyLifeSpanHandler", "()Lorg/cef/handler/CefLifeSpanHandler;", "previewType", "Lcom/intellij/swagger/core/ui/SwPreviewType;", "getPreviewType", "()Lcom/intellij/swagger/core/ui/SwPreviewType;", "removeFrom", "", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "cefBrowser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "intellij.swagger.core"})
    private static final class SwaggerUiPreviewCustomization
    implements SwPreviewCustomization {
        @NotNull
        private final JBCefJSQuery myScrollQuery;
        @NotNull
        private final JBCefJSQuery myStatisticsQuery;
        @NotNull
        private final CefLoadHandler myScrollHandler;
        @NotNull
        private final CefLoadHandler myStatisticsHandler;
        @NotNull
        private final CefRequestHandler myCefRequestHandler;
        @NotNull
        private final Function1<String, JBCefJSQuery.Response> myPreviewToEditorNavigationHandler;
        @NotNull
        private final Function1<String, JBCefJSQuery.Response> myJsStatisticsHandler;
        @NotNull
        private final CaretListener myEditorCaretListener;
        @NotNull
        private final CefLifeSpanHandler myLifeSpanHandler;
        @NotNull
        private final SwPreviewType previewType;

        public SwaggerUiPreviewCustomization(@NotNull JBCefJSQuery myScrollQuery, @NotNull JBCefJSQuery myStatisticsQuery, @NotNull CefLoadHandler myScrollHandler, @NotNull CefLoadHandler myStatisticsHandler, @NotNull CefRequestHandler myCefRequestHandler, @NotNull Function1<? super String, ? extends JBCefJSQuery.Response> myPreviewToEditorNavigationHandler, @NotNull Function1<? super String, ? extends JBCefJSQuery.Response> myJsStatisticsHandler, @NotNull CaretListener myEditorCaretListener, @NotNull CefLifeSpanHandler myLifeSpanHandler) {
            Intrinsics.checkNotNullParameter((Object)myScrollQuery, (String)"myScrollQuery");
            Intrinsics.checkNotNullParameter((Object)myStatisticsQuery, (String)"myStatisticsQuery");
            Intrinsics.checkNotNullParameter((Object)myScrollHandler, (String)"myScrollHandler");
            Intrinsics.checkNotNullParameter((Object)myStatisticsHandler, (String)"myStatisticsHandler");
            Intrinsics.checkNotNullParameter((Object)myCefRequestHandler, (String)"myCefRequestHandler");
            Intrinsics.checkNotNullParameter(myPreviewToEditorNavigationHandler, (String)"myPreviewToEditorNavigationHandler");
            Intrinsics.checkNotNullParameter(myJsStatisticsHandler, (String)"myJsStatisticsHandler");
            Intrinsics.checkNotNullParameter((Object)myEditorCaretListener, (String)"myEditorCaretListener");
            Intrinsics.checkNotNullParameter((Object)myLifeSpanHandler, (String)"myLifeSpanHandler");
            this.myScrollQuery = myScrollQuery;
            this.myStatisticsQuery = myStatisticsQuery;
            this.myScrollHandler = myScrollHandler;
            this.myStatisticsHandler = myStatisticsHandler;
            this.myCefRequestHandler = myCefRequestHandler;
            this.myPreviewToEditorNavigationHandler = myPreviewToEditorNavigationHandler;
            this.myJsStatisticsHandler = myJsStatisticsHandler;
            this.myEditorCaretListener = myEditorCaretListener;
            this.myLifeSpanHandler = myLifeSpanHandler;
            this.previewType = SwPreviewType.SWAGGER_UI;
        }

        @NotNull
        public final JBCefJSQuery getMyScrollQuery() {
            return this.myScrollQuery;
        }

        @NotNull
        public final JBCefJSQuery getMyStatisticsQuery() {
            return this.myStatisticsQuery;
        }

        @NotNull
        public final CefLoadHandler getMyScrollHandler() {
            return this.myScrollHandler;
        }

        @NotNull
        public final CefLoadHandler getMyStatisticsHandler() {
            return this.myStatisticsHandler;
        }

        @NotNull
        public final CefRequestHandler getMyCefRequestHandler() {
            return this.myCefRequestHandler;
        }

        @NotNull
        public final Function1<String, JBCefJSQuery.Response> getMyPreviewToEditorNavigationHandler() {
            return this.myPreviewToEditorNavigationHandler;
        }

        @NotNull
        public final Function1<String, JBCefJSQuery.Response> getMyJsStatisticsHandler() {
            return this.myJsStatisticsHandler;
        }

        @NotNull
        public final CaretListener getMyEditorCaretListener() {
            return this.myEditorCaretListener;
        }

        @NotNull
        public final CefLifeSpanHandler getMyLifeSpanHandler() {
            return this.myLifeSpanHandler;
        }

        @Override
        @NotNull
        public SwPreviewType getPreviewType() {
            return this.previewType;
        }

        @Override
        public void removeFrom(@NotNull TextEditor textEditor, @NotNull JBCefBrowser cefBrowser) {
            Intrinsics.checkNotNullParameter((Object)textEditor, (String)"textEditor");
            Intrinsics.checkNotNullParameter((Object)cefBrowser, (String)"cefBrowser");
            SwCommonJsUtilsKt.removeCefLoadHandler(cefBrowser, this.myScrollHandler);
            SwCommonJsUtilsKt.removeCefLoadHandler(cefBrowser, this.myStatisticsHandler);
            SwCommonJsUtilsKt.removeJsHandler(this.myScrollQuery, this.myPreviewToEditorNavigationHandler);
            SwCommonJsUtilsKt.removeJsHandler(this.myStatisticsQuery, this.myJsStatisticsHandler);
            SwCommonJsUtilsKt.removeEditorCaretListener(textEditor, this.myEditorCaretListener);
            SwCommonJsUtilsKt.removeCefRequestHandler(cefBrowser, this.myCefRequestHandler);
            SwCommonJsUtilsKt.removeCefLifeSpanHandler(cefBrowser, this.myLifeSpanHandler);
        }
    }
}

