/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.mongodb.json.intentions;

import com.intellij.json.intentions.AbstractSortPropertiesSession;
import com.intellij.json.intentions.JsonSortPropertiesIntention;
import com.intellij.modcommand.ActionContext;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonObject;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonProperty;
import com.intellij.persistence.mongodb.json.psi.impl.MongoDBJsonRecursiveElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u0006\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/persistence/mongodb/json/intentions/MongoDBJsonSortPropertiesIntention;", "Lcom/intellij/json/intentions/JsonSortPropertiesIntention;", "<init>", "()V", "createSession", "Lcom/intellij/json/intentions/AbstractSortPropertiesSession;", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/modcommand/ActionContext;", "file", "Lcom/intellij/psi/PsiFile;", "MongoSession", "intellij.javaee.persistence.impl"})
public final class MongoDBJsonSortPropertiesIntention
extends JsonSortPropertiesIntention {
    @NotNull
    protected AbstractSortPropertiesSession<? extends PsiElement, ? extends PsiElement> createSession(@NotNull ActionContext context, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new MongoSession(context, file);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0014J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0014J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0014J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00022\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00160\u0019H\u0014\u00a8\u0006\u001a"}, d2={"Lcom/intellij/persistence/mongodb/json/intentions/MongoDBJsonSortPropertiesIntention$MongoSession;", "Lcom/intellij/json/intentions/AbstractSortPropertiesSession;", "Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonObject;", "Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonProperty;", "context", "Lcom/intellij/modcommand/ActionContext;", "file", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/modcommand/ActionContext;Lcom/intellij/psi/PsiFile;)V", "findRootObject", "collectObjects", "", "rootObj", "getProperties", "", "obj", "getPropertyName", "", "prop", "getParentObject", "traverseObjects", "", "root", "visitor", "Lkotlin/Function1;", "intellij.javaee.persistence.impl"})
    private static final class MongoSession
    extends AbstractSortPropertiesSession<MongoDBJsonObject, MongoDBJsonProperty> {
        public MongoSession(@NotNull ActionContext context, @NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super(context, file);
        }

        @Nullable
        protected MongoDBJsonObject findRootObject() {
            int offset = this.getContext().offset();
            MongoDBJsonObject initObj = (MongoDBJsonObject)PsiTreeUtil.getParentOfType((PsiElement)this.getFile().findElementAt(offset), MongoDBJsonObject.class);
            return (MongoDBJsonObject)this.adjustToSelectionContainer(initObj);
        }

        @NotNull
        protected Set<MongoDBJsonObject> collectObjects(@NotNull MongoDBJsonObject rootObj) {
            Intrinsics.checkNotNullParameter((Object)rootObj, (String)"rootObj");
            return this.collectIntersectingObjects(rootObj);
        }

        @NotNull
        protected List<MongoDBJsonProperty> getProperties(@NotNull MongoDBJsonObject obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            List<MongoDBJsonProperty> list = obj.getPropertyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getPropertyList(...)");
            return list;
        }

        @Nullable
        protected String getPropertyName(@NotNull MongoDBJsonProperty prop) {
            Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
            return prop.getName();
        }

        @Nullable
        protected MongoDBJsonObject getParentObject(@NotNull MongoDBJsonObject obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            return (MongoDBJsonObject)PsiTreeUtil.getParentOfType((PsiElement)obj, MongoDBJsonObject.class);
        }

        protected void traverseObjects(@NotNull MongoDBJsonObject root, @NotNull Function1<? super MongoDBJsonObject, Unit> visitor) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
            new MongoDBJsonRecursiveElementVisitor(visitor){
                final /* synthetic */ Function1<MongoDBJsonObject, Unit> $visitor;
                {
                    this.$visitor = $visitor;
                }

                public void visitObject(MongoDBJsonObject o) {
                    Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                    this.$visitor.invoke((Object)o);
                    super.visitObject(o);
                }
            }.visitObject(root);
        }
    }
}

