/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.util;

import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PersistenceUtil {
    @NotNull
    public static Collection<DbDataSource> getDataSources(@NotNull Project project, Iterable<? extends PersistencePackage> units) {
        if (project == null) {
            PersistenceUtil.$$$reportNull$$$0(0);
        }
        DbPsiFacade facade = DbPsiFacade.getInstance((Project)project);
        HashSet<DbDataSource> set = new HashSet<DbDataSource>();
        for (PersistencePackage persistencePackage : units) {
            List<PersistenceFacet> facets = PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceFacets(persistencePackage);
            if (!facets.isEmpty()) {
                for (PersistenceFacet facet : facets) {
                    String dataSourceName = facet.getDataSourceId(persistencePackage);
                    if (dataSourceName == null) continue;
                    ContainerUtil.addIfNotNull(set, (Object)facade.findDataSource(dataSourceName));
                }
                continue;
            }
            GenericValue<String> value = persistencePackage.getModelHelper().getDataSourceName();
            String dataSourceName = value != null ? (String)value.getValue() : null;
            if (dataSourceName == null) continue;
            ContainerUtil.addIfNotNull(set, (Object)((DbDataSource)ContainerUtil.find((Iterable)facade.getDataSources(), element -> Objects.equals(element.getUniqueId(), dataSourceName) || Objects.equals(element.getName(), dataSourceName))));
        }
        HashSet<DbDataSource> hashSet = set;
        if (hashSet == null) {
            PersistenceUtil.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @NotNull
    public static Collection<DbDataSource> getDataSources(@Nullable PersistenceMappings entityMappings) {
        if (entityMappings == null) {
            List<DbDataSource> list = Collections.emptyList();
            if (list == null) {
                PersistenceUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        PersistenceModelBrowser modelBrowser = PersistenceHelper.getHelper().getSharedModelBrowser();
        return PersistenceUtil.getDataSources(entityMappings.getPsiManager().getProject(), modelBrowser.getPersistenceUnits(entityMappings));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/persistence/util/PersistenceUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/persistence/util/PersistenceUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDataSources";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

