/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.diff;

import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.Fraction;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.model.CommonTransformationsProxyCallTreeNode;
import com.intellij.profiler.model.ProxyCallTreeNode;
import com.intellij.profiler.model.diff.DiffCallTreeNode;
import com.intellij.profiler.ui.callusage.UIVisibleCallTreeModel;
import com.intellij.profiler.ui.diff.DifferentialFlameGraphFractionRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\"\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00040\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u0016J$\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u0014J$\u0010\u0013\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u0014J$\u0010\u0015\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00042\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/profiler/ui/diff/UIVisibleCallTreeModelForDifferentialFlameGraph;", "Lcom/intellij/profiler/ui/callusage/UIVisibleCallTreeModel;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "dataModelRoot", "Lcom/intellij/profiler/model/CallTreeNode;", "<init>", "(Lcom/intellij/profiler/model/CallTreeNode;)V", "myFractionRule", "Lcom/intellij/profiler/ui/diff/DifferentialFlameGraphFractionRule;", "updateFractionRule", "", "fractionRule", "getDataModelBaseChildren", "", "dataModelBaseNode", "getFractionOfParent", "Lcom/intellij/profiler/api/Fraction;", "thisNode", "parentNode", "getFractionOfRoot", "rootNode", "getFraction", "otherNode", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nDifferentialFlameGraphModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DifferentialFlameGraphModel.kt\ncom/intellij/profiler/ui/diff/UIVisibleCallTreeModelForDifferentialFlameGraph\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n774#2:55\n865#2,2:56\n*S KotlinDebug\n*F\n+ 1 DifferentialFlameGraphModel.kt\ncom/intellij/profiler/ui/diff/UIVisibleCallTreeModelForDifferentialFlameGraph\n*L\n34#1:55\n34#1:56,2\n*E\n"})
public final class UIVisibleCallTreeModelForDifferentialFlameGraph
extends UIVisibleCallTreeModel<BaseCallStackElement> {
    private DifferentialFlameGraphFractionRule myFractionRule;

    public UIVisibleCallTreeModelForDifferentialFlameGraph(@NotNull CallTreeNode<? extends BaseCallStackElement> dataModelRoot) {
        Intrinsics.checkNotNullParameter(dataModelRoot, (String)"dataModelRoot");
        super(dataModelRoot);
    }

    public final void updateFractionRule(@NotNull DifferentialFlameGraphFractionRule fractionRule) {
        Intrinsics.checkNotNullParameter((Object)fractionRule, (String)"fractionRule");
        this.myFractionRule = fractionRule;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<CallTreeNode<BaseCallStackElement>> getDataModelBaseChildren(@NotNull CallTreeNode<? extends BaseCallStackElement> dataModelBaseNode) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(dataModelBaseNode, (String)"dataModelBaseNode");
        Iterable $this$filter$iv = super.getDataModelBaseChildren(dataModelBaseNode);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CallTreeNode it = (CallTreeNode)element$iv$iv;
            boolean bl = false;
            DifferentialFlameGraphFractionRule differentialFlameGraphFractionRule = this.myFractionRule;
            if (differentialFlameGraphFractionRule == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myFractionRule");
                differentialFlameGraphFractionRule = null;
            }
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.profiler.model.diff.DiffCallTreeNode<com.intellij.profiler.api.BaseCallStackElement>");
            if (!differentialFlameGraphFractionRule.shouldBeVisible((DiffCallTreeNode)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    protected Fraction getFractionOfParent(@NotNull CallTreeNode<? extends BaseCallStackElement> thisNode, @NotNull CallTreeNode<? extends BaseCallStackElement> parentNode) {
        Intrinsics.checkNotNullParameter(thisNode, (String)"thisNode");
        Intrinsics.checkNotNullParameter(parentNode, (String)"parentNode");
        return this.getFraction(thisNode, parentNode);
    }

    @Override
    @NotNull
    protected Fraction getFractionOfRoot(@NotNull CallTreeNode<? extends BaseCallStackElement> thisNode, @NotNull CallTreeNode<? extends BaseCallStackElement> rootNode) {
        Intrinsics.checkNotNullParameter(thisNode, (String)"thisNode");
        Intrinsics.checkNotNullParameter(rootNode, (String)"rootNode");
        return this.getFraction(thisNode, rootNode);
    }

    private final Fraction getFraction(CallTreeNode<? extends BaseCallStackElement> thisNode, CallTreeNode<? extends BaseCallStackElement> otherNode) {
        Fraction fraction;
        CallTreeNode<? extends BaseCallStackElement> callTreeNode = thisNode;
        if (callTreeNode instanceof DiffCallTreeNode) {
            DifferentialFlameGraphFractionRule differentialFlameGraphFractionRule = this.myFractionRule;
            if (differentialFlameGraphFractionRule == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myFractionRule");
                differentialFlameGraphFractionRule = null;
            }
            DiffCallTreeNode diffCallTreeNode = (DiffCallTreeNode)thisNode;
            Intrinsics.checkNotNull(otherNode, (String)"null cannot be cast to non-null type com.intellij.profiler.model.diff.DiffCallTreeNode<*>");
            fraction = differentialFlameGraphFractionRule.getFraction(diffCallTreeNode, (DiffCallTreeNode)otherNode);
        } else if (callTreeNode instanceof ProxyCallTreeNode) {
            DifferentialFlameGraphFractionRule differentialFlameGraphFractionRule = this.myFractionRule;
            if (differentialFlameGraphFractionRule == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myFractionRule");
                differentialFlameGraphFractionRule = null;
            }
            Intrinsics.checkNotNull(thisNode, (String)"null cannot be cast to non-null type com.intellij.profiler.model.CommonTransformationsProxyCallTreeNode<*>");
            CommonTransformationsProxyCallTreeNode commonTransformationsProxyCallTreeNode = (CommonTransformationsProxyCallTreeNode)thisNode;
            Intrinsics.checkNotNull(otherNode, (String)"null cannot be cast to non-null type com.intellij.profiler.model.CommonTransformationsProxyCallTreeNode<*>");
            fraction = differentialFlameGraphFractionRule.getFraction(commonTransformationsProxyCallTreeNode, (CommonTransformationsProxyCallTreeNode)otherNode);
        } else {
            throw new IllegalArgumentException("Here shouldn't be such nodes");
        }
        return fraction;
    }
}

