/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorMode;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorModeKt;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookVisualizationCoroutine;
import com.intellij.notebooks.visualization.UpdateContext;
import com.intellij.notebooks.visualization.ui.ActionToGutterRendererAdapter;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellViewComponent;
import com.intellij.notebooks.visualization.ui.InputComponent;
import com.intellij.notebooks.visualization.ui.NotebookEditorUiUtilKt;
import com.intellij.notebooks.visualization.ui.TextEditorCellViewComponent;
import com.intellij.notebooks.visualization.ui.UpdateManager;
import com.intellij.notebooks.visualization.ui.UpdateManagerKt;
import com.intellij.notebooks.visualization.ui.providers.scroll.NotebookEditorScrollEndDetector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.CoroutineScopeKt;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000_\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b*\u0001\u000e\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u001bH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0015H\u0016J\b\u0010$\u001a\u00020\u001bH\u0016J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u0012H\u0016J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u0012H\u0016J\b\u0010(\u001a\u00020\u001bH\u0016J\b\u0010)\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/notebooks/visualization/ui/TextEditorCellViewComponent;", "Lcom/intellij/notebooks/visualization/ui/EditorCellViewComponent;", "Lcom/intellij/notebooks/visualization/ui/InputComponent;", "cell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "<init>", "(Lcom/intellij/notebooks/visualization/ui/EditorCell;)V", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "getEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "mouseListener", "com/intellij/notebooks/visualization/ui/TextEditorCellViewComponent$mouseListener$1", "Lcom/intellij/notebooks/visualization/ui/TextEditorCellViewComponent$mouseListener$1;", "presentationToInlay", "", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "Lcom/intellij/openapi/editor/Inlay;", "gutterIconStickToFirstVisibleLine", "", "getGutterIconStickToFirstVisibleLine", "()Z", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "updateGutterIcons", "", "dispose", "disposeExistingHighlighter", "calculateBounds", "Ljava/awt/Rectangle;", "updateFolding", "ctx", "Lcom/intellij/notebooks/visualization/UpdateContext;", "folded", "requestCaret", "addInlayBelow", "presentation", "removeInlayBelow", "doCheckAndRebuildInlays", "isInlaysBroken", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nTextEditorCellViewComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextEditorCellViewComponent.kt\ncom/intellij/notebooks/visualization/ui/TextEditorCellViewComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,194:1\n1#2:195\n1869#3,2:196\n1869#3,2:198\n295#3,2:200\n*S KotlinDebug\n*F\n+ 1 TextEditorCellViewComponent.kt\ncom/intellij/notebooks/visualization/ui/TextEditorCellViewComponent\n*L\n179#1:196,2\n180#1:198,2\n133#1:200,2\n*E\n"})
public final class TextEditorCellViewComponent
extends EditorCellViewComponent
implements InputComponent {
    @NotNull
    private final EditorCell cell;
    @Nullable
    private RangeHighlighter highlighter;
    @NotNull
    private final mouseListener.1 mouseListener;
    @NotNull
    private final Map<InlayPresentation, Inlay<?>> presentationToInlay;
    @NotNull
    private final CoroutineScope coroutineScope;

    /*
     * WARNING - void declaration
     */
    public TextEditorCellViewComponent(@NotNull EditorCell cell) {
        void it;
        CoroutineScope coroutineScope;
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        this.cell = cell;
        this.mouseListener = new MouseAdapter(this){
            final /* synthetic */ TextEditorCellViewComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                IntRange intRange = TextEditorCellViewComponent.access$getCell$p(this.this$0).getInterval().getLines();
                int n = intRange.getFirst();
                int n2 = intRange.getLast();
                int n3 = TextEditorCellViewComponent.access$getEditor((TextEditorCellViewComponent)this.this$0).xyToLogicalPosition((Point)e.getPoint()).line;
                boolean bl = n <= n3 ? n3 <= n2 : false;
                if (bl) {
                    NotebookEditorModeKt.setMode((Editor)TextEditorCellViewComponent.access$getEditor(this.this$0), NotebookEditorMode.EDIT);
                }
            }
        };
        this.presentationToInlay = new LinkedHashMap();
        CoroutineScope coroutineScope2 = coroutineScope = com.intellij.platform.util.coroutines.CoroutineScopeKt.childScope$default((CoroutineScope)NotebookVisualizationCoroutine.Utils.INSTANCE.getEdtScope(), (String)"TextEditorCellViewComponent", null, (boolean)false, (int)6, null);
        TextEditorCellViewComponent textEditorCellViewComponent = this;
        boolean bl = false;
        Disposer.register((Disposable)((Disposable)this), (Disposable)CoroutineScopeKt.asDisposable((CoroutineScope)it));
        textEditorCellViewComponent.coroutineScope = coroutineScope;
        this.getEditor().getContentComponent().addMouseListener(this.mouseListener);
        Disposer.register((Disposable)((Disposable)this), () -> TextEditorCellViewComponent._init_$lambda$0(this));
        com.intellij.notebooks.ui.NotebookEditorUiUtilKt.bind((ObservableProperty)this.cell.getGutterAction(), (Disposable)this, arg_0 -> TextEditorCellViewComponent._init_$lambda$1(this, arg_0));
        com.intellij.notebooks.ui.NotebookEditorUiUtilKt.afterDistinctChange((ObservableProperty)this.cell.isUnfolded(), (Disposable)this, arg_0 -> TextEditorCellViewComponent._init_$lambda$2(this, arg_0));
        CoroutineScopeKt.cancelOnDispose((Job)BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ TextEditorCellViewComponent this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Flow<Unit> detector = NotebookEditorScrollEndDetector.Companion.get(this.this$0.cell.getEditor());
                        Flow<Unit> flow = detector;
                        if (flow == null || (flow = flow.getDebouncedScrollFlow()) == null) break;
                        this.L$0 = SpillingKt.nullOutSpilledVariable(detector);
                        this.label = 1;
                        Object object2 = flow.collect(new FlowCollector(){

                            public final Object emit(Unit it, Continuation<? super Unit> $completion) {
                                this$0.updateGutterIcons();
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 == object) {
                            return object;
                        }
                        break;
                    }
                    case 1: {
                        NotebookEditorScrollEndDetector detector = (NotebookEditorScrollEndDetector)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        break;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null), (Disposable)((Disposable)this));
    }

    private final EditorEx getEditor() {
        return (EditorEx)this.cell.getEditor();
    }

    private final boolean getGutterIconStickToFirstVisibleLine() {
        return Registry.Companion.is("jupyter.run.cell.button.sticks.first.visible.line");
    }

    private final void updateGutterIcons() {
        this.disposeExistingHighlighter();
        if (!this.cell.isUnfolded().get().booleanValue()) {
            return;
        }
        AnAction anAction = (AnAction)this.cell.getGutterAction().get();
        if (anAction == null) {
            return;
        }
        AnAction gutterAction = anAction;
        NotebookCellLines.Interval interval = this.cell.getIntervalOrNull();
        if (interval == null) {
            return;
        }
        NotebookCellLines.Interval interval2 = interval;
        MarkupModelEx markupModelEx = this.getEditor().getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getMarkupModel(...)");
        MarkupModelEx markupModel = markupModelEx;
        int startOffset = this.getEditor().getDocument().getLineStartOffset(NotebookEditorUiUtilKt.computeFirstLineForHighlighter(interval2, this.getEditor(), this.getGutterIconStickToFirstVisibleLine()));
        int endOffset = this.getEditor().getDocument().getLineEndOffset(interval2.getLines().getLast());
        RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(startOffset, endOffset, NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.getEditor()).getCellBackgroundHighlightLayer(), new TextAttributes(), HighlighterTargetArea.LINES_IN_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
        RangeHighlighter highlighter = rangeHighlighter;
        highlighter.setGutterIconRenderer((GutterIconRenderer)new ActionToGutterRendererAdapter(gutterAction));
        this.highlighter = highlighter;
    }

    public void dispose() {
        UpdateManager.update$default(UpdateManagerKt.getUpdateManager((Editor)this.getEditor()), false, false, arg_0 -> TextEditorCellViewComponent.dispose$lambda$0(this, arg_0), 3, null);
    }

    private final void disposeExistingHighlighter() {
        RangeHighlighter rangeHighlighter = this.highlighter;
        if (rangeHighlighter == null) {
            return;
        }
        RangeHighlighter highlighter = rangeHighlighter;
        this.highlighter = null;
        this.getEditor().getMarkupModel().removeHighlighter(highlighter);
        highlighter.dispose();
    }

    @Override
    @NotNull
    public Rectangle calculateBounds() {
        NotebookCellLines.Interval interval = this.cell.getInterval();
        int startOffset = this.getEditor().getDocument().getLineStartOffset(interval.getLines().getFirst());
        Point point = this.getEditor().offsetToXY(startOffset);
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"offsetToXY(...)");
        Point startLocation = point;
        int endOffset = this.getEditor().getDocument().getLineEndOffset(interval.getLines().getLast());
        Point point2 = this.getEditor().offsetToXY(endOffset);
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"offsetToXY(...)");
        Point endLocation = point2;
        int height = endLocation.y + this.getEditor().getLineHeight() - startLocation.y;
        int width = endLocation.x - startLocation.x;
        Dimension dimension = new Dimension(width, height);
        return new Rectangle(startLocation, dimension);
    }

    @Override
    public void updateFolding(@NotNull UpdateContext ctx, boolean folded) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        NotebookCellLines.Interval interval = this.cell.getInterval();
        int startOffset = this.getEditor().getDocument().getLineStartOffset(interval.getLines().getFirst() + 1);
        int endOffset = this.getEditor().getDocument().getLineEndOffset(interval.getLines().getLast());
        FoldRegion currentFoldingRegion = this.getEditor().getFoldingModel().getFoldRegion(startOffset, endOffset);
        if (currentFoldingRegion == null) {
            ctx.addFoldingOperation((Function1<? super FoldingModelEx, Unit>)((Function1)arg_0 -> TextEditorCellViewComponent.updateFolding$lambda$0(this, startOffset, endOffset, arg_0)));
        } else {
            ctx.addFoldingOperation((Function1<? super FoldingModelEx, Unit>)((Function1)arg_0 -> TextEditorCellViewComponent.updateFolding$lambda$1(folded, currentFoldingRegion, arg_0)));
        }
    }

    @Override
    public void requestCaret() {
        IntRange lines = this.cell.getInterval().getLines();
        int offset = this.getEditor().getDocument().getLineStartOffset(lines.getFirst() + 1);
        this.getEditor().getCaretModel().moveToOffset(offset);
    }

    @Override
    public void addInlayBelow(@NotNull InlayPresentation presentation) {
        block0: {
            Inlay inlay;
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            Inlay inlay2 = this.getEditor().getInlayModel().addBlockElement(this.getEditor().getDocument().getLineEndOffset(this.cell.getInterval().getLines().getLast()), new InlayProperties().showAbove(false).showWhenFolded(true), (EditorCustomElementRenderer)new PresentationRenderer(presentation));
            if (inlay2 == null) break block0;
            Inlay inlay3 = inlay = inlay2;
            boolean bl = false;
            this.presentationToInlay.put(presentation, inlay3);
            Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)inlay3));
        }
    }

    @Override
    public void removeInlayBelow(@NotNull InlayPresentation presentation) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            Inlay<?> inlay = this.presentationToInlay.remove(presentation);
            if (inlay == null) break block0;
            Inlay<?> inlay2 = inlay;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)inlay2));
        }
    }

    @Override
    public void doCheckAndRebuildInlays() {
        if (this.isInlaysBroken()) {
            List presentations = CollectionsKt.toList((Iterable)this.presentationToInlay.keySet());
            Iterable $this$forEach$iv = this.presentationToInlay.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Inlay inlay = (Inlay)element$iv;
                boolean bl = false;
                Disposer.dispose((Disposable)((Disposable)inlay));
            }
            $this$forEach$iv = presentations;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                InlayPresentation it = (InlayPresentation)element$iv;
                boolean bl = false;
                this.addInlayBelow(it);
            }
        }
    }

    private final boolean isInlaysBroken() {
        NotebookCellLines.Interval interval = this.cell.getIntervalOrNull();
        if (interval == null) {
            return true;
        }
        NotebookCellLines.Interval interval2 = interval;
        int offset = this.getEditor().getDocument().getLineEndOffset(interval2.getLines().getLast());
        for (Inlay<?> inlay : this.presentationToInlay.values()) {
            if (inlay.isValid() && inlay.getOffset() == offset) continue;
            return true;
        }
        return false;
    }

    private static final void _init_$lambda$0(TextEditorCellViewComponent this$0) {
        this$0.getEditor().getContentComponent().removeMouseListener(this$0.mouseListener);
    }

    private static final Unit _init_$lambda$1(TextEditorCellViewComponent this$0, AnAction it) {
        this$0.updateGutterIcons();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(TextEditorCellViewComponent this$0, boolean it) {
        this$0.updateGutterIcons();
        return Unit.INSTANCE;
    }

    private static final Unit dispose$lambda$0(TextEditorCellViewComponent this$0, UpdateContext it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.disposeExistingHighlighter();
        return Unit.INSTANCE;
    }

    private static final Unit updateFolding$lambda$0(TextEditorCellViewComponent this$0, int $startOffset, int $endOffset, FoldingModelEx foldingModel) {
        block3: {
            String firstNotEmptyString;
            String string;
            Object v2;
            FoldRegion foldRegion;
            block2: {
                Intrinsics.checkNotNullParameter((Object)foldingModel, (String)"foldingModel");
                String string2 = this$0.getEditor().getDocument().getText(new TextRange($startOffset, $endOffset));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                String text = string2;
                Iterable $this$firstOrNull$iv = StringsKt.lines((CharSequence)text);
                boolean $i$f$firstOrNull = false;
                foldRegion = $this$firstOrNull$iv.iterator();
                while (foldRegion.hasNext()) {
                    Object element$iv = foldRegion.next();
                    String it = (String)element$iv;
                    boolean bl = false;
                    boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                    if (!bl2) continue;
                    v2 = element$iv;
                    break block2;
                }
                v2 = null;
            }
            if ((string = (firstNotEmptyString = (String)v2)) == null) {
                string = "\u2026";
            }
            String string3 = StringUtil.shortenTextWithEllipsis((String)string, (int)20, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"shortenTextWithEllipsis(...)");
            String placeholder = string3;
            FoldRegion foldRegion2 = foldingModel.createFoldRegion($startOffset, $endOffset, placeholder, null, false);
            if (foldRegion2 == null) break block3;
            FoldRegion $this$updateFolding_u24lambda_u240_u241 = foldRegion = foldRegion2;
            boolean bl = false;
            FoldingModelImpl.hideGutterRendererForCollapsedRegion((FoldRegion)$this$updateFolding_u24lambda_u240_u241);
            $this$updateFolding_u24lambda_u240_u241.setExpanded(false);
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateFolding$lambda$1(boolean $folded, FoldRegion $currentFoldingRegion, FoldingModelEx foldingModel) {
        Intrinsics.checkNotNullParameter((Object)foldingModel, (String)"foldingModel");
        if ($folded) {
            $currentFoldingRegion.setExpanded(false);
        } else {
            foldingModel.removeFoldRegion($currentFoldingRegion);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ EditorEx access$getEditor(TextEditorCellViewComponent $this) {
        return $this.getEditor();
    }
}

